/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.JTranscSystem;
import com.jtransc.annotation.JTranscKeep;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.haxe.HaxeAddMembers;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.ds.FastIdentitySet;
import com.jtransc.ds.FastStringMap;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.jtransc.JTranscCoreReflection;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

@HaxeAddMembers(value={"public var _hxClass:Class<Dynamic> = null;", "public var _hxProxyClass:Class<Dynamic> = null;", "public var _hxFfiClass:Class<Dynamic> = null;", "public var _internalName = '';", "public var _parent:String = null;", "public var _interfaces:Array<String> = [];", "public var _fields = [];", "public var _modifiers = 0;", "public var _methods:Array<{% CLASS java.lang.reflect.Method %}> = [];", "public var _constructors = [];", "public var _annotations = [];", "public var _methodsById = null;", "public function populateMethodsById() {\n  if (_methodsById != null) return;\n  _methodsById = new Map<Int, {% CLASS java.lang.reflect.Method %}>();\n  function populate(clazz:{% CLASS java.lang.Class %}) {\n    for (m in clazz._methods) _methodsById.set(m.{% FIELD java.lang.reflect.Method:id %}, m);\n    if (clazz._parent != null) populate(HaxeNatives.resolveClass(clazz._parent));\n    for (i in clazz._interfaces) populate(HaxeNatives.resolveClass(i));\n  }\n  populate(this);\n}\n", "public function locateMethodById(id:Int) { populateMethodsById(); return _methodsById.get(id); }"})
public final class Class<T>
implements Serializable,
Type,
GenericDeclaration,
AnnotatedElement {
    @JTranscKeep
    private String name;
    public int id;
    private boolean primitive = false;
    private int modifiers;
    private static final int ANNOTATION = 8192;
    private static final int ENUM = 16384;
    private static final int SYNTHETIC = 4096;
    private static FastStringMap<Class<?>> _classCache = new FastStringMap();
    private FastIdentitySet<Class<?>> allRelatedClasses = null;
    private volatile transient T[] enumConstants = null;
    private FastStringMap<Field> _fieldsByName;
    private FastStringMap<Field> _declaredFieldsByName;

    @HaxeMethodBody(value="return HaxeArrayAny.fromArray(_fields, '[Ljava.lang.reflect.Field;');")
    @JTranscMethodBody(target="js", value={"return JA_L.fromArrayOrEmpty(this._fields, '[Ljava.lang.reflect.Field;');"})
    public Field[] getDeclaredFields() throws SecurityException {
        return JTranscCoreReflection.getDeclaredFields(this);
    }

    @HaxeMethodBody(value="return HaxeArrayAny.fromArray(_methods, '[Ljava.lang.reflect.Method;');")
    @JTranscMethodBody(target="js", value={"return JA_L.fromArrayOrEmpty(this._methods, '[Ljava.lang.reflect.Method;');"})
    public Method[] getDeclaredMethods() throws SecurityException {
        return JTranscCoreReflection.getDeclaredMethods(this);
    }

    public Constructor<?>[] getDeclaredConstructors() throws SecurityException {
        Constructor<?>[] constructors = this._getDeclaredConstructors();
        return constructors != null ? constructors : new Constructor[]{};
    }

    @HaxeMethodBody(value="return HaxeArrayAny.fromArray(_constructors, '[Ljava.lang.reflect.Constructor;');")
    @JTranscMethodBody(target="js", value={"return JA_L.fromArrayOrEmpty(this._constructors, '[Ljava.lang.reflect.Constructor;');"})
    private Constructor<?>[] _getDeclaredConstructors() throws SecurityException {
        return JTranscCoreReflection.getDeclaredConstructors(this);
    }

    @Override
    @HaxeMethodBody(value="return HaxeArrayAny.fromArray(_annotations, '[Ljava.lang.Annotation;');")
    @JTranscMethodBody(target="js", value={"return JA_L.fromArrayOrEmpty(this._annotations, '[Ljava.lang.Annotation;');"})
    public Annotation[] getDeclaredAnnotations() {
        return JTranscCoreReflection.getDeclaredAnnotations();
    }

    @HaxeMethodBody(value="return (_parent != null) ? HaxeNatives.resolveClass(_parent) : null;")
    public Class<? super T> getSuperclass() {
        return Class.forName0(this.getSuperclassName());
    }

    @JTranscMethodBody(target="js", value={"return N.str(this._superclass);"})
    private String getSuperclassName() {
        return JTranscCoreReflection.getClassNameById(JTranscCoreReflection.getSuperclassId(JTranscCoreReflection.getClassId(this)));
    }

    public Class<?>[] getInterfaces() {
        String[] names = this.getInterfaceNames();
        Class[] out = new Class[names.length];
        for (int n = 0; n < out.length; ++n) {
            out[n] = Class.forName0(names[n]);
        }
        return out;
    }

    @HaxeMethodBody(value="return HaxeNatives.strArray(_interfaces);")
    @JTranscMethodBody(target="js", value={"return N.strArrayOrEmpty(this._interfaces);"})
    private String[] getInterfaceNames() {
        int[] ids = JTranscCoreReflection.getInterfaceIds(this.id);
        String[] out = new String[ids.length];
        for (int n = 0; n < ids.length; ++n) {
            out[n] = JTranscCoreReflection.getClassNameById(ids[n]);
        }
        return out;
    }

    @HaxeMethodBody(value="return _modifiers;")
    public int getModifiers() {
        return this.modifiers;
    }

    public T newInstance() throws InstantiationException, IllegalAccessException {
        try {
            Constructor<T> constructor = this.getDeclaredConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new InstantiationException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    public native Class<?>[] getDeclaredClasses() throws SecurityException;

    public native Method getEnclosingMethod();

    public native Constructor<?> getEnclosingConstructor() throws SecurityException;

    public native URL getResource(String var1);

    @HaxeMethodBody(value="return Std.is(p0, _hxClass);")
    @JTranscMethodBody(target="js", value={"return N.isInstanceOfClass(p0, this);"})
    public boolean isInstance(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> objClass = obj.getClass();
        return this.isAssignableFrom(objClass);
    }

    public native InputStream getResourceAsStream(String var1);

    public ClassLoader getClassLoader() {
        return _ClassInternalUtils.getSystemClassLoader();
    }

    public native TypeVariable<Class<T>>[] getTypeParameters();

    public native Type getGenericSuperclass();

    public native Package getPackage();

    public native Type[] getGenericInterfaces();

    public Class<?> getComponentType() {
        if (this.isArray()) {
            try {
                return Class.forName(this.getName().substring(1));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public native Object[] getSigners();

    public native Class<?> getDeclaringClass() throws SecurityException;

    public native Class<?> getEnclosingClass() throws SecurityException;

    public native Class<?>[] getClasses();

    private Class() {
    }

    Class(String name) throws ClassNotFoundException {
        this.name = name;
        this.primitive = false;
        if (!this._check()) {
            throw new ClassNotFoundException("Can't find class '" + name + "'");
        }
    }

    Class(String name, boolean primitive) {
        this.name = name;
        this.primitive = primitive;
    }

    @HaxeMethodBody(value="return R.__initClass(this);")
    @JTranscMethodBody(target="js", value={"return R.__initClass(this);"})
    private boolean _check() {
        JTranscCoreReflection.getClassNames();
        if (JTranscCoreReflection.hasClassWithName(this.name)) {
            this.id = JTranscCoreReflection.getClassIdWithName(this.name);
            this.modifiers = JTranscCoreReflection.getModifiersWithId(this.id);
        } else {
            this.id = -1;
        }
        return this.isArray() || this.id >= 0;
    }

    public String getName() {
        return this.name;
    }

    static Class<?> getPrimitiveClass(String name) {
        return new Class(name, true);
    }

    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.name;
    }

    public native String toGenericString();

    static Class<?> forName0(String className) {
        if (className == null) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        Class result;
        if (className == null) {
            return null;
        }
        if (className.length() == 1) {
            switch (className.charAt(0)) {
                case 'V': {
                    return Void.TYPE;
                }
                case 'Z': {
                    return Boolean.TYPE;
                }
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
            }
        }
        if (className.startsWith("L") && className.endsWith(";")) {
            return Class.forName(className.substring(1, className.length() - 1).replace('/', '.'));
        }
        if (!_classCache.has(className)) {
            _classCache.set(className, new Class(className));
        }
        if ((result = (Class)_classCache.get(className)) == null) {
            System.err.println("Couldn't find class " + className);
        }
        return result;
    }

    public static Class<?> forName(String name, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        return Class.forName(name);
    }

    private FastIdentitySet<Class<?>> getAllRelatedClasses() {
        if (this.allRelatedClasses == null) {
            this.allRelatedClasses = new FastIdentitySet();
            this.allRelatedClasses.add((Object)this);
            for (Class<?> i : this.getInterfaces()) {
                if (i == null) continue;
                this.allRelatedClasses.addAll(super.getAllRelatedClasses().toArray((Object[])new Class[0]));
            }
            Class<T> superclass = this.getSuperclass();
            if (superclass != null) {
                this.allRelatedClasses.addAll(super.getAllRelatedClasses().toArray((Object[])new Class[0]));
            }
        }
        return this.allRelatedClasses;
    }

    public boolean isAssignableFrom(Class<?> cls) {
        return super.getAllRelatedClasses().has((Object)this);
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public boolean isArray() {
        return this.name.startsWith("[");
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    public boolean isEnum() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    public String getSimpleName() {
        String out = "";
        int separator = this.name.indexOf(36) > 0 ? 36 : 46;
        out = out + this.name.substring(this.name.lastIndexOf(separator) + 1);
        if (this.isArray()) {
            out = out + "[]";
        }
        return out;
    }

    public native String getTypeName();

    public String getCanonicalName() {
        return this.name.replace('$', '.');
    }

    public boolean isAnonymousClass() {
        return "".equals(this.getSimpleName());
    }

    public boolean isLocalClass() {
        return this.isLocalOrAnonymousClass() && !this.isAnonymousClass();
    }

    private boolean isLocalOrAnonymousClass() {
        return this.getEnclosingMethodInfo() != null;
    }

    public boolean isMemberClass() {
        return this.getSimpleBinaryName() != null && !this.isLocalOrAnonymousClass();
    }

    private native Object getEnclosingMethodInfo();

    private String getSimpleBinaryName() {
        Class<?> enclosingClass = this.getEnclosingClass();
        if (enclosingClass == null) {
            return null;
        }
        try {
            return this.getName().substring(enclosingClass.getName().length());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InternalError("Malformed class name", ex);
        }
    }

    public boolean desiredAssertionStatus() {
        return JTranscSystem.isDebug();
    }

    public T[] getEnumConstants() {
        T[] values = this.getEnumConstantsShared();
        if (values == null) {
            System.out.println("Class " + this + " is not an enum (" + this.isEnum() + ")!");
            try {
                Method valuesMethod = this.getMethod("values", new Class[0]);
                System.out.println("values method:" + valuesMethod);
            }
            catch (NoSuchMethodException e) {
                throw new Error(e);
            }
        }
        return values != null ? (Object[])values.clone() : null;
    }

    T[] getEnumConstantsShared() {
        if (this.enumConstants == null) {
            if (!this.isEnum()) {
                return null;
            }
            try {
                Method valuesMethod = this.getMethod("values", new Class[0]);
                Object[] temporaryConstants = (Object[])valuesMethod.invoke(null, new Object[0]);
                this.enumConstants = temporaryConstants;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return this.enumConstants;
    }

    public T cast(Object obj) {
        if (obj != null && !this.isInstance(obj)) {
            throw new ClassCastException(this.cannotCastMsg(obj));
        }
        return (T)obj;
    }

    private String cannotCastMsg(Object obj) {
        return "Cannot cast " + obj.getClass().getName() + " to " + this.getName();
    }

    public <U> Class<? extends U> asSubclass(Class<U> clazz) {
        if (!clazz.isAssignableFrom(this)) {
            throw new ClassCastException(this.toString());
        }
        return this;
    }

    public Field[] getFields() throws SecurityException {
        return this.getDeclaredFields();
    }

    public Field getField(String name) throws NoSuchFieldException, SecurityException {
        if (this._fieldsByName == null) {
            this._fieldsByName = new FastStringMap();
            for (Field f : this.getFields()) {
                this._fieldsByName.set(f.getName(), (Object)f);
            }
        }
        return (Field)this._fieldsByName.get(name);
    }

    public Field getDeclaredField(String name) throws NoSuchFieldException, SecurityException {
        if (this._declaredFieldsByName == null) {
            this._declaredFieldsByName = new FastStringMap();
            for (Field f : this.getDeclaredFields()) {
                this._declaredFieldsByName.set(f.getName(), (Object)f);
            }
        }
        return (Field)this._declaredFieldsByName.get(name);
    }

    public Method[] getMethods() throws SecurityException {
        return this.getDeclaredMethods();
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    public Constructor<?>[] getConstructors() throws SecurityException {
        return this.getDeclaredConstructors();
    }

    public Method getMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return this.getDeclaredMethod(name, parameterTypes);
    }

    public Constructor<T> getConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return this.getDeclaredConstructor(parameterTypes);
    }

    public Method getDeclaredMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        for (Method m : this.getDeclaredMethods()) {
            if (!Objects.equals(m.getName(), name) || !Arrays.equals(m.getParameterTypes(), parameterTypes)) continue;
            return m;
        }
        throw new NoSuchMethodException(name);
    }

    public Constructor<T> getDeclaredConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Object[] parameterTypes2 = parameterTypes != null ? parameterTypes : new Class[]{};
        for (Constructor<?> c : this.getDeclaredConstructors()) {
            if (!Arrays.equals(c.getParameterTypes(), parameterTypes2)) continue;
            return c;
        }
        throw new NoSuchMethodException();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getDeclaredAnnotation(annotationClass) != null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        for (Annotation a : this.getAnnotations()) {
            if (a.getClass() != annotationClass) continue;
            return (A)a;
        }
        return null;
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
        ArrayList<Annotation> out = new ArrayList<Annotation>();
        for (Annotation a : this.getAnnotations()) {
            if (a.getClass() != annotationClass) continue;
            out.add(a);
        }
        return out.toArray(new Annotation[0]);
    }

    public <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationClass) {
        for (Annotation a : this.getDeclaredAnnotations()) {
            if (a.getClass() != annotationClass) continue;
            return (A)a;
        }
        return null;
    }

    public <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<A> annotationClass) {
        ArrayList<Annotation> out = new ArrayList<Annotation>();
        for (Annotation a : this.getDeclaredAnnotations()) {
            if (a.getClass() != annotationClass) continue;
            out.add(a);
        }
        return out.toArray(new Annotation[0]);
    }

    @JTranscMethodBody(target="js", value={"return this == p0;"})
    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

