/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import com.jtransc.annotation.JTranscInvisible;
import com.jtransc.text.MStringReader;
import java.lang.reflect.ArrayType;
import java.lang.reflect.MethodTypeImpl;
import java.lang.reflect.ParameterizedTypeImpl;
import java.lang.reflect.Type;
import java.util.ArrayList;

@JTranscInvisible
class _InternalUtils {
    _InternalUtils() {
    }

    static Class<?> Class_forName0(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Can't find class '" + className + "'");
            return null;
        }
    }

    static MethodTypeImpl parseMethodType(String str, Type owner) {
        return (MethodTypeImpl)_InternalUtils.parseType(new MStringReader(str), owner);
    }

    static Type parseType(String str, Type owner) {
        return _InternalUtils.parseType(new MStringReader(str), owner);
    }

    static Type parseType(MStringReader sr, Type owner) {
        char c = sr.read();
        switch (c) {
            case '(': {
                Type[] args = _InternalUtils.parseTypes(sr, owner);
                sr.expect(')');
                Type retval = _InternalUtils.parseType(sr, owner);
                return new MethodTypeImpl(args, retval);
            }
            case '+': {
                return _InternalUtils.parseType(sr, owner);
            }
            case 'V': {
                return Void.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case '[': {
                int start = sr.offset - 1;
                Type type = _InternalUtils.parseType(sr, owner);
                int end = sr.offset;
                if (type instanceof Class) {
                    return _InternalUtils.Class_forName0(sr.str.substring(start, end));
                }
                return new ArrayType(type);
            }
            case 'L': {
                char cn;
                int startOffset = sr.offset;
                boolean generic = false;
                while ((cn = sr.read()) != ';' && cn != '<') {
                }
                if (cn == '<') {
                    generic = true;
                }
                int endOffset = sr.offset - 1;
                String fqname = sr.str.substring(startOffset, endOffset).replace('/', '.');
                Class<?> base = _InternalUtils.Class_forName0(fqname);
                if (generic) {
                    Type[] paramTypes;
                    int genericStart = sr.offset;
                    int diamondCount = 1;
                    while (sr.hasMore()) {
                        char cn2 = sr.read();
                        if (cn2 == '<') {
                            ++diamondCount;
                        }
                        if (cn2 != '>' || --diamondCount > 0) continue;
                        break;
                    }
                    int genericEnd = sr.offset - 1;
                    sr.expect(';');
                    String genericParamsStr = sr.str.substring(genericStart, genericEnd);
                    for (Type pt : paramTypes = _InternalUtils.parseTypes(genericParamsStr, owner)) {
                        if (pt != null) continue;
                        throw new RuntimeException("Can't find one or more classes in '" + genericParamsStr + "'");
                    }
                    return new ParameterizedTypeImpl(paramTypes, base, owner);
                }
                return base;
            }
        }
        throw new Error("Can't parse type '" + c + "'");
    }

    static Type[] parseTypes(String str, Type owner) {
        return _InternalUtils.parseTypes(new MStringReader(str, 0), owner);
    }

    static Type[] parseTypes(MStringReader sr, Type owner) {
        ArrayList<Type> types = new ArrayList<Type>();
        while (sr.hasMore() && sr.peek() != ')') {
            types.add(_InternalUtils.parseType(sr, owner));
        }
        return types.toArray(new Type[types.size()]);
    }

    static String getTypeName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return type.toString();
    }
}

