/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.haxe.HaxeAddMembers;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.time.JTranscTime;
import java.io.Serializable;

@HaxeAddMembers(value={"var _date:Date;"})
public class Date
implements Serializable,
Cloneable,
Comparable<Date> {
    private long _timestamp;
    private boolean updated;
    private int[] parts = new int[10];

    private void setTimestamp(long timestamp) {
        if (this._timestamp != timestamp) {
            this._timestamp = timestamp;
            this.updated = false;
        }
    }

    private int[] getParts() {
        if (!this.updated) {
            this.updated = true;
            JTranscTime.fillParts((long)this._timestamp, (int[])this.parts);
        }
        return this.parts;
    }

    @HaxeMethodBody(value="_date = Date.now();")
    public Date() {
        this(System.currentTimeMillis());
    }

    @HaxeMethodBody(value="_date = Date.fromTime(HaxeNatives.longToFloat(p0));")
    @JTranscMethodBody(target="js", value={"this._date = new Date(Int64.toFloat(p0));"})
    public Date(long timestamp) {
        this.setTimestamp(timestamp);
    }

    @Deprecated
    @HaxeMethodBody(value="_date = new Date(p0, p1, p2, 0, 0, 0);")
    public Date(int year, int month, int date) {
        this(year, month, date, 0, 0, 0);
    }

    @Deprecated
    @HaxeMethodBody(value="_date = new Date(p0, p1, p2, p3, p4, 0);")
    public Date(int year, int month, int date, int hrs, int min) {
        this(year, month, date, hrs, min, 0);
    }

    @Deprecated
    @HaxeMethodBody(value="_date = new Date(p0, p1, p2, p3, p4, p5);")
    @JTranscMethodBody(target="js", value={"this._date = new Date(p0, p1, p2, p3, p4, p5);"})
    public Date(int year, int month, int date, int hrs, int min, int sec) {
        this(JTranscTime.make((int)(1900 + year), (int)month, (int)date, (int)hrs, (int)min, (int)sec, (int)0));
    }

    @Deprecated
    @HaxeMethodBody(value="_date = Date.fromString(p0._str);")
    @JTranscMethodBody(target="js", value={"this._date = new Date(Date.parse(N.istr(p0)));"})
    public Date(String s) {
        this(JTranscTime.parse((String)s));
    }

    public Object clone() {
        return new Date(this._timestamp);
    }

    @Deprecated
    @JTranscMethodBody(target="js", value={"return N.lnewFloat(Date.UTC(p0, p1, p2, p3, p4, p5));"})
    public static long UTC(int year, int month, int date, int hrs, int min, int sec) {
        return JTranscTime.make((int)(1900 + year), (int)month, (int)date, (int)hrs, (int)min, (int)sec, (int)0);
    }

    @Deprecated
    @HaxeMethodBody(value="return HaxeNatives.floatToLong(Date.fromString(p0._str).getTime());")
    @JTranscMethodBody(target="js", value={"return N.lnewFloat(Date.parse(N.istr(p0)));"})
    public static long parse(String s) {
        return JTranscTime.parse((String)s);
    }

    @Deprecated
    @HaxeMethodBody(value="return _date.getFullYear() - 1900;")
    @JTranscMethodBody(target="js", value={"return this._date.getYear();"})
    public int getYear() {
        return this.getFullYear() - 1900;
    }

    private int getFullYear() {
        return JTranscTime.getFullYear((int[])this.getParts());
    }

    private int getMilliseconds() {
        return 0;
    }

    @Deprecated
    @JTranscMethodBody(target="js", value={"this._date.setYear(p0);"})
    public void setYear(int year) {
        this.setTimestamp(JTranscTime.make((int)(1900 + year), (int)this.getMonth(), (int)this.getDate(), (int)this.getHours(), (int)this.getMinutes(), (int)this.getSeconds(), (int)this.getMilliseconds()));
    }

    @Deprecated
    @HaxeMethodBody(value="return _date.getMonth();")
    @JTranscMethodBody(target="js", value={"return this._date.getMonth();"})
    public int getMonth() {
        return JTranscTime.getMonth((int[])this.getParts());
    }

    @Deprecated
    @JTranscMethodBody(target="js", value={"this._date.setMonth(p0);"})
    public void setMonth(int month) {
        this.setTimestamp(JTranscTime.make((int)this.getFullYear(), (int)month, (int)this.getDate(), (int)this.getHours(), (int)this.getMinutes(), (int)this.getSeconds(), (int)this.getMilliseconds()));
    }

    @Deprecated
    @HaxeMethodBody(value="return _date.getDate();")
    @JTranscMethodBody(target="js", value={"return this._date.getDate();"})
    public int getDate() {
        return JTranscTime.getMonthDay((int[])this.getParts());
    }

    @Deprecated
    @JTranscMethodBody(target="js", value={"this._date.setDate(p0);"})
    public void setDate(int date) {
        this.setTimestamp(JTranscTime.make((int)this.getFullYear(), (int)this.getMonth(), (int)date, (int)this.getHours(), (int)this.getMinutes(), (int)this.getSeconds(), (int)this.getMilliseconds()));
    }

    @Deprecated
    @HaxeMethodBody(value="return _date.getDay();")
    @JTranscMethodBody(target="js", value={"return this._date.getDay();"})
    public int getDay() {
        return JTranscTime.getWeekDay((int[])this.getParts());
    }

    @Deprecated
    @HaxeMethodBody(value="return _date.getHours();")
    @JTranscMethodBody(target="js", value={"return this._date.getHours();"})
    public int getHours() {
        return JTranscTime.getHours((int[])this.getParts());
    }

    @Deprecated
    @JTranscMethodBody(target="js", value={"this._date.setHours(p0);"})
    public void setHours(int hours) {
        this.setTimestamp(JTranscTime.make((int)this.getFullYear(), (int)this.getMonth(), (int)this.getDate(), (int)hours, (int)this.getMinutes(), (int)this.getSeconds(), (int)this.getMilliseconds()));
    }

    @Deprecated
    @HaxeMethodBody(value="return _date.getMinutes();")
    @JTranscMethodBody(target="js", value={"return this._date.getMinutes();"})
    public int getMinutes() {
        return JTranscTime.getMinutes((int[])this.getParts());
    }

    @Deprecated
    @JTranscMethodBody(target="js", value={"this._date.setMinutes(p0);"})
    public void setMinutes(int minutes) {
        this.setTimestamp(JTranscTime.make((int)this.getFullYear(), (int)this.getMonth(), (int)this.getDate(), (int)this.getHours(), (int)minutes, (int)this.getSeconds(), (int)this.getMilliseconds()));
    }

    @Deprecated
    @HaxeMethodBody(value="return _date.getSeconds();")
    @JTranscMethodBody(target="js", value={"return this._date.getSeconds();"})
    public int getSeconds() {
        return JTranscTime.getSeconds((int[])this.getParts());
    }

    @Deprecated
    @JTranscMethodBody(target="js", value={"this._date.setSeconds(p0);"})
    public void setSeconds(int seconds) {
        this.setTimestamp(JTranscTime.make((int)this.getFullYear(), (int)this.getMonth(), (int)this.getDate(), (int)this.getHours(), (int)this.getMinutes(), (int)seconds, (int)this.getMilliseconds()));
    }

    @HaxeMethodBody(value="return HaxeNatives.floatToLong(_date.getTime());")
    @JTranscMethodBody(target="js", value={"return N.lnewFloat(this._date.getTime());"})
    public long getTime() {
        return this._timestamp;
    }

    @JTranscMethodBody(target="js", value={"this._date.setTime(Int64.toFloat(p0));"})
    public void setTime(long time) {
        this.setTimestamp(time);
    }

    public boolean before(Date when) {
        return Date.getMillisOf(this) < Date.getMillisOf(when);
    }

    public boolean after(Date when) {
        return Date.getMillisOf(this) > Date.getMillisOf(when);
    }

    public boolean equals(Object obj) {
        return obj instanceof Date && this.getTime() == ((Date)obj).getTime();
    }

    static final long getMillisOf(Date date) {
        return date.getTime();
    }

    @Override
    public int compareTo(Date anotherDate) {
        long anotherTime;
        long thisTime = Date.getMillisOf(this);
        return thisTime < (anotherTime = Date.getMillisOf(anotherDate)) ? -1 : (thisTime == anotherTime ? 0 : 1);
    }

    public int hashCode() {
        long ht = this.getTime();
        return (int)ht ^ (int)(ht >> 32);
    }

    private static StringBuilder convertToAbbr(StringBuilder sb, String name) {
        sb.append(Character.toUpperCase(name.charAt(0)));
        sb.append(name.charAt(1)).append(name.charAt(2));
        return sb;
    }

    @HaxeMethodBody(value="return HaxeNatives.str(_date.toString());")
    @JTranscMethodBody(target="js", value={"return N.str(this._date.toString());"})
    public native String toString();

    @Deprecated
    @JTranscMethodBody(target="js", value={"return N.str(this._date.toLocaleString());"})
    public native String toLocaleString();

    @Deprecated
    @JTranscMethodBody(target="js", value={"return N.str(this._date.toGMTString());"})
    public native String toGMTString();

    @Deprecated
    @JTranscMethodBody(target="js", value={"return this._date.getTimezoneOffset();"})
    public native int getTimezoneOffset();
}

