/*
 * Decompiled with CFR 0.152.
 */
package regexodus;

import java.io.Serializable;
import regexodus.MemReg;
import regexodus.Term;

class SearchEntry
implements Serializable {
    private static final long serialVersionUID = -3628346657932720807L;
    Term term;
    int index;
    int cnt;
    int regLen;
    boolean isState;
    SearchEntry sub;
    SearchEntry on;
    private MState mHead;
    private MState mCurrent;
    private CState cHead;
    private CState cCurrent;

    SearchEntry() {
    }

    static void saveMemregState(SearchEntry entry, int memreg, MemReg mr) {
        entry.isState = true;
        MState current = entry.mCurrent;
        if (current == null) {
            MState head = entry.mHead;
            if (head == null) {
                entry.mCurrent = current = new MState();
                entry.mHead = current;
            } else {
                current = head;
            }
        } else {
            MState next = current.next;
            if (next == null) {
                current.next = next = new MState();
                next.prev = current;
            }
            current = next;
        }
        current.index = memreg;
        current.in = mr.in;
        current.out = mr.out;
        entry.mCurrent = current;
    }

    static void saveCntState(SearchEntry entry, int cntreg, int value) {
        entry.isState = true;
        CState current = entry.cCurrent;
        if (current == null) {
            CState head = entry.cHead;
            if (head == null) {
                entry.cCurrent = current = new CState();
                entry.cHead = current;
            } else {
                current = head;
            }
        } else {
            CState next = current.next;
            if (next == null) {
                current.next = next = new CState();
                next.prev = current;
            }
            current = next;
        }
        current.index = cntreg;
        current.value = value;
        entry.cCurrent = current;
    }

    static void popState(SearchEntry entry, MemReg[] memregs, int[] counters) {
        MState ms = entry.mCurrent;
        while (ms != null) {
            MemReg mr = memregs[ms.index];
            mr.in = ms.in;
            mr.out = ms.out;
            ms = ms.prev;
        }
        CState cs = entry.cCurrent;
        while (cs != null) {
            counters[cs.index] = cs.value;
            cs = cs.prev;
        }
        entry.mCurrent = null;
        entry.cCurrent = null;
        entry.isState = false;
    }

    final void reset(int restQueue) {
        this.term = null;
        this.regLen = 0;
        this.cnt = 0;
        this.index = 0;
        this.mCurrent = null;
        this.cCurrent = null;
        this.isState = false;
        SearchEntry on = this.on;
        if (on != null) {
            if (restQueue > 0) {
                on.reset(restQueue - 1);
            } else {
                this.on = null;
                on.sub = null;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchEntry that = (SearchEntry)o;
        if (this.index != that.index) {
            return false;
        }
        if (this.cnt != that.cnt) {
            return false;
        }
        if (this.regLen != that.regLen) {
            return false;
        }
        if (this.isState != that.isState) {
            return false;
        }
        if (this.term != null ? !this.term.equals(that.term) : that.term != null) {
            return false;
        }
        if (this.sub != null ? !this.sub.equals(that.sub) : that.sub != null) {
            return false;
        }
        if (this.on != null ? !this.on.equals(that.on) : that.on != null) {
            return false;
        }
        if (this.mHead != null ? !this.mHead.equals(that.mHead) : that.mHead != null) {
            return false;
        }
        return this.mCurrent != null ? this.mCurrent.equals(that.mCurrent) : that.mCurrent == null && (this.cHead != null ? this.cHead.equals(that.cHead) : that.cHead == null && (this.cCurrent != null ? this.cCurrent.equals(that.cCurrent) : that.cCurrent == null));
    }

    public int hashCode() {
        int result = this.term != null ? this.term.hashCode() : 0;
        result = 31 * result + this.index;
        result = 31 * result + this.cnt;
        result = 31 * result + this.regLen;
        result = 31 * result + (this.isState ? 1 : 0);
        result = 31 * result + (this.mHead != null ? this.mHead.hashCode() : 0);
        result = 31 * result + (this.mCurrent != null ? this.mCurrent.hashCode() : 0);
        result = 31 * result + (this.cHead != null ? this.cHead.hashCode() : 0);
        result = 31 * result + (this.cCurrent != null ? this.cCurrent.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SearchEntry{???}";
    }

    private static class CState {
        int index;
        int value;
        CState next;
        CState prev;

        private CState() {
        }
    }

    private static class MState {
        int index;
        int in;
        int out;
        MState next;
        MState prev;

        private MState() {
        }
    }
}

