/*
 * Copyright 2016 Carlos Ballesteros Velasco
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package java.lang;

import com.jtransc.annotation.JTranscAddFile;
import com.jtransc.annotation.JTranscKeep;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscReferenceClass;
import com.jtransc.annotation.haxe.HaxeAddFilesTemplate;
import com.jtransc.annotation.haxe.HaxeAddMembers;
import com.jtransc.annotation.haxe.HaxeAddSubtarget;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import j.ProgramReflection;

import java.lang.reflect.Field;

@SuppressWarnings({"WeakerAccess", "unused"})
@HaxeAddFilesTemplate(base = "hx", value = {
	"hx/N.hx", "hx/Float32.hx", "hx/Float64.hx",
	"hx/JA_0.hx", "hx/JA_B.hx", "hx/JA_C.hx", "hx/JA_D.hx", "hx/JA_F.hx", "hx/JA_I.hx", "hx/JA_J.hx", "hx/JA_L.hx", "hx/JA_S.hx", "hx/JA_Z.hx",
	"hx/HaxePolyfills.hx", "hx/HaxeDynamicLoad.hx", "hx/HaxeIO.hx", "hx/HaxeNativeWrapper.hx",
})
@HaxeAddSubtarget(name = "js", alias = {"default", "javascript"}, cmdSwitch = "-js", singleFile = true, interpreter = "node", extension = "js")
@HaxeAddSubtarget(name = "cpp", alias = {"c", "c++"}, cmdSwitch = "-cpp", singleFile = true, interpreter = "", extension = "exe")
@HaxeAddSubtarget(name = "swf", alias = {"flash", "as3"}, cmdSwitch = "-swf", singleFile = true, interpreter = "", extension = "swf")
@HaxeAddSubtarget(name = "neko", cmdSwitch = "-neko", singleFile = true, interpreter = "neko", extension = "n")
@HaxeAddSubtarget(name = "php", cmdSwitch = "-php", singleFile = false, interpreter = "php", extension = "php", interpreterSuffix = "/index.php")
@HaxeAddSubtarget(name = "cs", cmdSwitch = "-cs", singleFile = true, interpreter = "", extension = "exe")
@HaxeAddSubtarget(name = "java", cmdSwitch = "-java", singleFile = true, interpreter = "java -jar", extension = "jar")
@HaxeAddSubtarget(name = "python", cmdSwitch = "-python", singleFile = true, interpreter = "python", extension = "py")
@JTranscAddFile(target = "js", priority = -1, process = true, prependAppend = "js/Runtime.js")
public class Object {
	static private int $$lastId = 0;
	public int $$id;

	public Object() {
		$$id = $$lastId++;
	}

	@JTranscKeep
	public boolean equals(Object obj) {
		return (this == obj);
	}

	//@HaxeMethodBody("return HaxeNatives.getClass(this);")
	//@JTranscMethodBody(target = "js", value = "return (obj == null) ? null : ({% SMETHOD j.ProgramReflection:getClassById %}(obj.$$CLASS_ID));")
	@JTranscMethodBody(target = "js", value = {
		"var obj = this;",
		"if (obj == null) return null;",
		"if (obj instanceof JA_0) return N.resolveClass(obj.desc);",
		"return {% SMETHOD j.ProgramReflection:getClassById %}(obj.$$CLASS_ID);",
	})
	//@JTranscMethodBody(target = "cpp", value = "return {% SMETHOD java.lang.Class:forName0 %}(N::str(TYPE_TABLE::TABLE[this->__INSTANCE_CLASS_ID].tname));")
	public final Class<?> getClass() {
		return java.lang.jtransc.JTranscCoreReflection.getClassById(ProgramReflection.getClassId(this));
	}

	@JTranscKeep
	public int hashCode() {
		return System.identityHashCode(this);
	}

	@JTranscKeep
	@JTranscMethodBody(target = "js", value = "return N.clone(this);")
	protected Object clone() throws CloneNotSupportedException {
		// @TODO: This is slow! We could override this at code gen knowing all the fields and with generated code to generate them.
		try {
			Class<?> clazz = this.getClass();
			Object newObject = clazz.newInstance();
			for (Field field : clazz.getDeclaredFields()) {
				field.set(newObject, field.get(this));
			}
			return newObject;
		} catch (Throwable e) {
			throw new CloneNotSupportedException(e.toString());
		}
	}

	@JTranscKeep
	//@JTranscMethodBody(target = "js", value = "return N.str('Object');")
	public String toString() {
		return getClass().getName() + "@" + Integer.toHexString(this.hashCode());
	}

	public final void notify() {
	}

	public final void notifyAll() {
	}

	public final void wait(long timeout) throws InterruptedException {
	}

	public final void wait(long timeout, int nanos) throws InterruptedException {
		wait(timeout);
	}

	public final void wait() throws InterruptedException {
		wait(0);
	}

	protected void finalize() throws Throwable {
	}
}
