/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.jtransc.JTranscArrays;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Formatter;
import java.util.Locale;

public class PrintStream
extends FilterOutputStream
implements Appendable,
Closeable {
    private boolean ioError;
    private boolean autoFlush;
    private String encoding = "UTF-8";

    public PrintStream(OutputStream out) {
        super(out);
        if (out == null) {
            throw new NullPointerException("out == null");
        }
    }

    public PrintStream(OutputStream out, boolean autoFlush) {
        super(out);
        if (out == null) {
            throw new NullPointerException("out == null");
        }
        this.autoFlush = autoFlush;
    }

    public PrintStream(OutputStream out, boolean autoFlush, String charsetName) throws UnsupportedEncodingException {
        super(out);
        if (out == null) {
            throw new NullPointerException("out == null");
        }
        if (charsetName == null) {
            throw new NullPointerException("charsetName == null");
        }
        this.autoFlush = autoFlush;
        try {
            if (!Charset.isSupported(charsetName)) {
                throw new UnsupportedEncodingException(charsetName);
            }
        }
        catch (IllegalCharsetNameException e) {
            throw new UnsupportedEncodingException(charsetName);
        }
        this.encoding = charsetName;
    }

    public PrintStream(File file) throws FileNotFoundException {
        super(new FileOutputStream(file));
    }

    public PrintStream(File file, String charsetName) throws FileNotFoundException, UnsupportedEncodingException {
        super(new FileOutputStream(file));
        if (charsetName == null) {
            throw new NullPointerException("charsetName == null");
        }
        if (!Charset.isSupported(charsetName)) {
            throw new UnsupportedEncodingException(charsetName);
        }
        this.encoding = charsetName;
    }

    public PrintStream(String fileName) throws FileNotFoundException {
        this(new File(fileName));
    }

    public PrintStream(String fileName, String charsetName) throws FileNotFoundException, UnsupportedEncodingException {
        this(new File(fileName), charsetName);
    }

    @Override
    public boolean checkError() {
        OutputStream delegate = this.out;
        if (delegate == null) {
            return this.ioError;
        }
        this.flush();
        return this.ioError || delegate.checkError();
    }

    protected void clearError() {
        this.ioError = false;
    }

    @Override
    public synchronized void close() {
        this.flush();
        if (this.out != null) {
            try {
                this.out.close();
                this.out = null;
            }
            catch (IOException e) {
                this.setError();
            }
        }
    }

    @Override
    public synchronized void flush() {
        if (this.out != null) {
            try {
                this.out.flush();
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.setError();
    }

    public PrintStream format(String format, Object ... args) {
        return this.format(Locale.getDefault(), format, args);
    }

    public PrintStream format(Locale l, String format, Object ... args) {
        if (format == null) {
            throw new NullPointerException("format == null");
        }
        new Formatter(this, l).format(format, args);
        return this;
    }

    public PrintStream printf(String format, Object ... args) {
        return this.format(format, args);
    }

    public PrintStream printf(Locale l, String format, Object ... args) {
        return this.format(l, format, args);
    }

    private void newline() {
        this.print(System.lineSeparator());
    }

    public void print(char[] chars) {
        this.print(new String(chars, 0, chars.length));
    }

    public void print(char c) {
        this.print(String.valueOf(c));
    }

    public void print(double d) {
        this.print(String.valueOf(d));
    }

    public void print(float f) {
        this.print(String.valueOf(f));
    }

    public void print(int i) {
        this.print(String.valueOf(i));
    }

    public void print(long l) {
        this.print(String.valueOf(l));
    }

    public void print(Object o) {
        this.print(String.valueOf(o));
    }

    public synchronized void print(String str) {
        try {
            this.write(str.getBytes(this.encoding));
        }
        catch (IOException e) {
            this.setError();
        }
    }

    public void print(boolean b) {
        this.print(String.valueOf(b));
    }

    public void println() {
        this.newline();
    }

    public void println(char[] chars) {
        this.println(new String(chars, 0, chars.length));
    }

    public void println(char c) {
        this.println(String.valueOf(c));
    }

    public void println(double d) {
        this.println(String.valueOf(d));
    }

    public void println(float f) {
        this.println(String.valueOf(f));
    }

    public void println(int i) {
        this.println(String.valueOf(i));
    }

    public void println(long l) {
        this.println(String.valueOf(l));
    }

    public void println(Object o) {
        this.println(String.valueOf(o));
    }

    public synchronized void println(String str) {
        this.print(str);
        this.newline();
    }

    public void println(boolean b) {
        this.println(String.valueOf(b));
    }

    protected void setError() {
        this.ioError = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] buffer, int offset, int length) {
        JTranscArrays.checkOffsetAndCount((int)buffer.length, (int)offset, (int)length);
        PrintStream printStream = this;
        synchronized (printStream) {
            if (this.out == null) {
                this.setError();
                return;
            }
            try {
                this.out.write(buffer, offset, length);
                if (this.autoFlush) {
                    this.flush();
                }
            }
            catch (IOException e) {
                this.setError();
            }
        }
    }

    @Override
    public synchronized void write(int oneByte) {
        if (this.out == null) {
            this.setError();
            return;
        }
        try {
            boolean isNewline;
            this.out.write(oneByte);
            int b = oneByte & 0xFF;
            boolean bl = isNewline = b == 10 || b == 21;
            if (this.autoFlush && isNewline) {
                this.flush();
            }
        }
        catch (IOException e) {
            this.setError();
        }
    }

    @Override
    public PrintStream append(char c) {
        this.print(c);
        return this;
    }

    @Override
    public PrintStream append(CharSequence charSequence) {
        if (charSequence == null) {
            this.print("null");
        } else {
            this.print(charSequence.toString());
        }
        return this;
    }

    @Override
    public PrintStream append(CharSequence charSequence, int start, int end) {
        if (charSequence == null) {
            charSequence = "null";
        }
        this.print(charSequence.subSequence(start, end).toString());
        return this;
    }
}

