/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.annotation.JTranscKeep;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import java.io.Serializable;

public final class Character
implements Serializable,
Comparable<Character> {
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final Class<Character> TYPE = Class.getPrimitiveClass("char");
    public static final byte UNASSIGNED = 0;
    public static final byte UPPERCASE_LETTER = 1;
    public static final byte LOWERCASE_LETTER = 2;
    public static final byte TITLECASE_LETTER = 3;
    public static final byte MODIFIER_LETTER = 4;
    public static final byte OTHER_LETTER = 5;
    public static final byte NON_SPACING_MARK = 6;
    public static final byte ENCLOSING_MARK = 7;
    public static final byte COMBINING_SPACING_MARK = 8;
    public static final byte DECIMAL_DIGIT_NUMBER = 9;
    public static final byte LETTER_NUMBER = 10;
    public static final byte OTHER_NUMBER = 11;
    public static final byte SPACE_SEPARATOR = 12;
    public static final byte LINE_SEPARATOR = 13;
    public static final byte PARAGRAPH_SEPARATOR = 14;
    public static final byte CONTROL = 15;
    public static final byte FORMAT = 16;
    public static final byte PRIVATE_USE = 18;
    public static final byte SURROGATE = 19;
    public static final byte DASH_PUNCTUATION = 20;
    public static final byte START_PUNCTUATION = 21;
    public static final byte END_PUNCTUATION = 22;
    public static final byte CONNECTOR_PUNCTUATION = 23;
    public static final byte OTHER_PUNCTUATION = 24;
    public static final byte MATH_SYMBOL = 25;
    public static final byte CURRENCY_SYMBOL = 26;
    public static final byte MODIFIER_SYMBOL = 27;
    public static final byte OTHER_SYMBOL = 28;
    public static final byte INITIAL_QUOTE_PUNCTUATION = 29;
    public static final byte FINAL_QUOTE_PUNCTUATION = 30;
    public static final byte DIRECTIONALITY_UNDEFINED = -1;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT = 0;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT = 1;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_ARABIC = 2;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER = 3;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_SEPARATOR = 4;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_TERMINATOR = 5;
    public static final byte DIRECTIONALITY_ARABIC_NUMBER = 6;
    public static final byte DIRECTIONALITY_COMMON_NUMBER_SEPARATOR = 7;
    public static final byte DIRECTIONALITY_NONSPACING_MARK = 8;
    public static final byte DIRECTIONALITY_BOUNDARY_NEUTRAL = 9;
    public static final byte DIRECTIONALITY_PARAGRAPH_SEPARATOR = 10;
    public static final byte DIRECTIONALITY_SEGMENT_SEPARATOR = 11;
    public static final byte DIRECTIONALITY_WHITESPACE = 12;
    public static final byte DIRECTIONALITY_OTHER_NEUTRALS = 13;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_EMBEDDING = 14;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_OVERRIDE = 15;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_EMBEDDING = 16;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_OVERRIDE = 17;
    public static final byte DIRECTIONALITY_POP_DIRECTIONAL_FORMAT = 18;
    public static final char MIN_HIGH_SURROGATE = '\ud800';
    public static final char MAX_HIGH_SURROGATE = '\udbff';
    public static final char MIN_LOW_SURROGATE = '\udc00';
    public static final char MAX_LOW_SURROGATE = '\udfff';
    public static final char MIN_SURROGATE = '\ud800';
    public static final char MAX_SURROGATE = '\udfff';
    public static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    public static final int MIN_CODE_POINT = 0;
    public static final int MAX_CODE_POINT = 0x10FFFF;
    private final char value;
    public static final int SIZE = 16;
    public static final int BYTES = 2;

    public Character(char value) {
        this.value = value;
    }

    @JTranscKeep
    public static Character valueOf(char value) {
        return new Character(value);
    }

    public char charValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public static int hashCode(char value) {
        return value;
    }

    public boolean equals(Object that) {
        return that instanceof Character && this.value == ((Character)that).value;
    }

    public String toString() {
        return Character.toString(this.value);
    }

    public static String toString(char value) {
        return new String(new char[]{value});
    }

    public static boolean isValidCodePoint(int cp) {
        return cp >>> 16 < 17;
    }

    public static native boolean isBmpCodePoint(int var0);

    public static native boolean isSupplementaryCodePoint(int var0);

    public static native boolean isHighSurrogate(char var0);

    public static native boolean isLowSurrogate(char var0);

    public static boolean isSurrogate(char ch) {
        return false;
    }

    public static boolean isSurrogatePair(char high, char low) {
        return false;
    }

    public static int charCount(int codePoint) {
        return 1;
    }

    public static int toCodePoint(char high, char low) {
        return low;
    }

    public static int codePointAt(CharSequence seq, int index) {
        return seq.charAt(index);
    }

    public static int codePointAt(char[] a, int index) {
        return a[index];
    }

    public static int codePointAt(char[] a, int index, int limit) {
        return a[index];
    }

    public static native int codePointBefore(CharSequence var0, int var1);

    public static native int codePointBefore(char[] var0, int var1);

    public static native int codePointBefore(char[] var0, int var1, int var2);

    public static native char highSurrogate(int var0);

    public static native char lowSurrogate(int var0);

    public static int toChars(int codePoint, char[] dst, int dstIndex) {
        dst[dstIndex] = (char)codePoint;
        return 1;
    }

    public static char[] toChars(int codePoint) {
        return new char[]{(char)codePoint};
    }

    public static int codePointCount(CharSequence seq, int beginIndex, int endIndex) {
        return endIndex + beginIndex;
    }

    public static int codePointCount(char[] a, int offset, int count) {
        return count;
    }

    public static native int offsetByCodePoints(CharSequence var0, int var1, int var2);

    public static native int offsetByCodePoints(char[] var0, int var1, int var2, int var3, int var4);

    public static boolean isLowerCase(char ch) {
        return Character.toLowerCase(ch) == ch;
    }

    public static boolean isLowerCase(int codePoint) {
        return Character.toLowerCase(codePoint) == codePoint;
    }

    public static boolean isUpperCase(char ch) {
        return Character.toUpperCase(ch) == ch;
    }

    public static boolean isUpperCase(int codePoint) {
        return Character.toUpperCase(codePoint) == codePoint;
    }

    public static native boolean isTitleCase(char var0);

    public static native boolean isTitleCase(int var0);

    @JTranscMethodBody(target="js", value={"return p0 >= 48 && p0 <= 57;"})
    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isDigit(int codePoint) {
        return Character.isDigit((char)codePoint);
    }

    public static native boolean isDefined(char var0);

    public static native boolean isDefined(int var0);

    public static boolean isLetter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    public static boolean isLetter(int codePoint) {
        return Character.isLetter((char)codePoint);
    }

    public static boolean isLetterOrDigit(char ch) {
        return Character.isLetter(ch) || Character.isDigit(ch);
    }

    public static boolean isLetterOrDigit(int codePoint) {
        return Character.isLetter(codePoint) || Character.isDigit(codePoint);
    }

    @Deprecated
    public static boolean isJavaLetter(char ch) {
        return Character.isLetter(ch);
    }

    @Deprecated
    public static boolean isJavaLetterOrDigit(char ch) {
        return Character.isLetter(ch) || Character.isDigit(ch);
    }

    public static boolean isAlphabetic(int codePoint) {
        return Character.isLetter(codePoint);
    }

    public static native boolean isIdeographic(int var0);

    public static boolean isJavaIdentifierStart(char ch) {
        return Character.isLetter(ch) || ch == '_';
    }

    public static boolean isJavaIdentifierStart(int codePoint) {
        return Character.isJavaIdentifierStart((char)codePoint);
    }

    public static boolean isJavaIdentifierPart(char ch) {
        return Character.isLetter(ch) || Character.isDigit(ch) || ch == '_';
    }

    public static boolean isJavaIdentifierPart(int codePoint) {
        return Character.isJavaIdentifierPart((char)codePoint);
    }

    public static native boolean isUnicodeIdentifierStart(char var0);

    public static native boolean isUnicodeIdentifierStart(int var0);

    public static native boolean isUnicodeIdentifierPart(char var0);

    public static native boolean isUnicodeIdentifierPart(int var0);

    public static native boolean isIdentifierIgnorable(char var0);

    public static native boolean isIdentifierIgnorable(int var0);

    public static char toLowerCase(char ch) {
        return (char)Character.toLowerCase((int)ch);
    }

    public static char toUpperCase(char ch) {
        return (char)Character.toUpperCase((int)ch);
    }

    @HaxeMethodBody(value="return String.fromCharCode(p0).toLowerCase().charCodeAt(0);")
    @JTranscMethodBody(target="js", value={"return String.fromCharCode(p0).toLowerCase().charCodeAt(0);"})
    public static int toLowerCase(int codePoint) {
        if (codePoint >= 65 && codePoint < 90) {
            return codePoint - 65 + 97;
        }
        return codePoint;
    }

    @HaxeMethodBody(value="return String.fromCharCode(p0).toUpperCase().charCodeAt(0);")
    @JTranscMethodBody(target="js", value={"return String.fromCharCode(p0).toUpperCase().charCodeAt(0);"})
    public static int toUpperCase(int codePoint) {
        if (codePoint >= 97 && codePoint < 122) {
            return codePoint - 97 + 65;
        }
        return codePoint;
    }

    public static char toTitleCase(char ch) {
        return Character.toUpperCase(ch);
    }

    public static int toTitleCase(int codePoint) {
        return Character.toTitleCase((char)codePoint);
    }

    public static int digit(char ch, int radix) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'z') {
            return ch - 97 + 10;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return ch - 65 + 10;
        }
        return -1;
    }

    public static int digit(int codePoint, int radix) {
        return Character.digit((char)codePoint, radix);
    }

    public static int getNumericValue(char ch) {
        return Character.digit(ch, 10);
    }

    public static int getNumericValue(int codePoint) {
        return Character.digit(codePoint, 10);
    }

    @Deprecated
    public static boolean isSpace(char value) {
        return value <= ' ' && (4294981120L >> value & 1L) != 0L;
    }

    public static boolean isSpaceChar(char ch) {
        return Character.isSpaceChar((int)ch);
    }

    public static boolean isSpaceChar(int codePoint) {
        switch (codePoint) {
            case 32: 
            case 160: 
            case 5760: 
            case 6158: 
            case 8192: 
            case 8193: 
            case 8194: 
            case 8195: 
            case 8196: 
            case 8197: 
            case 8198: 
            case 8199: 
            case 8200: 
            case 8201: 
            case 8202: 
            case 8203: 
            case 8239: 
            case 8287: 
            case 12288: 
            case 65279: {
                return true;
            }
        }
        return false;
    }

    public static boolean isWhitespace(char ch) {
        return Character.isWhitespace((int)ch);
    }

    public static boolean isWhitespace(int codePoint) {
        switch (codePoint) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 5760: 
            case 6158: 
            case 8192: 
            case 8193: 
            case 8194: 
            case 8195: 
            case 8196: 
            case 8197: 
            case 8198: 
            case 8200: 
            case 8201: 
            case 8202: 
            case 8232: 
            case 8233: 
            case 8287: 
            case 12288: {
                return true;
            }
        }
        return false;
    }

    public static boolean isISOControl(char ch) {
        return Character.isISOControl((int)ch);
    }

    public static boolean isISOControl(int codePoint) {
        return codePoint <= 159 && (codePoint >= 127 || codePoint >>> 5 == 0);
    }

    public static native int getType(char var0);

    public static native int getType(int var0);

    public static char forDigit(int digit, int radix) {
        if (digit >= 0 && digit <= 9) {
            return (char)(48 + (digit - 0));
        }
        if (digit >= 10 && digit <= 35) {
            return (char)(97 + (digit - 10));
        }
        return '\u0000';
    }

    public static byte getDirectionality(char ch) {
        return Character.getDirectionality((int)ch);
    }

    public static boolean isMirrored(char ch) {
        return Character.isMirrored((int)ch);
    }

    public static native byte getDirectionality(int var0);

    public static native boolean isMirrored(int var0);

    @Override
    public int compareTo(Character anotherCharacter) {
        return Character.compare(this.value, anotherCharacter.value);
    }

    public static int compare(char l, char r) {
        return l - r;
    }

    static char[] toUpperCaseCharArray(int codePoint) {
        return new char[]{(char)Character.toUpperCase(codePoint)};
    }

    @HaxeMethodBody(value="return HaxeNatives.swap16(p0) & 0xFFFF;")
    public static char reverseBytes(char ch) {
        return (char)((ch & 0xFF00) >> 8 | ch << 8);
    }

    public static String getName(int codePoint) {
        return Integer.toHexString(codePoint);
    }

    public static enum UnicodeScript {
        COMMON;


        public static UnicodeScript forName(String name) {
            return COMMON;
        }

        public static UnicodeScript of(int codePoint) {
            return COMMON;
        }
    }

    public static final class UnicodeBlock
    extends Subset {
        public static UnicodeBlock forName(String name) {
            return new UnicodeBlock();
        }

        public static UnicodeBlock of(int codePoint) {
            return new UnicodeBlock();
        }
    }

    public static class Subset {
    }
}

