/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.annotation.JTranscKeep;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscMethodBodyList;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.internal.JTranscCType;

public final class Integer
extends Number
implements Comparable<Integer> {
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class<Integer> TYPE = Class.getPrimitiveClass("int");
    private int value;
    private static char[] temp = new char[33];
    private static Integer[] values;
    private static final int MIN = -128;
    private static final int MAX = 128;
    private static final int LENGTH = 256;
    public static final int SIZE = 32;
    public static final int BYTES = 4;
    private static final byte[] NTZ_TABLE;

    public Integer(int value) {
        this.value = value;
    }

    public Integer(String s) {
        this.value = Integer.parseInt(s, 10);
    }

    @HaxeMethodBody(target="js", value="return N.str(untyped __js__('p0.toString(p1)'));")
    @JTranscMethodBody(target="js", value={"return N.str((p0|0).toString(p1));"})
    public static String toString(int i, int radix) {
        boolean negative;
        if (radix < 2) {
            throw new RuntimeException("Invalid radix");
        }
        if (i == 0) {
            return "0";
        }
        boolean bl = negative = i < 0;
        if (i < 0) {
            i = -i;
        }
        int tempPos = temp.length;
        while (i != 0) {
            Integer.temp[--tempPos] = JTranscCType.encodeDigit((int)Integer.remainderUnsigned(i, radix));
            i = Integer.divideUnsigned(i, radix);
        }
        if (negative) {
            Integer.temp[--tempPos] = 45;
        }
        return new String(temp, tempPos, temp.length - tempPos);
    }

    @JTranscMethodBody(target="js", value={"return N.str((p0 >>> 0).toString(p1));"})
    public static String toUnsignedString(int i, int radix) {
        if (i == 0) {
            return "0";
        }
        StringBuilder out = new StringBuilder();
        while (i != 0) {
            out.append(JTranscCType.encodeDigit((int)Integer.remainderUnsigned(i, radix)));
            i = Integer.divideUnsigned(i, radix);
        }
        out.reverse();
        return out.toString();
    }

    public static String toHexString(int i) {
        return Integer.toUnsignedString(i, 16);
    }

    public static String toOctalString(int i) {
        return Integer.toUnsignedString(i, 8);
    }

    public static String toBinaryString(int i) {
        return Integer.toUnsignedString(i, 2);
    }

    public static String toString(int i) {
        return Integer.toString(i, 10);
    }

    public static String toUnsignedString(int i) {
        return Integer.toUnsignedString(i, 10);
    }

    public static int parseInt(String input, int radix) {
        String s = input;
        int result = 0;
        int sign = 1;
        if (s.startsWith("-")) {
            sign = -1;
            s = s.substring(1);
        } else if (s.startsWith("+")) {
            sign = 1;
            s = s.substring(1);
        }
        int len = s.length();
        for (int n = 0; n < len; ++n) {
            char c = s.charAt(n);
            if (!JTranscCType.isDigit((char)c)) {
                throw new NumberFormatException("For input string: \"" + input + "\"");
            }
            result *= radix;
            result += JTranscCType.decodeDigit((char)c);
        }
        return sign * result;
    }

    public static int parseInt(String s) {
        return Integer.parseInt(s, 10);
    }

    public static int parseUnsignedInt(String s, int radix) {
        return Integer.parseInt(s, radix);
    }

    public static int parseUnsignedInt(String s) {
        return Integer.parseUnsignedInt(s, 10);
    }

    public static Integer valueOf(String s, int radix) {
        return Integer.parseInt(s, radix);
    }

    public static Integer valueOf(String s) {
        return Integer.valueOf(s, 10);
    }

    @JTranscKeep
    public static Integer valueOf(int i) {
        if (values == null) {
            values = new Integer[256];
            for (int n = -128; n < 128; ++n) {
                Integer.values[n - -128] = new Integer(n);
            }
        }
        if (i >= -128 && i < 128) {
            return values[i - -128];
        }
        return new Integer(i);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public static int hashCode(int value) {
        return value;
    }

    public boolean equals(Object obj) {
        return obj instanceof Integer && ((Integer)obj).value == this.value;
    }

    public static Integer getInteger(String nm) {
        return Integer.getInteger(nm, null);
    }

    public static Integer getInteger(String nm, int val) {
        Integer result = Integer.getInteger(nm, null);
        return result == null ? new Integer(val) : result;
    }

    public static Integer getInteger(String nm, Integer val) {
        String out = System.getProperty(nm);
        if (out == null) {
            return val;
        }
        try {
            return Integer.decode(nm);
        }
        catch (NumberFormatException e) {
            return val;
        }
    }

    public static Integer decode(String nm) throws NumberFormatException {
        if (nm.length() == 0) {
            throw new NumberFormatException("Zero length string");
        }
        if (nm.startsWith("-")) {
            return -Integer.decode(nm.substring(1)).intValue();
        }
        if (nm.startsWith("+")) {
            return Integer.decode(nm.substring(1));
        }
        if (nm.startsWith("0x")) {
            return Integer.parseInt(nm.substring(2), 16);
        }
        if (nm.startsWith("0X")) {
            return Integer.parseInt(nm.substring(2), 16);
        }
        if (nm.startsWith("#")) {
            return Integer.parseInt(nm.substring(1), 16);
        }
        if (nm.startsWith("0")) {
            return Integer.parseInt(nm.substring(1), 8);
        }
        return Integer.parseInt(nm, 10);
    }

    @Override
    public int compareTo(Integer anotherInteger) {
        return Integer.compare(this.value, anotherInteger.value);
    }

    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return (p0 < p1) ? -1 : ((p0 > p1) ? 1 : 0);"}), @JTranscMethodBody(target="cpp", value={"return (p0 < p1) ? -1 : ((p0 > p1) ? 1 : 0);"})})
    public static int compare(int l, int r) {
        return l < r ? -1 : (l > r ? 1 : 0);
    }

    public static int compareUnsigned(int l, int r) {
        return Integer.compare(l ^ Integer.MIN_VALUE, r ^ Integer.MIN_VALUE);
    }

    public static long toUnsignedLong(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    @JTranscMethodBody(target="cpp", value={"return (int32_t)((uint32_t)p0 / (uint32_t)p1);"})
    public static int divideUnsigned(int dividend, int divisor) {
        int quotient;
        if (divisor < 0) {
            return Integer.compareUnsigned(dividend, divisor) < 0 ? 0 : 1;
        }
        if (dividend >= 0) {
            return dividend / divisor;
        }
        int rem = dividend - (quotient = (dividend >>> 1) / divisor << 1) * divisor;
        return quotient + (Integer.compareUnsigned(rem, divisor) >= 0 ? 1 : 0);
    }

    @JTranscMethodBody(target="cpp", value={"return (int32_t)((uint32_t)p0 % (uint32_t)p1);"})
    public static int remainderUnsigned(int dividend, int divisor) {
        int rem;
        if (divisor < 0) {
            return Integer.compareUnsigned(dividend, divisor) < 0 ? dividend : dividend - divisor;
        }
        if (dividend >= 0) {
            return dividend % divisor;
        }
        int quotient = (dividend >>> 1) / divisor << 1;
        return rem - (Integer.compareUnsigned(rem = dividend - quotient * divisor, divisor) >= 0 ? divisor : 0);
    }

    public static int highestOneBit(int i) {
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i - (i >>> 1);
    }

    public static int lowestOneBit(int i) {
        return i & -i;
    }

    @JTranscMethodBody(target="js", value={"return Math.clz32(p0);"})
    public static int numberOfLeadingZeros(int i) {
        if (i <= 0) {
            return ~i >> 26 & 0x20;
        }
        int n = 1;
        if (i >> 16 == 0) {
            n += 16;
            i <<= 16;
        }
        if (i >> 24 == 0) {
            n += 8;
            i <<= 8;
        }
        if (i >> 28 == 0) {
            n += 4;
            i <<= 4;
        }
        if (i >> 30 == 0) {
            n += 2;
            i <<= 2;
        }
        return n - (i >>> 31);
    }

    public static int numberOfTrailingZeros(int i) {
        return NTZ_TABLE[(i & -i) * 72416175 >>> 26];
    }

    public static int bitCount(int i) {
        i -= i >> 1 & 0x55555555;
        i = (i & 0x33333333) + (i >> 2 & 0x33333333);
        i = (i >> 4) + i & 0xF0F0F0F;
        i += i >> 8;
        i += i >> 16;
        return i & 0x3F;
    }

    public static int rotateLeft(int value, int distance) {
        return value << distance | value >>> -distance;
    }

    public static int rotateRight(int value, int distance) {
        return value >>> distance | value << -distance;
    }

    public static int reverse(int i) {
        i = i >>> 1 & 0x55555555 | (i & 0x55555555) << 1;
        i = i >>> 2 & 0x33333333 | (i & 0x33333333) << 2;
        i = i >>> 4 & 0xF0F0F0F | (i & 0xF0F0F0F) << 4;
        i = i >>> 8 & 0xFF00FF | (i & 0xFF00FF) << 8;
        return i >>> 16 | i << 16;
    }

    public static int signum(int value) {
        return value >> 31 | -value >>> 31;
    }

    @HaxeMethodBody(value="return HaxeNatives.swap32(p0);")
    public static int reverseBytes(int value) {
        return value >>> 24 | value >> 8 & 0xFF00 | value << 8 & 0xFF0000 | value << 24;
    }

    public static int sum(int l, int r) {
        return l + r;
    }

    public static int max(int l, int r) {
        return Math.max(l, r);
    }

    public static int min(int l, int r) {
        return Math.min(l, r);
    }

    static {
        NTZ_TABLE = new byte[]{32, 0, 1, 12, 2, 6, -1, 13, 3, -1, 7, -1, -1, -1, -1, 14, 10, 4, -1, -1, 8, -1, -1, 25, -1, -1, -1, -1, -1, 21, 27, 15, 31, 11, 5, -1, -1, -1, -1, -1, 9, -1, -1, 24, -1, -1, 20, 26, 30, -1, -1, -1, -1, 23, -1, 19, 29, -1, 22, 18, 28, 17, 16, -1};
    }
}

