/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscMethodBodyList;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import java.lang.reflect.Type;

public final class Array {
    private Array() {
    }

    @HaxeMethodBody(value="return new HaxeArrayBool(p0);")
    @JTranscMethodBody(target="js", value={"return new JA_Z(p0);"})
    private static boolean[] newBoolInstance(int length) throws NegativeArraySizeException {
        return new boolean[length];
    }

    @HaxeMethodBody(value="return new HaxeArrayByte(p0);")
    @JTranscMethodBody(target="js", value={"return new JA_B(p0);"})
    private static byte[] newByteInstance(int length) throws NegativeArraySizeException {
        return new byte[length];
    }

    @HaxeMethodBody(value="return new HaxeArrayChar(p0);")
    @JTranscMethodBody(target="js", value={"return new JA_C(p0);"})
    private static char[] newCharInstance(int length) throws NegativeArraySizeException {
        return new char[length];
    }

    @HaxeMethodBody(value="return new HaxeArrayShort(p0);")
    @JTranscMethodBody(target="js", value={"return new JA_S(p0);"})
    private static short[] newShortInstance(int length) throws NegativeArraySizeException {
        return new short[length];
    }

    @HaxeMethodBody(value="return new HaxeArrayInt(p0);")
    @JTranscMethodBody(target="js", value={"return new JA_I(p0);"})
    private static int[] newIntInstance(int length) throws NegativeArraySizeException {
        return new int[length];
    }

    @HaxeMethodBody(value="return new HaxeArrayLong(p0);")
    @JTranscMethodBody(target="js", value={"return new JA_J(p0);"})
    private static long[] newLongInstance(int length) throws NegativeArraySizeException {
        return new long[length];
    }

    @HaxeMethodBody(value="return new HaxeArrayFloat(p0);")
    @JTranscMethodBody(target="js", value={"return new JA_F(p0);"})
    private static float[] newFloatInstance(int length) throws NegativeArraySizeException {
        return new float[length];
    }

    @HaxeMethodBody(value="return new HaxeArrayDouble(p0);")
    @JTranscMethodBody(target="js", value={"return new JA_D(p0);"})
    private static Object newDoubleInstance(int length) throws NegativeArraySizeException {
        return new double[length];
    }

    @HaxeMethodBody(value="return new HaxeArrayAny(p0, p1._str);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return new JA_L(p0, N.istr(p1));"}), @JTranscMethodBody(target="cpp", value={"return SOBJ(new JA_L(p0, N::istr2(p1)));"})})
    private static native Object newObjectInstance(int var0, String var1) throws NegativeArraySizeException;

    public static Object newInstance(Class<?> type, int length) throws NegativeArraySizeException {
        if (type == null) {
            throw new NullPointerException("Array.newInstance");
        }
        if (!type.isPrimitive()) {
            return Array.newObjectInstance(length, "[" + type.getName());
        }
        if (type == Boolean.TYPE) {
            return Array.newBoolInstance(length);
        }
        if (type == Byte.TYPE) {
            return Array.newByteInstance(length);
        }
        if (type == Short.TYPE) {
            return Array.newShortInstance(length);
        }
        if (type == Character.TYPE) {
            return Array.newCharInstance(length);
        }
        if (type == Integer.TYPE) {
            return Array.newIntInstance(length);
        }
        if (type == Long.TYPE) {
            return Array.newLongInstance(length);
        }
        if (type == Float.TYPE) {
            return Array.newFloatInstance(length);
        }
        if (type == Double.TYPE) {
            return Array.newDoubleInstance(length);
        }
        if (type == Void.TYPE) {
            throw new RuntimeException("Invalid Array of void type");
        }
        throw new RuntimeException("Invalid Array.newInstance with " + type);
    }

    public static Object newInstance(Class<?> componentType, int ... dimensions) throws IllegalArgumentException, NegativeArraySizeException {
        if (dimensions.length == 1) {
            return Array.newInstance(componentType, dimensions[0]);
        }
        throw new RuntimeException("Not implemented dynamically creating multidimensional arrays!");
    }

    @HaxeMethodBody(value="return cast(p0, HaxeArrayBase).length;")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return p0.length;"}), @JTranscMethodBody(target="cpp", value={"return GET_OBJECT_NPE(JA_0, p0)->length;"})})
    public static native int getLength(Object var0) throws IllegalArgumentException;

    @HaxeMethodBody(value="return cast(p0, HaxeArrayAny).getDynamic(p1);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return p0.get(p1);"}), @JTranscMethodBody(target="cpp", value={"return GET_OBJECT_NPE(JA_L, p0)->get(p1);"})})
    private static native Object getInstance(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static Object get(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Type elementType = Array.getArrayElementType(array.getClass());
        if (elementType == Boolean.TYPE) {
            return Array.getBoolean(array, index);
        }
        if (elementType == Byte.TYPE) {
            return Array.getByte(array, index);
        }
        if (elementType == Character.TYPE) {
            return Character.valueOf(Array.getChar(array, index));
        }
        if (elementType == Short.TYPE) {
            return Array.getShort(array, index);
        }
        if (elementType == Integer.TYPE) {
            return Array.getInt(array, index);
        }
        if (elementType == Long.TYPE) {
            return Array.getLong(array, index);
        }
        if (elementType == Float.TYPE) {
            return Float.valueOf(Array.getFloat(array, index));
        }
        if (elementType == Double.TYPE) {
            return Array.getDouble(array, index);
        }
        return Array.getInstance(array, index);
    }

    @HaxeMethodBody(value="return cast(p0, HaxeArrayBool).getBool(p1);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return p0.get(p1) != 0;"}), @JTranscMethodBody(target="cpp", value={"return GET_OBJECT_NPE(JA_Z, p0)->get(p1);"})})
    public static boolean getBoolean(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return ((boolean[])array)[index];
    }

    @HaxeMethodBody(value="return cast(p0, HaxeArrayByte).get(p1);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return p0.get(p1);"}), @JTranscMethodBody(target="cpp", value={"return GET_OBJECT_NPE(JA_B, p0)->get(p1);"})})
    public static byte getByte(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return ((byte[])array)[index];
    }

    @HaxeMethodBody(value="return cast(p0, HaxeArrayChar).get(p1);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return p0.get(p1);"}), @JTranscMethodBody(target="cpp", value={"return GET_OBJECT_NPE(JA_C, p0)->get(p1);"})})
    public static char getChar(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return ((char[])array)[index];
    }

    @HaxeMethodBody(value="return cast(p0, HaxeArrayShort).get(p1);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return p0.get(p1);"}), @JTranscMethodBody(target="cpp", value={"return GET_OBJECT_NPE(JA_S, p0)->get(p1);"})})
    public static short getShort(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return ((short[])array)[index];
    }

    @HaxeMethodBody(value="return cast(p0, HaxeArrayInt).get(p1);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return p0.get(p1);"}), @JTranscMethodBody(target="cpp", value={"return GET_OBJECT_NPE(JA_I, p0)->get(p1);"})})
    public static int getInt(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return ((int[])array)[index];
    }

    @HaxeMethodBody(value="return cast(p0, HaxeArrayLong).get(p1);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return p0.get(p1);"}), @JTranscMethodBody(target="cpp", value={"return GET_OBJECT_NPE(JA_J, p0)->get(p1);"})})
    public static long getLong(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return ((long[])array)[index];
    }

    @HaxeMethodBody(value="return cast(p0, HaxeArrayFloat).get(p1);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return p0.get(p1);"}), @JTranscMethodBody(target="cpp", value={"return GET_OBJECT_NPE(JA_F, p0)->get(p1);"})})
    public static float getFloat(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return ((float[])array)[index];
    }

    @HaxeMethodBody(value="return cast(p0, HaxeArrayDouble).get(p1);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return p0.get(p1);"}), @JTranscMethodBody(target="cpp", value={"return GET_OBJECT_NPE(JA_D, p0)->get(p1);"})})
    public static double getDouble(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return ((double[])array)[index];
    }

    @HaxeMethodBody(value="cast(p0, HaxeArrayAny).setDynamic(p1, p2);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"p0.set(p1, p2);"}), @JTranscMethodBody(target="cpp", value={"GET_OBJECT_NPE(JA_L, p0)->set(p1, p2);"})})
    private static native void setInstance(Object var0, int var1, Object var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static void set(Object array, int index, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Type elementType = Array.getArrayElementType(array.getClass());
        if (elementType == Boolean.TYPE) {
            Array.setBoolean(array, index, (Boolean)value);
        } else if (elementType == Byte.TYPE) {
            Array.setByte(array, index, (Byte)value);
        } else if (elementType == Character.TYPE) {
            Array.setChar(array, index, ((Character)value).charValue());
        } else if (elementType == Short.TYPE) {
            Array.setShort(array, index, (Short)value);
        } else if (elementType == Integer.TYPE) {
            Array.setInt(array, index, (Integer)value);
        } else if (elementType == Long.TYPE) {
            Array.setLong(array, index, (Long)value);
        } else if (elementType == Float.TYPE) {
            Array.setFloat(array, index, ((Float)value).floatValue());
        } else if (elementType == Double.TYPE) {
            Array.setDouble(array, index, (Double)value);
        } else {
            Array.setInstance(array, index, value);
        }
    }

    @HaxeMethodBody(value="cast(p0, HaxeArrayBool).setBool(p1, p2);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"p0.set(p1, p2);"}), @JTranscMethodBody(target="cpp", value={"GET_OBJECT_NPE(JA_Z, p0)->set(p1, p2);"})})
    public static void setBoolean(Object array, int index, boolean v) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        ((boolean[])array)[index] = v;
    }

    @HaxeMethodBody(value="cast(p0, HaxeArrayByte).set(p1, p2);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"p0.set(p1, p2);"}), @JTranscMethodBody(target="cpp", value={"GET_OBJECT_NPE(JA_B, p0)->set(p1, p2);"})})
    public static void setByte(Object array, int index, byte v) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        ((byte[])array)[index] = v;
    }

    @HaxeMethodBody(value="cast(p0, HaxeArrayChar).set(p1, p2);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"p0.set(p1, p2);"}), @JTranscMethodBody(target="cpp", value={"GET_OBJECT_NPE(JA_C, p0)->set(p1, p2);"})})
    public static void setChar(Object array, int index, char v) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        ((char[])array)[index] = v;
    }

    @HaxeMethodBody(value="cast(p0, HaxeArrayShort).set(p1, p2);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"p0.set(p1, p2);"}), @JTranscMethodBody(target="cpp", value={"GET_OBJECT_NPE(JA_S, p0)->set(p1, p2);"})})
    public static void setShort(Object array, int index, short v) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        ((short[])array)[index] = v;
    }

    @HaxeMethodBody(value="cast(p0, HaxeArrayInt).set(p1, p2);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"p0.set(p1, p2);"}), @JTranscMethodBody(target="cpp", value={"GET_OBJECT_NPE(JA_I, p0)->set(p1, p2);"})})
    public static void setInt(Object array, int index, int v) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        ((int[])array)[index] = v;
    }

    @HaxeMethodBody(value="cast(p0, HaxeArrayLong).set(p1, p2);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"p0.set(p1, p2);"}), @JTranscMethodBody(target="cpp", value={"GET_OBJECT_NPE(JA_J, p0)->set(p1, p2);"})})
    public static void setLong(Object array, int index, long v) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        ((long[])array)[index] = v;
    }

    @HaxeMethodBody(value="cast(p0, HaxeArrayFloat).set(p1, p2);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"p0.set(p1, p2);"}), @JTranscMethodBody(target="cpp", value={"GET_OBJECT_NPE(JA_F, p0)->set(p1, p2);"})})
    public static void setFloat(Object array, int index, float v) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        ((float[])array)[index] = v;
    }

    @HaxeMethodBody(value="cast(p0, HaxeArrayDouble).set(p1, p2);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"p0.set(p1, p2);"}), @JTranscMethodBody(target="cpp", value={"GET_OBJECT_NPE(JA_D, p0)->set(p1, p2);"})})
    public static void setDouble(Object array, int index, double v) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        ((double[])array)[index] = v;
    }

    private static Type getArrayElementType(Class<?> clazz) {
        String name = clazz.getName();
        if (name.charAt(0) != '[') {
            throw new RuntimeException("Not an array");
        }
        try {
            return Class.forName(name.substring(1));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

