/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Arrays;

public class InetAddress
implements Serializable {
    public static final int AF_INET = 0;
    public static final int AF_INET6 = 1;
    public static final int AF_UNIX = 2;
    public static final int AF_UNSPEC = 3;
    private int family;
    byte[] ipaddress;
    String hostName;
    public static final InetAddress UNSPECIFIED = new InetAddress(3, null, null);

    InetAddress(int family, byte[] ipaddress, String hostName) {
        this.family = family;
        this.ipaddress = ipaddress;
        this.hostName = hostName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InetAddress)) {
            return false;
        }
        return Arrays.equals(this.ipaddress, ((InetAddress)obj).ipaddress);
    }

    public byte[] getAddress() {
        return (byte[])this.ipaddress.clone();
    }

    public static InetAddress[] getAllByName(String host) throws UnknownHostException {
        try {
            return new InetAddress[]{InetAddress.parseNumericAddress(host)};
        }
        catch (Throwable t) {
            throw new UnknownHostException(host);
        }
    }

    public static InetAddress getByName(String host) throws UnknownHostException {
        throw new RuntimeException("Not implemented");
    }

    public String getHostAddress() {
        return String.format("%d.%d.%d.%d", this.ipaddress[0], this.ipaddress[1], this.ipaddress[2], this.ipaddress[3]);
    }

    public String getHostName() {
        return this.getHostAddress();
    }

    public String getCanonicalHostName() {
        return this.getHostAddress();
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        return Inet4Address.LOOPBACK;
    }

    public int hashCode() {
        return Arrays.hashCode(this.ipaddress);
    }

    public String toString() {
        return (this.hostName == null ? "" : this.hostName) + "/" + this.getHostAddress();
    }

    public static boolean isNumeric(String address) {
        try {
            InetAddress.parseNumericAddress(address);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static InetAddress parseNumericAddress(String numericAddress) {
        if (numericAddress == null || numericAddress.isEmpty()) {
            return InetAddress.getLoopbackAddress();
        }
        if (numericAddress.contains(".")) {
            String[] parts = numericAddress.split(".");
            byte[] bytes = new byte[parts.length];
            return new Inet4Address(bytes, numericAddress);
        }
        throw new RuntimeException("Don't know how to handle address");
    }

    private static InetAddress[] loopbackAddresses() {
        return new InetAddress[]{Inet4Address.LOOPBACK};
    }

    public static InetAddress getLoopbackAddress() {
        return Inet4Address.LOOPBACK;
    }

    public boolean isAnyLocalAddress() {
        return false;
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isLoopbackAddress() {
        return false;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMulticastAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        return false;
    }

    public boolean isReachable(int timeout) throws IOException {
        return true;
    }

    private boolean isReachable(InetAddress destination, InetAddress source, int timeout) throws IOException {
        return true;
    }

    public static InetAddress getByAddress(byte[] ipAddress) throws UnknownHostException {
        return InetAddress.getByAddress(null, ipAddress, 0);
    }

    public static InetAddress getByAddress(String hostName, byte[] ipAddress) throws UnknownHostException {
        return InetAddress.getByAddress(hostName, ipAddress, 0);
    }

    private static InetAddress getByAddress(String hostName, byte[] ipAddress, int scopeId) throws UnknownHostException {
        if (ipAddress == null) {
            throw new UnknownHostException("ipAddress == null");
        }
        if (ipAddress.length == 4) {
            return new Inet4Address((byte[])ipAddress.clone(), hostName);
        }
        throw InetAddress.badAddressLength(ipAddress);
    }

    private static UnknownHostException badAddressLength(byte[] bytes) throws UnknownHostException {
        throw new UnknownHostException("Address is neither 4 or 16 bytes: " + Arrays.toString(bytes));
    }

    private static boolean isIPv4MappedAddress(byte[] ipAddress) {
        if (ipAddress == null || ipAddress.length != 16) {
            return false;
        }
        for (int i = 0; i < 10; ++i) {
            if (ipAddress[i] == 0) continue;
            return false;
        }
        return ipAddress[10] == -1 && ipAddress[11] == -1;
    }

    private static byte[] ipv4MappedToIPv4(byte[] mappedAddress) {
        byte[] ipv4Address = new byte[4];
        for (int i = 0; i < 4; ++i) {
            ipv4Address[i] = mappedAddress[12 + i];
        }
        return ipv4Address;
    }
}

