/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.MapEntry;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 8188218128353913216L;
    transient Object[] elementData;
    int size;
    transient int threshold;
    private static final int DEFAULT_MAX_SIZE = 21;
    private static final int loadFactor = 7500;
    transient int modCount = 0;
    private static final Object NULL_OBJECT = new Object();

    public IdentityHashMap() {
        this(21);
    }

    public IdentityHashMap(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("maxSize < 0: " + maxSize);
        }
        this.size = 0;
        this.threshold = this.getThreshold(maxSize);
        this.elementData = this.newElementArray(this.computeElementArraySize());
    }

    private int getThreshold(int maxSize) {
        return maxSize > 3 ? maxSize : 3;
    }

    private int computeElementArraySize() {
        int arraySize = (int)((long)this.threshold * 10000L / 7500L) * 2;
        return arraySize < 0 ? -arraySize : arraySize;
    }

    private Object[] newElementArray(int s) {
        return new Object[s];
    }

    public IdentityHashMap(Map<? extends K, ? extends V> map) {
        this(map.size() < 6 ? 11 : map.size() * 2);
        super.putAllImpl(map);
    }

    private V massageValue(Object value) {
        return (V)(value == NULL_OBJECT ? null : value);
    }

    @Override
    public void clear() {
        this.size = 0;
        for (int i = 0; i < this.elementData.length; ++i) {
            this.elementData[i] = null;
        }
        ++this.modCount;
    }

    @Override
    public boolean containsKey(Object key) {
        int index;
        if (key == null) {
            key = NULL_OBJECT;
        }
        return this.elementData[index = this.findIndex(key, this.elementData)] == key;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            value = NULL_OBJECT;
        }
        for (int i = 1; i < this.elementData.length; i += 2) {
            if (this.elementData[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        int index;
        if (key == null) {
            key = NULL_OBJECT;
        }
        if (this.elementData[index = this.findIndex(key, this.elementData)] == key) {
            Object result = this.elementData[index + 1];
            return this.massageValue(result);
        }
        return null;
    }

    private IdentityHashMapEntry<K, V> getEntry(Object key) {
        int index;
        if (key == null) {
            key = NULL_OBJECT;
        }
        if (this.elementData[index = this.findIndex(key, this.elementData)] == key) {
            return this.getEntry(index);
        }
        return null;
    }

    private IdentityHashMapEntry<K, V> getEntry(int index) {
        Object key = this.elementData[index];
        Object value = this.elementData[index + 1];
        if (key == NULL_OBJECT) {
            key = null;
        }
        if (value == NULL_OBJECT) {
            value = null;
        }
        return new IdentityHashMapEntry<Object, Object>(this, key, value);
    }

    private int findIndex(Object key, Object[] array) {
        int length = array.length;
        int index = this.getModuloHash(key, length);
        int last = (index + length - 2) % length;
        while (index != last && array[index] != key && array[index] != null) {
            index = (index + 2) % length;
        }
        return index;
    }

    private int getModuloHash(Object key, int length) {
        return (Collections.secondaryIdentityHash(key) & Integer.MAX_VALUE) % (length / 2) * 2;
    }

    @Override
    public V put(K key, V value) {
        int index;
        Object _key = key;
        Object _value = value;
        if (_key == null) {
            _key = NULL_OBJECT;
        }
        if (_value == null) {
            _value = NULL_OBJECT;
        }
        if (this.elementData[index = this.findIndex(_key, this.elementData)] != _key) {
            ++this.modCount;
            if (++this.size > this.threshold) {
                this.rehash();
                index = this.findIndex(_key, this.elementData);
            }
            this.elementData[index] = _key;
            this.elementData[index + 1] = null;
        }
        Object result = this.elementData[index + 1];
        this.elementData[index + 1] = _value;
        return this.massageValue(result);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAllImpl(map);
    }

    private void rehash() {
        int newlength = this.elementData.length * 2;
        if (newlength == 0) {
            newlength = 1;
        }
        Object[] newData = this.newElementArray(newlength);
        for (int i = 0; i < this.elementData.length; i += 2) {
            Object key = this.elementData[i];
            if (key == null) continue;
            int index = this.findIndex(key, newData);
            newData[index] = key;
            newData[index + 1] = this.elementData[i + 1];
        }
        this.elementData = newData;
        this.computeMaxSize();
    }

    private void computeMaxSize() {
        this.threshold = (int)((long)(this.elementData.length / 2) * 7500L / 10000L);
    }

    @Override
    public V remove(Object key) {
        Object object;
        int next;
        int index;
        if (key == null) {
            key = NULL_OBJECT;
        }
        if (this.elementData[index = (next = this.findIndex(key, this.elementData))] != key) {
            return null;
        }
        Object result = this.elementData[index + 1];
        int length = this.elementData.length;
        while ((object = this.elementData[next = (next + 2) % length]) != null) {
            boolean hashedOk;
            int hash = this.getModuloHash(object, length);
            boolean bl = hashedOk = hash > index;
            if (next < index) {
                hashedOk = hashedOk || hash <= next;
            } else {
                boolean bl2 = hashedOk = hashedOk && hash <= next;
            }
            if (hashedOk) continue;
            this.elementData[index] = object;
            this.elementData[index + 1] = this.elementData[next + 1];
            index = next;
        }
        --this.size;
        ++this.modCount;
        this.elementData[index] = null;
        this.elementData[index + 1] = null;
        return this.massageValue(result);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new IdentityHashMapEntrySet(this);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return IdentityHashMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return IdentityHashMap.this.size();
                }

                @Override
                public void clear() {
                    IdentityHashMap.this.clear();
                }

                @Override
                public boolean remove(Object key) {
                    if (IdentityHashMap.this.containsKey(key)) {
                        IdentityHashMap.this.remove(key);
                        return true;
                    }
                    return false;
                }

                @Override
                public Iterator<K> iterator() {
                    return new IdentityHashMapIterator(new MapEntry.Type<K, K, V>(){

                        @Override
                        public K get(MapEntry<K, V> entry) {
                            return entry.key;
                        }
                    }, IdentityHashMap.this);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection<V>(){

                @Override
                public boolean contains(Object object) {
                    return IdentityHashMap.this.containsValue(object);
                }

                @Override
                public int size() {
                    return IdentityHashMap.this.size();
                }

                @Override
                public void clear() {
                    IdentityHashMap.this.clear();
                }

                @Override
                public Iterator<V> iterator() {
                    return new IdentityHashMapIterator(new MapEntry.Type<V, K, V>(){

                        @Override
                        public V get(MapEntry<K, V> entry) {
                            return entry.value;
                        }
                    }, IdentityHashMap.this);
                }

                @Override
                public boolean remove(Object object) {
                    Iterator it = this.iterator();
                    while (it.hasNext()) {
                        if (object != it.next()) continue;
                        it.remove();
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.valuesCollection;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.size() != map.size()) {
                return false;
            }
            Set<Map.Entry<K, V>> set = this.entrySet();
            return set.equals(map.entrySet());
        }
        return false;
    }

    @Override
    public Object clone() {
        try {
            IdentityHashMap cloneHashMap = (IdentityHashMap)super.clone();
            cloneHashMap.elementData = this.newElementArray(this.elementData.length);
            System.arraycopy(this.elementData, 0, cloneHashMap.elementData, 0, this.elementData.length);
            return cloneHashMap;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size);
        for (MapEntry mapEntry : this.entrySet()) {
            stream.writeObject(mapEntry.key);
            stream.writeObject(mapEntry.value);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int savedSize = stream.readInt();
        this.threshold = this.getThreshold(21);
        this.elementData = this.newElementArray(this.computeElementArraySize());
        int i = savedSize;
        while (--i >= 0) {
            Object key = stream.readObject();
            this.put(key, stream.readObject());
        }
        this.size = savedSize;
    }

    private void putAllImpl(Map<? extends K, ? extends V> map) {
        if (map.entrySet() != null) {
            super.putAll(map);
        }
    }

    static class IdentityHashMapEntrySet<KT, VT>
    extends AbstractSet<Map.Entry<KT, VT>> {
        private final IdentityHashMap<KT, VT> associatedMap;

        public IdentityHashMapEntrySet(IdentityHashMap<KT, VT> hm) {
            this.associatedMap = hm;
        }

        IdentityHashMap<KT, VT> hashMap() {
            return this.associatedMap;
        }

        @Override
        public int size() {
            return this.associatedMap.size;
        }

        @Override
        public void clear() {
            this.associatedMap.clear();
        }

        @Override
        public boolean remove(Object object) {
            if (this.contains(object)) {
                this.associatedMap.remove(((Map.Entry)object).getKey());
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                IdentityHashMapEntry entry = ((IdentityHashMap)this.associatedMap).getEntry(((Map.Entry)object).getKey());
                return entry != null && entry.equals(object);
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<KT, VT>> iterator() {
            return new IdentityHashMapIterator(new MapEntry.Type<Map.Entry<KT, VT>, KT, VT>(){

                @Override
                public Map.Entry<KT, VT> get(MapEntry<KT, VT> entry) {
                    return entry;
                }
            }, this.associatedMap);
        }
    }

    static class IdentityHashMapIterator<E, KT, VT>
    implements Iterator<E> {
        private int position = 0;
        private int lastPosition = 0;
        final IdentityHashMap<KT, VT> associatedMap;
        int expectedModCount;
        final MapEntry.Type<E, KT, VT> type;
        boolean canRemove = false;

        IdentityHashMapIterator(MapEntry.Type<E, KT, VT> value, IdentityHashMap<KT, VT> hm) {
            this.associatedMap = hm;
            this.type = value;
            this.expectedModCount = hm.modCount;
        }

        @Override
        public boolean hasNext() {
            while (this.position < this.associatedMap.elementData.length) {
                if (this.associatedMap.elementData[this.position] == null) {
                    this.position += 2;
                    continue;
                }
                return true;
            }
            return false;
        }

        void checkConcurrentMod() throws ConcurrentModificationException {
            if (this.expectedModCount != this.associatedMap.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public E next() {
            this.checkConcurrentMod();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            IdentityHashMapEntry result = ((IdentityHashMap)this.associatedMap).getEntry(this.position);
            this.lastPosition = this.position;
            this.position += 2;
            this.canRemove = true;
            return this.type.get(result);
        }

        @Override
        public void remove() {
            this.checkConcurrentMod();
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            this.canRemove = false;
            this.associatedMap.remove(this.associatedMap.elementData[this.lastPosition]);
            this.position = this.lastPosition;
            ++this.expectedModCount;
        }
    }

    static class IdentityHashMapEntry<K, V>
    extends MapEntry<K, V> {
        private final IdentityHashMap<K, V> map;

        IdentityHashMapEntry(IdentityHashMap<K, V> map, K theKey, V theValue) {
            super(theKey, theValue);
            this.map = map;
        }

        @Override
        public Object clone() {
            return super.clone();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this.key == entry.getKey() && this.value == entry.getValue();
            }
            return false;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.key) ^ System.identityHashCode(this.value);
        }

        @Override
        public String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        public V setValue(V object) {
            V result = super.setValue(object);
            this.map.put(this.key, object);
            return result;
        }
    }
}

