/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class ServiceLoader<S>
implements Iterable<S> {
    private final Class<S> service;
    private final List<S> list;

    private ServiceLoader(Class<S> service) {
        Objects.requireNonNull(service);
        this.service = service;
        this.list = Arrays.asList(this.getInstances(service.getName()));
        this.reload();
    }

    private Object[] getInstances(String fqname) {
        return new Object[0];
    }

    public void reload() {
    }

    @Override
    public Iterator<S> iterator() {
        return this.list.iterator();
    }

    public static <S> ServiceLoader<S> load(Class<S> service, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return new ServiceLoader<S>(service);
    }

    public static <S> ServiceLoader<S> load(Class<S> service) {
        return ServiceLoader.load(service, Thread.currentThread().getContextClassLoader());
    }

    public static <S> ServiceLoader<S> loadInstalled(Class<S> service) {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        if (cl != null) {
            while (cl.getParent() != null) {
                cl = cl.getParent();
            }
        }
        return ServiceLoader.load(service, cl);
    }

    public static <S> S loadFromSystemProperty(Class<S> service) {
        try {
            String className = System.getProperty(service.getName());
            if (className != null) {
                return (S)ClassLoader.getSystemClassLoader().loadClass(className).newInstance();
            }
            return null;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public String toString() {
        return "ServiceLoader for " + this.service.getName();
    }
}

