/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.TargetDataLine;

public class AudioInputStream
extends InputStream {
    private InputStream stream;
    protected AudioFormat format;
    protected long frameLength;
    protected int frameSize;
    protected long framePos;
    private long markpos;
    private byte[] pushBackBuffer = null;
    private int pushBackLen = 0;
    private byte[] markPushBackBuffer = null;
    private int markPushBackLen = 0;

    public AudioInputStream(InputStream stream, AudioFormat format, long length) {
        this.format = format;
        this.frameLength = length;
        this.frameSize = format.getFrameSize();
        this.stream = stream;
        this.framePos = 0L;
        this.markpos = 0L;
    }

    public AudioInputStream(TargetDataLine line) {
        this.format = line.getFormat();
        this.frameLength = -1L;
        this.frameSize = this.format.getFrameSize();
        this.stream = new InputStream(){

            @Override
            public native int read() throws IOException;
        };
        this.framePos = 0L;
        this.markpos = 0L;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public long getFrameLength() {
        return this.frameLength;
    }

    @Override
    public native int read() throws IOException;

    @Override
    public native int read(byte[] var1) throws IOException;

    @Override
    public native int read(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public native long skip(long var1) throws IOException;

    @Override
    public native int available() throws IOException;

    @Override
    public native void close() throws IOException;

    @Override
    public native void mark(int var1);

    @Override
    public native void reset() throws IOException;

    @Override
    public native boolean markSupported();
}

