/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import com.jtransc.JTranscBits;
import java.nio.ByteOrder;

public class Memory {
    private static ByteOrder NATIVE = ByteOrder.nativeOrder();
    private static ByteOrder SWAPPED = NATIVE == ByteOrder.LITTLE_ENDIAN ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;

    public static int peekInt(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            return (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | (src[offset] & 0xFF) << 0;
        }
        return (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset] & 0xFF) << 24;
    }

    public static long peekLong(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            int h = (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 0;
            int l = (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | (src[offset] & 0xFF) << 0;
            return (long)h << 32 | (long)l & 0xFFFFFFFFL;
        }
        int l = (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 24;
        int h = (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset] & 0xFF) << 24;
        return (long)h << 32 | (long)l & 0xFFFFFFFFL;
    }

    public static short peekShort(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            return (short)(src[offset] << 8 | src[offset + 1] & 0xFF);
        }
        return (short)(src[offset + 1] << 8 | src[offset] & 0xFF);
    }

    public static void pokeInt(byte[] dst, int offset, int value, ByteOrder order) {
        JTranscBits.writeInt((byte[])dst, (int)offset, (int)value, (order == ByteOrder.LITTLE_ENDIAN ? 1 : 0) != 0);
    }

    public static void pokeLong(byte[] dst, int offset, long value, ByteOrder order) {
        JTranscBits.writeLong((byte[])dst, (int)offset, (long)value, (order == ByteOrder.LITTLE_ENDIAN ? 1 : 0) != 0);
    }

    public static void pokeShort(byte[] dst, int offset, short value, ByteOrder order) {
        JTranscBits.writeShort((byte[])dst, (int)offset, (short)value, (order == ByteOrder.LITTLE_ENDIAN ? 1 : 0) != 0);
    }

    public static void unsafeBulkGet(Object dst, int dstOffset, int byteCount, byte[] src, int srcOffset, int sizeofElements, boolean swap) {
        if (!(dst instanceof int[])) {
            throw new RuntimeException("Unhandled unsafeBulkGet dst: " + dst);
        }
        Memory.unsafeBulkGet((int[])dst, dstOffset, byteCount, src, srcOffset, sizeofElements, swap);
    }

    public static void unsafeBulkGet(int[] dst, int dstOffset, int byteCount, byte[] src, int srcOffset, int sizeofElements, boolean swap) {
        int elementCount = byteCount / 4;
        ByteOrder order = swap ? SWAPPED : NATIVE;
        for (int n = 0; n < elementCount; ++n) {
            dst[dstOffset + n] = Memory.peekInt(src, srcOffset + n * sizeofElements, order);
        }
    }
}

