/*
 * Decompiled with CFR 0.152.
 */
package regexodus;

import com.jtransc.annotation.JTranscInvisible;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import regexodus.GwtIncompatible;
import regexodus.MatchResult;
import regexodus.Matcher;
import regexodus.Pattern;
import regexodus.PerlSubstitution;
import regexodus.Substitution;
import regexodus.TextBuffer;

@JTranscInvisible
public class Replacer
implements Serializable {
    private static final long serialVersionUID = 2528136757932720807L;
    private Pattern pattern;
    private Substitution substitution;

    public Replacer(Pattern pattern, Substitution substitution) {
        this.pattern = pattern;
        this.substitution = substitution;
    }

    public Replacer(Pattern pattern, String substitution) {
        this(pattern, substitution, true);
    }

    public Replacer(Pattern pattern, String substitution, boolean isPerlExpr) {
        this.pattern = pattern;
        this.substitution = isPerlExpr ? new PerlSubstitution(substitution) : new DummySubstitution(substitution);
    }

    public void setSubstitution(String s, boolean isPerlExpr) {
        this.substitution = isPerlExpr ? new PerlSubstitution(s) : new DummySubstitution(s);
    }

    public String replace(CharSequence text) {
        StringBuilderBuffer tb = Replacer.wrap(new StringBuilder(text.length()));
        Replacer.replace(this.pattern.matcher(text), this.substitution, tb);
        return ((Object)tb).toString();
    }

    public String replace(CharSequence text, int count) {
        StringBuilderBuffer tb = Replacer.wrap(new StringBuilder(text.length()));
        Replacer.replace(this.pattern.matcher(text), this.substitution, tb, count);
        return ((Object)tb).toString();
    }

    public String replace(char[] chars, int off, int len) {
        StringBuilderBuffer tb = Replacer.wrap(new StringBuilder(len));
        Replacer.replace(this.pattern.matcher(chars, off, len), this.substitution, tb);
        return ((Object)tb).toString();
    }

    public String replace(MatchResult res, int group) {
        StringBuilderBuffer tb = Replacer.wrap(new StringBuilder());
        Replacer.replace(this.pattern.matcher(res, group), this.substitution, tb);
        return ((Object)tb).toString();
    }

    @GwtIncompatible
    public String replace(Reader text, int length) throws IOException {
        StringBuilderBuffer tb = Replacer.wrap(new StringBuilder(length >= 0 ? length : 0));
        Replacer.replace(this.pattern.matcher(text, length), this.substitution, tb);
        return ((Object)tb).toString();
    }

    public int replace(CharSequence text, StringBuilder sb) {
        return Replacer.replace(this.pattern.matcher(text), this.substitution, Replacer.wrap(sb));
    }

    public int replace(CharSequence text, StringBuilder sb, int count) {
        return Replacer.replace(this.pattern.matcher(text), this.substitution, Replacer.wrap(sb), count);
    }

    public int replace(char[] chars, int off, int len, StringBuilder sb) {
        return this.replace(chars, off, len, Replacer.wrap(sb));
    }

    public int replace(MatchResult res, int group, StringBuilder sb) {
        return this.replace(res, group, (TextBuffer)Replacer.wrap(sb));
    }

    public int replace(MatchResult res, String groupName, StringBuilder sb) {
        return this.replace(res, groupName, (TextBuffer)Replacer.wrap(sb));
    }

    @GwtIncompatible
    public int replace(Reader text, int length, StringBuilder sb) throws IOException {
        return this.replace(text, length, (TextBuffer)Replacer.wrap(sb));
    }

    public int replace(CharSequence text, TextBuffer dest) {
        return Replacer.replace(this.pattern.matcher(text), this.substitution, dest);
    }

    private int replace(char[] chars, int off, int len, TextBuffer dest) {
        return Replacer.replace(this.pattern.matcher(chars, off, len), this.substitution, dest);
    }

    private int replace(MatchResult res, int group, TextBuffer dest) {
        return Replacer.replace(this.pattern.matcher(res, group), this.substitution, dest);
    }

    private int replace(MatchResult res, String groupName, TextBuffer dest) {
        return Replacer.replace(this.pattern.matcher(res, groupName), this.substitution, dest);
    }

    @GwtIncompatible
    private int replace(Reader text, int length, TextBuffer dest) throws IOException {
        return Replacer.replace(this.pattern.matcher(text, length), this.substitution, dest);
    }

    public static int replace(Matcher m, Substitution substitution, TextBuffer dest) {
        boolean firstPass = true;
        int c = 0;
        while (m.find()) {
            if (m.end() == 0 && !firstPass) continue;
            if (m.start() > 0) {
                m.getGroup(-1, dest);
            }
            substitution.appendSubstitution(m, dest);
            ++c;
            m.setTarget(m, -2);
            firstPass = false;
        }
        m.getGroup(-3, dest);
        return c;
    }

    public static int replace(Matcher m, Substitution substitution, TextBuffer dest, int count) {
        boolean firstPass = true;
        int c = 0;
        while (c < count && m.find()) {
            if (m.end() == 0 && !firstPass) continue;
            if (m.start() > 0) {
                m.getGroup(-1, dest);
            }
            substitution.appendSubstitution(m, dest);
            ++c;
            m.setTarget(m, -2);
            firstPass = false;
        }
        m.getGroup(-3, dest);
        return c;
    }

    public static boolean replaceStep(Matcher m, Substitution substitution, TextBuffer dest) {
        boolean firstPass = true;
        int c = 0;
        int count = 1;
        while (c < count && m.find()) {
            if (m.end() == 0 && !firstPass) continue;
            if (m.start() > 0) {
                m.getGroup(-1, dest);
            }
            substitution.appendSubstitution(m, dest);
            ++c;
            m.setTarget(m, -2);
            firstPass = false;
        }
        return c > 0;
    }

    @GwtIncompatible
    private static int replace(Matcher m, Substitution substitution, Writer out) throws IOException {
        try {
            return Replacer.replace(m, substitution, Replacer.wrap(out));
        }
        catch (WriteException e) {
            throw e.reason;
        }
    }

    @GwtIncompatible
    public void replace(CharSequence text, Writer out) throws IOException {
        Replacer.replace(this.pattern.matcher(text), this.substitution, out);
    }

    @GwtIncompatible
    public void replace(char[] chars, int off, int len, Writer out) throws IOException {
        Replacer.replace(this.pattern.matcher(chars, off, len), this.substitution, out);
    }

    @GwtIncompatible
    public void replace(MatchResult res, int group, Writer out) throws IOException {
        Replacer.replace(this.pattern.matcher(res, group), this.substitution, out);
    }

    @GwtIncompatible
    public void replace(MatchResult res, String groupName, Writer out) throws IOException {
        Replacer.replace(this.pattern.matcher(res, groupName), this.substitution, out);
    }

    @GwtIncompatible
    public void replace(Reader in, int length, Writer out) throws IOException {
        Replacer.replace(this.pattern.matcher(in, length), this.substitution, out);
    }

    public static Replacer makeTable(String ... pairs) {
        if (pairs == null || pairs.length < 2) {
            return new Replacer(Pattern.compile("(.+)"), new DummySubstitution("\\1"));
        }
        TableSubstitution tab = new TableSubstitution(pairs);
        StringBuilder sb = new StringBuilder(128);
        sb.append("(?>");
        for (String s : tab.dictionary.keySet()) {
            sb.append("\\Q");
            sb.append(s);
            sb.append("\\E|");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(')');
        return new Replacer(Pattern.compile(sb.toString()), tab);
    }

    public static Replacer makeTable(Map<String, String> dict) {
        if (dict == null || dict.isEmpty()) {
            return new Replacer(Pattern.compile("(.+)"), new DummySubstitution("\\1"));
        }
        TableSubstitution tab = new TableSubstitution(new LinkedHashMap<String, String>(dict));
        StringBuilder sb = new StringBuilder(128);
        sb.append("(?>");
        for (String s : tab.dictionary.keySet()) {
            sb.append("\\Q");
            sb.append(s);
            sb.append("\\E|");
        }
        sb.setCharAt(sb.length() - 1, ')');
        return new Replacer(Pattern.compile(sb.toString()), tab);
    }

    public static StringBuilderBuffer wrap(StringBuilder sb) {
        return new StringBuilderBuffer(sb);
    }

    public static StringBufferBuffer wrap(StringBuffer sb) {
        return new StringBufferBuffer(sb);
    }

    @GwtIncompatible
    private static TextBuffer wrap(final Writer writer) {
        return new TextBuffer(){

            @Override
            public void append(char c) {
                try {
                    writer.write(c);
                }
                catch (IOException e) {
                    throw new WriteException(e);
                }
            }

            @Override
            public void append(char[] chars, int off, int len) {
                try {
                    writer.write(chars, off, len);
                }
                catch (IOException e) {
                    throw new WriteException(e);
                }
            }

            @Override
            public void append(String s) {
                try {
                    writer.write(s);
                }
                catch (IOException e) {
                    throw new WriteException(e);
                }
            }
        };
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Substitution getSubstitution() {
        return this.substitution;
    }

    public void setSubstitution(Substitution substitution) {
        this.substitution = substitution;
    }

    public void setSubstitution(String substitution) {
        this.substitution = new PerlSubstitution(substitution);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Replacer replacer = (Replacer)o;
        return this.pattern != null ? this.pattern.equals(replacer.pattern) : replacer.pattern == null && (this.substitution != null ? this.substitution.equals(replacer.substitution) : replacer.substitution == null);
    }

    public int hashCode() {
        int result = this.pattern != null ? this.pattern.hashCode() : 0;
        result = 31 * result + (this.substitution != null ? this.substitution.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Replacer{pattern=" + this.pattern + ", substitution=" + this.substitution + '}';
    }

    private static class WriteException
    extends RuntimeException {
        IOException reason;

        WriteException(IOException io) {
            this.reason = io;
        }
    }

    public static class StringBufferBuffer
    implements TextBuffer,
    Serializable {
        private static final long serialVersionUID = 2589054766833218313L;
        public StringBuffer sb;

        public StringBufferBuffer() {
            this.sb = new StringBuffer();
        }

        public StringBufferBuffer(StringBuffer builder) {
            this.sb = builder;
        }

        @Override
        public void append(char c) {
            this.sb.append(c);
        }

        @Override
        public void append(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void append(String s) {
            this.sb.append(s);
        }

        public String toString() {
            return this.sb.toString();
        }

        public StringBuffer toStringBuffer() {
            return this.sb;
        }
    }

    public static class StringBuilderBuffer
    implements TextBuffer,
    Serializable {
        private static final long serialVersionUID = 2589054766833218313L;
        public StringBuilder sb;

        public StringBuilderBuffer() {
            this.sb = new StringBuilder();
        }

        public StringBuilderBuffer(StringBuilder builder) {
            this.sb = builder;
        }

        @Override
        public void append(char c) {
            this.sb.append(c);
        }

        @Override
        public void append(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void append(String s) {
            this.sb.append(s);
        }

        public String toString() {
            return this.sb.toString();
        }

        public StringBuilder toStringBuilder() {
            return this.sb;
        }
    }

    private static class TableSubstitution
    implements Substitution {
        final LinkedHashMap<String, String> dictionary;

        TableSubstitution(LinkedHashMap<String, String> dict) {
            this.dictionary = dict;
        }

        TableSubstitution(String ... dict) {
            this.dictionary = new LinkedHashMap(dict.length / 2);
            for (int i = 0; i < dict.length - 1; i += 2) {
                this.dictionary.put(dict[i], dict[i + 1]);
            }
        }

        @Override
        public void appendSubstitution(MatchResult match, TextBuffer dest) {
            String m = match.group(0);
            if (m == null) {
                return;
            }
            for (Map.Entry kv : this.dictionary.entrySet()) {
                if (!((String)kv.getKey()).equals(m)) continue;
                dest.append((String)kv.getValue());
                return;
            }
            dest.append(m);
        }
    }

    private static class DummySubstitution
    implements Substitution {
        String str;

        DummySubstitution(String s) {
            this.str = s;
        }

        @Override
        public void appendSubstitution(MatchResult match, TextBuffer res) {
            if (this.str != null) {
                res.append(this.str);
            }
        }
    }
}

