/*
 * Decompiled with CFR 0.152.
 */
package regexodus.ds;

import com.jtransc.annotation.JTranscInvisible;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

@JTranscInvisible
public class CharArrayList
implements RandomAccess,
Cloneable,
Serializable,
List<Character>,
Comparable<List<? extends Character>> {
    private static final long serialVersionUID = -7046029254386353130L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private transient char[] a;
    private int size;

    protected CharArrayList(char[] a, boolean dummy) {
        this.a = a;
    }

    public CharArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = new char[capacity];
    }

    private CharArrayList() {
        this(16);
    }

    public CharArrayList(CharArrayList l) {
        this(l.size());
        this.size = l.size();
        l.getElements(0, this.a, 0, this.size);
    }

    private CharArrayList(char ... a) {
        this(a, 0, a.length);
    }

    public CharArrayList(String s) {
        this(s.toCharArray());
    }

    private CharArrayList(char[] a, int offset, int length) {
        this(length);
        System.arraycopy(a, offset, this.a, 0, length);
        this.size = length;
    }

    public CharArrayList(Iterator<? extends Character> i) {
        this();
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    public char[] elements() {
        return this.a;
    }

    private static CharArrayList wrap(char[] a, int length) {
        if (length > a.length) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + a.length + ")");
        }
        CharArrayList l = new CharArrayList(a, false);
        l.size = length;
        return l;
    }

    public static CharArrayList wrap(char[] a) {
        return CharArrayList.wrap(a, a.length);
    }

    private void ensureCapacity(int capacity) {
        this.a = CharArrays.ensureCapacity(this.a, capacity, this.size);
    }

    private void grow(int capacity) {
        this.a = CharArrays.grow(this.a, capacity, this.size);
    }

    @Override
    private void add(int index, char k) {
        this.ensureIndex(index);
        this.grow(this.size + 1);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + 1, this.size - index);
        }
        this.a[index] = k;
        ++this.size;
    }

    @Override
    private boolean add(char k) {
        this.grow(this.size + 1);
        this.a[this.size++] = k;
        return true;
    }

    @Override
    public boolean add(int k) {
        this.grow(this.size + 1);
        this.a[this.size++] = (char)k;
        return true;
    }

    public char getChar(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[index];
    }

    public int getCodePoint(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[index];
    }

    private int indexOf(char k) {
        for (int i = 0; i < this.size; ++i) {
            if (k != this.a[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char k) {
        int i = this.size;
        while (i-- != 0) {
            if (k != this.a[i]) continue;
            return i;
        }
        return -1;
    }

    private char removeChar(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        char old = this.a[index];
        --this.size;
        if (index != this.size) {
            System.arraycopy(this.a, index + 1, this.a, index, this.size - index);
        }
        return old;
    }

    private boolean rem(char k) {
        int index = this.indexOf(k);
        if (index == -1) {
            return false;
        }
        this.removeChar(index);
        return true;
    }

    @Override
    @Deprecated
    public Character set(int index, Character ok) {
        return Character.valueOf(this.set(index, ok.charValue()));
    }

    @Override
    public void add(int index, Character element) {
    }

    @Override
    public Character remove(int index) {
        return null;
    }

    @Override
    public int indexOf(Object o) {
        return 0;
    }

    @Override
    public int lastIndexOf(Object o) {
        return 0;
    }

    @Override
    private char set(int index, char k) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        char old = this.a[index];
        this.a[index] = k;
        return old;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Character> c) {
        this.ensureIndex(index);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        Iterator<? extends Character> i = c.iterator();
        while (n-- != 0) {
            this.add(index++, i.next());
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void size(int size) {
        if (size > this.a.length) {
            this.ensureCapacity(size);
        }
        if (size > this.size) {
            Arrays.fill(this.a, this.size, size, '\u0000');
        }
        this.size = size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public void trim() {
        this.trim(0);
    }

    private void trim(int n) {
        if (n >= this.a.length || this.size == this.a.length) {
            return;
        }
        char[] t = new char[Math.max(n, this.size)];
        System.arraycopy(this.a, 0, t, 0, this.size);
        this.a = t;
    }

    private void getElements(int from, char[] a, int offset, int length) {
        CharArrays.ensureOffsetLength(a, offset, length);
        System.arraycopy(this.a, from, a, offset, length);
    }

    public void removeElements(int from, int to) {
        CharArrays.ensureFromTo(this.size, from, to);
        System.arraycopy(this.a, to, this.a, from, this.size - to);
        this.size -= to - from;
    }

    public void addElements(int index, char[] a, int offset, int length) {
        this.ensureIndex(index);
        CharArrays.ensureOffsetLength(a, offset, length);
        this.grow(this.size + length);
        System.arraycopy(this.a, index, this.a, index + length, this.size - index);
        System.arraycopy(a, offset, this.a, index, length);
        this.size += length;
    }

    private char[] toCharArray(char[] a) {
        if (a == null || a.length < this.size) {
            a = new char[this.size];
        }
        System.arraycopy(this.a, 0, a, 0, this.size);
        return a;
    }

    public boolean addAll(int index, CharArrayList l) {
        this.ensureIndex(index);
        int n = l.size();
        if (n == 0) {
            return false;
        }
        this.grow(this.size + n);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + n, this.size - index);
        }
        l.getElements(0, this.a, index, n);
        this.size += n;
        return true;
    }

    public CharListIterator iterator() {
        return this.listIterator();
    }

    public CharListIterator listIterator() {
        return this.listIterator(0);
    }

    public CharListIterator listIterator(int index) {
        this.ensureIndex(index);
        return new CharListIterator(index);
    }

    @Override
    public List<Character> subList(int fromIndex, int toIndex) {
        return new CharArrayList(this.a, fromIndex, toIndex - fromIndex);
    }

    public CharArrayList clone() {
        CharArrayList c = new CharArrayList(this.size);
        System.arraycopy(this.a, 0, c.a, 0, this.size);
        c.size = this.size;
        return c;
    }

    public boolean equals(CharArrayList l) {
        if (l == this) {
            return true;
        }
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        char[] a1 = this.a;
        char[] a2 = l.a;
        while (s-- != 0) {
            if (a1[s] == a2[s]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(CharArrayList l) {
        int i;
        int s1 = this.size();
        int s2 = l.size();
        char[] a1 = this.a;
        char[] a2 = l.a;
        for (i = 0; i < s1 && i < s2; ++i) {
            char e1 = a1[i];
            char e2 = a2[i];
            int r = e1 - e2;
            if (r == 0) continue;
            return r;
        }
        return i < s2 ? -1 : (i < s1 ? 1 : 0);
    }

    @Override
    public int compareTo(List<? extends Character> l) {
        if (l == this) {
            return 0;
        }
        if (l instanceof CharArrayList) {
            CharListIterator i1 = this.listIterator();
            CharListIterator i2 = ((CharArrayList)l).listIterator();
            while (i1.hasNext() && i2.hasNext()) {
                char e2;
                char e1 = i1.nextChar();
                int r = e1 - (e2 = i2.nextChar());
                if (r == 0) continue;
                return r;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        CharListIterator i1 = this.listIterator();
        ListIterator<? extends Character> i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r = ((Comparable)i1.next()).compareTo(i2.next());
            if (r == 0) continue;
            return r;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    @Override
    public int hashCode() {
        CharListIterator i = this.iterator();
        int h = 1;
        int s = this.size();
        while (s-- != 0) {
            char k = i.nextChar();
            h = 31 * h + k;
        }
        return h;
    }

    @Override
    @Deprecated
    public Character get(int index) {
        return Character.valueOf(this.getChar(index));
    }

    private void ensureIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    private boolean contains(char k) {
        return this.indexOf(k) >= 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.contains(((Character)o).charValue());
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.size()];
        CharArrayList.objectUnwrap(this.iterator(), a);
        return a;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Character[] b = a.length < this.size() ? new Character[this.size()] : (Character[])a;
        CharArrayList.objectUnwrap(this.iterator(), b);
        return b;
    }

    public Character[] toArray(Character[] a) {
        if (a.length < this.size()) {
            a = new Character[this.size()];
        }
        CharArrayList.objectUnwrap(this.iterator(), a);
        return a;
    }

    @Override
    public boolean add(Character o) {
        return this.add(o.charValue());
    }

    @Override
    public boolean remove(Object ok) {
        return this.rem(((Character)ok).charValue());
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        int n = c.size();
        Iterator<?> i = c.iterator();
        while (n-- != 0) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Character> c) {
        boolean retVal = false;
        Iterator<? extends Character> i = c.iterator();
        int n = c.size();
        while (n-- != 0) {
            if (!this.add(i.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    private static <K> int objectUnwrap(Iterator<? extends K> i, K[] array) {
        int j = array.length;
        int offset = 0;
        while (j-- != 0 && i.hasNext()) {
            array[offset++] = i.next();
        }
        return array.length - j - 1;
    }

    public char[] toArray(char[] a) {
        return this.toCharArray(a);
    }

    public char[] toCharArray() {
        return this.toCharArray(null);
    }

    public String toString() {
        return new String(this.a, 0, this.size);
    }

    public static int unwrap(CharListIterator i, char[] array) {
        int j = array.length;
        int offset = 0;
        while (j-- != 0 && i.hasNext()) {
            array[offset++] = i.nextChar();
        }
        return array.length - j - 1;
    }

    private static class CharArrays {
        public static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
        public static final char[] EMPTY_ARRAY = new char[0];

        private CharArrays() {
        }

        public static char[] ensureCapacity(char[] array, int length) {
            if (length > array.length) {
                char[] t = new char[length];
                System.arraycopy(array, 0, t, 0, array.length);
                return t;
            }
            return array;
        }

        public static char[] ensureCapacity(char[] array, int length, int preserve) {
            if (length > array.length) {
                char[] t = new char[length];
                System.arraycopy(array, 0, t, 0, preserve);
                return t;
            }
            return array;
        }

        public static char[] grow(char[] array, int length) {
            if (length > array.length) {
                int newLength = (int)Math.max(Math.min(2L * (long)array.length, 0x7FFFFFF7L), (long)length);
                char[] t = new char[newLength];
                System.arraycopy(array, 0, t, 0, array.length);
                return t;
            }
            return array;
        }

        public static char[] grow(char[] array, int length, int preserve) {
            if (length > array.length) {
                int newLength = (int)Math.max(Math.min(2L * (long)array.length, 0x7FFFFFF7L), (long)length);
                char[] t = new char[newLength];
                System.arraycopy(array, 0, t, 0, preserve);
                return t;
            }
            return array;
        }

        public static char[] trim(char[] array, int length) {
            if (length >= array.length) {
                return array;
            }
            char[] t = length == 0 ? EMPTY_ARRAY : new char[length];
            System.arraycopy(array, 0, t, 0, length);
            return t;
        }

        public static char[] setLength(char[] array, int length) {
            if (length == array.length) {
                return array;
            }
            if (length < array.length) {
                return CharArrays.trim(array, length);
            }
            return CharArrays.ensureCapacity(array, length);
        }

        public static char[] copy(char[] array, int offset, int length) {
            CharArrays.ensureOffsetLength(array, offset, length);
            char[] a = length == 0 ? EMPTY_ARRAY : new char[length];
            System.arraycopy(array, offset, a, 0, length);
            return a;
        }

        public static char[] copy(char[] array) {
            char[] next = new char[array.length];
            System.arraycopy(array, 0, next, 0, array.length);
            return next;
        }

        @Deprecated
        public static void fill(char[] array, char value) {
            int i = array.length;
            while (i-- != 0) {
                array[i] = value;
            }
        }

        @Deprecated
        public static void fill(char[] array, int from, int to, char value) {
            CharArrays.ensureFromTo(array, from, to);
            if (from == 0) {
                while (to-- != 0) {
                    array[to] = value;
                }
            } else {
                for (int i = from; i < to; ++i) {
                    array[i] = value;
                }
            }
        }

        @Deprecated
        public static boolean equals(char[] a1, char[] a2) {
            int i = a1.length;
            if (i != a2.length) {
                return false;
            }
            while (i-- != 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }

        public static void ensureFromTo(char[] a, int from, int to) {
            CharArrays.ensureFromTo(a.length, from, to);
        }

        public static void ensureOffsetLength(char[] a, int offset, int length) {
            CharArrays.ensureOffsetLength(a.length, offset, length);
        }

        public static void ensureSameLength(char[] a, char[] b) {
            if (a.length != b.length) {
                throw new IllegalArgumentException("Array size mismatch: " + a.length + " != " + b.length);
            }
        }

        public static void ensureFromTo(int arrayLength, int from, int to) {
            if (from < 0) {
                throw new ArrayIndexOutOfBoundsException("Start index (" + from + ") is negative");
            }
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            if (to > arrayLength) {
                throw new ArrayIndexOutOfBoundsException("End index (" + to + ") is greater than array length (" + arrayLength + ")");
            }
        }

        public static void ensureOffsetLength(int arrayLength, int offset, int length) {
            if (offset < 0) {
                throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
            }
            if (length < 0) {
                throw new IllegalArgumentException("Length (" + length + ") is negative");
            }
            if (offset + length > arrayLength) {
                throw new ArrayIndexOutOfBoundsException("Last index (" + (offset + length) + ") is greater than array length (" + arrayLength + ")");
            }
        }
    }

    public class CharListIterator
    implements Iterator<Character>,
    ListIterator<Character> {
        int index;
        int pos;
        int last;

        public CharListIterator(int idx) {
            this.pos = this.index;
            this.last = -1;
            this.index = idx;
        }

        @Override
        public Character previous() {
            return Character.valueOf(this.previousChar());
        }

        @Override
        public boolean hasNext() {
            return this.pos < CharArrayList.this.size;
        }

        @Override
        public boolean hasPrevious() {
            return this.pos > 0;
        }

        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos++;
            return CharArrayList.this.a[this.last];
        }

        public char previousChar() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.last = --this.pos;
            return CharArrayList.this.a[this.pos];
        }

        @Override
        public int nextIndex() {
            return this.pos;
        }

        @Override
        public int previousIndex() {
            return this.pos - 1;
        }

        @Override
        public void set(Character ok) {
            this.set(ok.charValue());
        }

        @Override
        public void add(Character ok) {
            this.add(ok.charValue());
        }

        @Override
        public void add(char k) {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            CharArrayList.this.add(this.pos++, k);
            this.last = -1;
        }

        @Override
        public void set(char k) {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            CharArrayList.this.set(this.last, k);
        }

        @Override
        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            CharArrayList.this.removeChar(this.last);
            if (this.last < this.pos) {
                --this.pos;
            }
            this.last = -1;
        }

        @Override
        @Deprecated
        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextChar();
            }
            return n - i - 1;
        }
    }
}

