/*
 * Decompiled with CFR 0.152.
 */
package regexodus.regex;

import com.jtransc.annotation.JTranscInvisible;
import regexodus.PerlSubstitution;
import regexodus.Replacer;
import regexodus.TextBuffer;
import regexodus.regex.MatchResult;
import regexodus.regex.Pattern;

@JTranscInvisible
public class Matcher
implements MatchResult {
    private regexodus.Matcher matcher;
    private Pattern pattern;

    Matcher() {
    }

    Matcher(Pattern parent, CharSequence text) {
        this.pattern = parent;
        this.matcher = new regexodus.Matcher(parent.internal, text);
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public MatchResult toMatchResult() {
        return this.matcher.copy();
    }

    public Matcher usePattern(Pattern newPattern) {
        if (newPattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        this.matcher.setPattern(newPattern.internal);
        return this;
    }

    public Matcher reset() {
        this.matcher.flush();
        return this;
    }

    public Matcher reset(CharSequence input) {
        this.matcher.setTarget(input);
        return this.reset();
    }

    @Override
    public int start() {
        return this.matcher.start();
    }

    @Override
    public int start(int group) {
        return this.matcher.start(group);
    }

    @Override
    public int start(String name) {
        return this.matcher.start(name);
    }

    @Override
    public int end(String name) {
        return this.matcher.end(1);
    }

    @Override
    public int end() {
        return this.matcher.end();
    }

    @Override
    public int end(int group) {
        return this.matcher.end(group);
    }

    @Override
    public String group() {
        return this.matcher.group();
    }

    @Override
    public String group(int group) {
        return this.matcher.group(group);
    }

    public String group(String name) {
        return this.matcher.group(name);
    }

    @Override
    public int groupCount() {
        return this.matcher.groupCount();
    }

    public boolean matches() {
        return this.matcher.matches();
    }

    public boolean find() {
        return this.matcher.find();
    }

    public boolean find(int start) {
        int limit = this.matcher.targetEnd();
        if (start < 0 || start > limit) {
            throw new IndexOutOfBoundsException("Illegal start index");
        }
        this.reset();
        this.matcher.setPosition(start);
        return this.matcher.find();
    }

    public boolean lookingAt() {
        return this.matcher.search(8);
    }

    public static String quoteReplacement(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '$') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public Matcher appendReplacement(StringBuffer sb, String replacement) {
        Replacer rep = this.pattern.internal.replacer(replacement);
        Replacer.replaceStep(this.matcher, new PerlSubstitution(replacement), Replacer.wrap(sb));
        return this;
    }

    public StringBuffer appendTail(StringBuffer sb) {
        this.matcher.getGroup(-3, (TextBuffer)Replacer.wrap(sb));
        return sb;
    }

    public String replaceAll(String replacement) {
        this.reset();
        return this.matcher.replaceAll(replacement);
    }

    public String replaceFirst(String replacement) {
        if (replacement == null) {
            throw new NullPointerException("replacement");
        }
        this.reset();
        return this.matcher.replaceFirst(replacement);
    }

    public Matcher region(int start, int end) {
        if (start < 0 || start < 0) {
            throw new IndexOutOfBoundsException("start");
        }
        if (end < 0 || end > this.matcher.dataEnd()) {
            throw new IndexOutOfBoundsException("end");
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start > end");
        }
        this.matcher.setTarget(this.matcher.targetChars(), start, end - start);
        return this;
    }

    public int regionStart() {
        return this.matcher.targetStart();
    }

    public int regionEnd() {
        return this.matcher.targetEnd();
    }

    public boolean hasTransparentBounds() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Matcher useTransparentBounds(boolean b) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean hasAnchoringBounds() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Matcher useAnchoringBounds(boolean b) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String toString() {
        return this.matcher.toString();
    }

    public boolean hitEnd() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean requireEnd() {
        throw new UnsupportedOperationException("Not implemented");
    }
}

