/*
 * Decompiled with CFR 0.152.
 */
package regexodus.regex;

import com.jtransc.annotation.JTranscInvisible;
import java.io.Serializable;
import java.util.ArrayList;
import regexodus.Matcher;

@JTranscInvisible
public class Pattern
implements Serializable {
    private static final long serialVersionUID = -3628346657932720807L;
    public regexodus.Pattern internal;
    private int flags;
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int LITERAL = 16;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int CANON_EQ = 128;
    public static final int UNICODE_CHARACTER_CLASS = 256;

    public static Pattern compile(String regex) {
        return new Pattern(regex, 0);
    }

    public static Pattern compile(String regex, int flags) {
        return new Pattern(regex, flags);
    }

    public String pattern() {
        return this.internal.toString();
    }

    public String toString() {
        return this.internal.toString();
    }

    public regexodus.regex.Matcher matcher(CharSequence input) {
        return new regexodus.regex.Matcher(this, input);
    }

    public int flags() {
        return this.flags;
    }

    public static boolean matches(String regex, CharSequence input) {
        Pattern p = Pattern.compile(regex);
        return p.matcher(input).matches();
    }

    public String[] split(CharSequence input, int limit) {
        int resultSize;
        int index = 0;
        boolean matchLimited = limit > 0;
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher m = new Matcher(this.internal, input);
        while (m.find()) {
            String match;
            if (!matchLimited || matchList.size() < limit - 1) {
                match = input.subSequence(index, m.start()).toString();
                matchList.add(match);
                index = m.end();
                continue;
            }
            if (matchList.size() != limit - 1) continue;
            match = input.subSequence(index, input.length()).toString();
            matchList.add(match);
            index = m.end();
        }
        if (index == 0) {
            return new String[]{input.toString()};
        }
        if (!matchLimited || matchList.size() < limit) {
            matchList.add(input.subSequence(index, input.length()).toString());
        }
        if (limit == 0) {
            for (resultSize = matchList.size(); resultSize > 0 && ((String)matchList.get(resultSize - 1)).equals(""); --resultSize) {
            }
        }
        String[] result = new String[resultSize];
        return matchList.subList(0, resultSize).toArray(result);
    }

    public String[] split(CharSequence input) {
        return this.split(input, 0);
    }

    public static String quote(String s) {
        int slashEIndex = s.indexOf("\\E");
        if (slashEIndex == -1) {
            return "\\Q" + s + "\\E";
        }
        StringBuilder sb = new StringBuilder(s.length() * 2);
        sb.append("\\Q");
        int current = 0;
        while ((slashEIndex = s.indexOf("\\E", current)) != -1) {
            sb.append(s.substring(current, slashEIndex));
            current = slashEIndex + 2;
            sb.append("\\E\\\\E\\Q");
        }
        sb.append(s.substring(current, s.length()));
        sb.append("\\E");
        return sb.toString();
    }

    private Pattern(String p, int flags) {
        int fm = (flags & 2) != 0 ? 1 : 0;
        this.flags = flags;
        fm |= (flags & 0x20) != 0 ? 4 : 0;
        fm |= (flags & 4) != 0 ? 8 : 0;
        fm |= (flags & 8) != 0 ? 2 : 0;
        this.internal = (flags & 0x10) != 0 ? regexodus.Pattern.compile(Pattern.quote(p), fm) : regexodus.Pattern.compile(p, fm |= (flags & 0x100) != 0 ? 16 : 0);
    }
}

