/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Line;

public interface DataLine
extends Line {
    public void drain();

    public void flush();

    public void start();

    public void stop();

    public boolean isRunning();

    public boolean isActive();

    public AudioFormat getFormat();

    public int getBufferSize();

    public int available();

    public int getFramePosition();

    public long getLongFramePosition();

    public long getMicrosecondPosition();

    public float getLevel();

    public static class Info
    extends Line.Info {
        private final AudioFormat[] formats;
        private final int minBufferSize;
        private final int maxBufferSize;

        public Info(Class<?> lineClass, AudioFormat format, int bufferSize) {
            this(lineClass, new AudioFormat[]{format}, bufferSize, bufferSize);
        }

        public Info(Class<?> lineClass, AudioFormat[] formats, int minBufferSize, int maxBufferSize) {
            super(lineClass);
            this.formats = formats;
            this.minBufferSize = minBufferSize;
            this.maxBufferSize = maxBufferSize;
        }

        public Info(Class<?> lineClass, AudioFormat format) {
            this(lineClass, format, -1);
        }

        public AudioFormat[] getFormats() {
            return this.formats;
        }

        public boolean isFormatSupported(AudioFormat format) {
            return true;
        }

        public int getMinBufferSize() {
            return this.minBufferSize;
        }

        public int getMaxBufferSize() {
            return this.maxBufferSize;
        }

        @Override
        public boolean matches(Line.Info info) {
            return true;
        }
    }
}

