/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.Component;
import java.awt.event.ComponentEvent;

public abstract class InputEvent
extends ComponentEvent {
    public static final int SHIFT_MASK = 1;
    public static final int CTRL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int ALT_MASK = 8;
    public static final int ALT_GRAPH_MASK = 32;
    public static final int BUTTON1_MASK = 16;
    public static final int BUTTON2_MASK = 8;
    public static final int BUTTON3_MASK = 4;
    public static final int SHIFT_DOWN_MASK = 64;
    public static final int CTRL_DOWN_MASK = 128;
    public static final int META_DOWN_MASK = 256;
    public static final int ALT_DOWN_MASK = 512;
    public static final int BUTTON1_DOWN_MASK = 1024;
    public static final int BUTTON2_DOWN_MASK = 2048;
    public static final int BUTTON3_DOWN_MASK = 4096;
    public static final int ALT_GRAPH_DOWN_MASK = 8192;
    public long when;
    public int modifiers;
    public boolean consumed;

    public InputEvent(Component source, int id, long when, int modifiers) {
        super(source, id);
        this.when = when;
        this.modifiers = modifiers;
    }

    public static int getMaskForButton(int button) {
        int offset = 1 << 10 + button;
        if (button < 4) {
            --offset;
        }
        return 1 << offset;
    }

    public boolean isShiftDown() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isControlDown() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isMetaDown() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isAltDown() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isAltGraphDown() {
        return (this.modifiers & 0x20) != 0;
    }

    public long getWhen() {
        return this.when;
    }

    public int getModifiers() {
        return this.modifiers & 0x8000003F;
    }

    public int getModifiersEx() {
        return this.modifiers & 0xFFFFFFC0;
    }

    public void consume() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public static String getModifiersExText(int modifiers) {
        return "MODS" + modifiers;
    }
}

