/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.util.Objects;

public final class StackTraceElement
implements Serializable {
    private String declaringClass;
    private String methodName;
    private String fileName;
    private int lineNumber;

    public StackTraceElement(String declaringClass, String methodName, String fileName, int lineNumber) {
        this.declaringClass = Objects.requireNonNull(declaringClass, "Declaring class is null");
        this.methodName = Objects.requireNonNull(methodName, "Method name is null");
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getClassName() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String toString() {
        return this.getClassName() + "." + this.methodName + (this.isNativeMethod() ? "(Native Method)" : (this.fileName != null && this.lineNumber >= 0 ? "(" + this.fileName + ":" + this.lineNumber + ")" : (this.fileName != null ? "(" + this.fileName + ")" : "(Unknown Source)")));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement e = (StackTraceElement)obj;
        return e.declaringClass.equals(this.declaringClass) && e.lineNumber == this.lineNumber && Objects.equals(this.methodName, e.methodName) && Objects.equals(this.fileName, e.fileName);
    }

    public int hashCode() {
        int result = 31 * this.declaringClass.hashCode() + this.methodName.hashCode();
        result = 31 * result + Objects.hashCode(this.fileName);
        result = 31 * result + this.lineNumber;
        return result;
    }
}

