/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.JTranscSystem;
import com.jtransc.annotation.JTranscAddMembers;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.thread.JTranscThreading;
import java.util.HashMap;
import java.util.Map;

@JTranscAddMembers(target="d", value={"static {% CLASS java.lang.Thread %} _dCurrentThread;", "Thread thread;"})
public class Thread
implements Runnable {
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private static Thread _currentThread;
    private static final StackTraceElement[] ST_NULL;
    private ThreadGroup group;
    public String name;
    private long stackSize;
    public long _data;
    public boolean _isAlive;
    private Runnable target;
    private ClassLoader classLoader = null;

    @JTranscMethodBody(target="d", value={"if (_dCurrentThread is null) {", "\t_dCurrentThread = new {% CLASS java.lang.Thread %}();", "}", "return _dCurrentThread;"})
    public static Thread currentThread() {
        if (_currentThread == null) {
            _currentThread = new Thread();
        }
        return _currentThread;
    }

    public StackTraceElement[] getStackTrace() {
        StackTraceElement[] stackTrace = this._getStackTrace();
        if (stackTrace == null || stackTrace.length == 0) {
            return new StackTraceElement[]{new StackTraceElement("Dummy", "dummy", "Dummy.java", 1), new StackTraceElement("Dummy", "dummy", "Dummy.java", 1), new StackTraceElement("Dummy", "dummy", "Dummy.java", 1)};
        }
        return stackTrace;
    }

    @HaxeMethodBody(value="return N.getStackTrace(2);")
    @JTranscMethodBody(target="js", value={"return N.getStackTrace(2);"})
    private StackTraceElement[] _getStackTrace() {
        return ST_NULL;
    }

    @JTranscMethodBody(target="d", value={"Thread.yield();"})
    public static void yield() {
    }

    @JTranscMethodBody(target="d", value={"Thread.sleep(dur!(\"msecs\")(p0));"})
    public static void sleep(long millis) throws InterruptedException {
        JTranscSystem.sleep((double)millis);
    }

    @JTranscMethodBody(target="d", value={"Thread.sleep(dur!(\"msecs\")(p0) + dur!(\"nsecs\")(p1));"})
    public static void sleep(long millis, int nanos) throws InterruptedException {
        JTranscSystem.sleep((double)millis);
    }

    public Thread() {
    }

    public Thread(Runnable target) {
        this(null, target, null, 1024L);
    }

    public Thread(ThreadGroup group, Runnable target) {
        this(group, target, null, 1024L);
    }

    public Thread(String name) {
        this(null, null, name, 1024L);
    }

    public Thread(ThreadGroup group, String name) {
        this(group, null, name, 1024L);
    }

    public Thread(Runnable target, String name) {
        this(null, target, name, 1024L);
    }

    public Thread(ThreadGroup group, Runnable target, String name) {
        this(group, target, name, 1024L);
    }

    public Thread(ThreadGroup group, Runnable target, String name, long stackSize) {
        this.group = group;
        this.target = target;
        this.name = name;
        this.stackSize = stackSize;
        this._init();
    }

    @JTranscMethodBody(target="d", value={"this.thread = new Thread(delegate () {", "\t{% METHOD java.lang.Thread:runInternal:()V %}();", "});"})
    private void _init() {
    }

    @JTranscMethodBody(target="d", value={"this.thread.start();"})
    public synchronized void start() {
        JTranscThreading.impl.start(this);
    }

    private void runInternal() {
        this.runInternalInit();
        this.run();
    }

    @JTranscMethodBody(target="d", value={"_dCurrentThread = this;"})
    private void runInternalInit() {
    }

    @Override
    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    @Deprecated
    @JTranscMethodBody(target="d", value={"this.thread.stop();"})
    public final native void stop();

    @Deprecated
    public final synchronized void stop(Throwable obj) {
    }

    public void interrupt() {
    }

    public static boolean interrupted() {
        return false;
    }

    public boolean isInterrupted() {
        return false;
    }

    @Deprecated
    public void destroy() {
    }

    public final boolean isAlive() {
        return JTranscThreading.impl.isAlive(this);
    }

    @Deprecated
    public final native void suspend();

    @Deprecated
    public final native void resume();

    public final native void setPriority(int var1);

    public final native int getPriority();

    public final synchronized void setName(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final native ThreadGroup getThreadGroup();

    public static native int activeCount();

    public static native int enumerate(Thread[] var0);

    @Deprecated
    public native int countStackFrames();

    public final synchronized native void join(long var1) throws InterruptedException;

    public final synchronized native void join(long var1, int var3) throws InterruptedException;

    public final native void join() throws InterruptedException;

    public static native void dumpStack();

    @JTranscMethodBody(target="d", value={"this.thread.isDaemon = p0;"})
    public final native void setDaemon(boolean var1);

    @JTranscMethodBody(target="d", value={"return this.thread.isDaemon;"})
    public final native boolean isDaemon();

    public final native void checkAccess();

    public String toString() {
        ThreadGroup group = this.getThreadGroup();
        if (group != null) {
            return "Thread[" + this.getName() + "," + this.getPriority() + "," + group.getName() + "]";
        }
        return "Thread[" + this.getName() + "," + this.getPriority() + "," + "]";
    }

    public ClassLoader getContextClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = _ClassInternalUtils.getSystemClassLoader();
        }
        return this.classLoader;
    }

    public void setContextClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public static boolean holdsLock(Object obj) {
        return false;
    }

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        return new HashMap<Thread, StackTraceElement[]>();
    }

    @JTranscMethodBody(target="d", value={"return this.thread.id;"})
    public long getId() {
        return 0L;
    }

    public State getState() {
        return State.RUNNABLE;
    }

    public static native void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler var0);

    public static native UncaughtExceptionHandler getDefaultUncaughtExceptionHandler();

    public native UncaughtExceptionHandler getUncaughtExceptionHandler();

    public native void setUncaughtExceptionHandler(UncaughtExceptionHandler var1);

    static {
        ST_NULL = null;
    }

    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }

    public static enum State {
        NEW,
        RUNNABLE,
        BLOCKED,
        WAITING,
        TIMED_WAITING,
        TERMINATED;

    }
}

