/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;

public final class Currency
implements Serializable {
    private static final HashMap<String, Currency> codesToCurrencies = new HashMap();
    private static final HashMap<Locale, Currency> localesToCurrencies = new HashMap();
    private final String currencyCode;

    private Currency(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Currency getInstance(String currencyCode) {
        HashMap<String, Currency> hashMap = codesToCurrencies;
        synchronized (hashMap) {
            Currency currency = codesToCurrencies.get(currencyCode);
            if (currency == null) {
                currency = new Currency(currencyCode);
                codesToCurrencies.put(currencyCode, currency);
            }
            return currency;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Currency getInstance(Locale locale) {
        HashMap<Locale, Currency> hashMap = localesToCurrencies;
        synchronized (hashMap) {
            String currencyCode;
            Currency currency = localesToCurrencies.get(locale);
            if (currency != null) {
                return currency;
            }
            String country = locale.getCountry();
            String variant = locale.getVariant();
            if (!variant.isEmpty() && (variant.equals("EURO") || variant.equals("HK") || variant.equals("PREEURO"))) {
                country = country + "_" + variant;
            }
            if ((currencyCode = "USD") == null) {
                throw new IllegalArgumentException("Unsupported ISO 3166 country: " + locale);
            }
            if (currencyCode.equals("XXX")) {
                return null;
            }
            Currency result = Currency.getInstance(currencyCode);
            localesToCurrencies.put(locale, result);
            return result;
        }
    }

    public static Set<Currency> getAvailableCurrencies() {
        LinkedHashSet<Currency> result = new LinkedHashSet<Currency>();
        for (String currencyCode : new String[]{"USD"}) {
            result.add(Currency.getInstance(currencyCode));
        }
        return result;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getSymbol() {
        return this.getSymbol(Locale.getDefault());
    }

    public String toString() {
        return this.currencyCode;
    }

    private Object readResolve() {
        return Currency.getInstance(this.currencyCode);
    }

    public String getDisplayName(Locale locale) {
        return "USD";
    }

    public String getSymbol(Locale locale) {
        if (locale.getCountry().length() == 0) {
            return this.currencyCode;
        }
        return "$";
    }

    public int getDefaultFractionDigits() {
        return 2;
    }
}

