/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.jtransc.JTranscArrays;
import com.jtransc.annotation.haxe.HaxeAddFilesTemplate;
import com.jtransc.annotation.haxe.HaxeNativeConversion;
import com.jtransc.io.JTranscIoTools;
import java.io.Closeable;
import java.io.IOException;

@HaxeAddFilesTemplate(base="hx", value={"hx/JavaHaxeInput.hx"})
@HaxeNativeConversion(haxeType="haxe.io.Input", toHaxe="new JavaHaxeInput.Haxe(@self)", toJava="new JavaHaxeInput.Java(@self)")
public abstract class InputStream
implements Closeable {
    public int available() throws IOException {
        return 0;
    }

    @Override
    public void close() throws IOException {
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public abstract int read() throws IOException;

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        JTranscArrays.checkOffsetAndCount((int)buffer.length, (int)byteOffset, (int)byteCount);
        for (int i = 0; i < byteCount; ++i) {
            int c;
            try {
                c = this.read();
                if (c == -1) {
                    return i == 0 ? -1 : i;
                }
            }
            catch (IOException e) {
                if (i != 0) {
                    return i;
                }
                throw e;
            }
            buffer[byteOffset + i] = (byte)c;
        }
        return byteCount;
    }

    public synchronized void reset() throws IOException {
        throw new IOException();
    }

    public long skip(long byteCount) throws IOException {
        return JTranscIoTools.skipByReading((InputStream)this, (long)byteCount);
    }
}

