/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.jtransc.JTranscSystemProperties;
import com.jtransc.io.JTranscSyncIO;
import java.io.File;
import java.io.FileSystem;
import java.io.IOException;

class JTranscFileSystem
extends FileSystem {
    private final char slash = JTranscSystemProperties.fileSeparator().charAt(0);
    private final char colon = JTranscSystemProperties.pathSeparator().charAt(0);
    private final String javaHome = JTranscSystemProperties.javaHome();

    JTranscFileSystem() {
    }

    @Override
    public char getSeparator() {
        return this.slash;
    }

    @Override
    public char getPathSeparator() {
        return this.colon;
    }

    private String normalize(String pathname, int len, int off) {
        int n;
        if (len == 0) {
            return pathname;
        }
        for (n = len; n > 0 && pathname.charAt(n - 1) == '/'; --n) {
        }
        if (n == 0) {
            return "/";
        }
        StringBuffer sb = new StringBuffer(pathname.length());
        if (off > 0) {
            sb.append(pathname.substring(0, off));
        }
        int prevChar = 0;
        for (int i = off; i < n; ++i) {
            char c = pathname.charAt(i);
            if (prevChar == 47 && c == '/') continue;
            sb.append(c == '/' ? this.slash : c);
            prevChar = c;
        }
        return sb.toString();
    }

    @Override
    public String normalize(String pathname) {
        int len = pathname.length();
        StringBuilder out = new StringBuilder(len);
        char p = '\u0000';
        char c = '\u0000';
        for (int n = 0; n < len; ++n) {
            c = pathname.charAt(n);
            if (!(JTranscFileSystem.isSlash(c) && JTranscFileSystem.isSlash(p) || n >= len - 1 && (c == '/' || c == '\\'))) {
                out.append(JTranscFileSystem.isSlash(c) ? (char)'/' : (char)c);
            }
            p = c;
        }
        return out.toString();
    }

    private static boolean isSlash(char c) {
        return c == '/' || c == '\\';
    }

    @Override
    public int prefixLength(String pathname) {
        if (pathname.length() == 0) {
            return 0;
        }
        return pathname.charAt(0) == '/' ? 1 : 0;
    }

    public boolean isAbsolute(String path) {
        return JTranscSyncIO.impl.isAbsolute(path);
    }

    @Override
    public String resolve(String parent, String child) {
        if (this.isAbsolute(child)) {
            return child;
        }
        return parent + this.slash + child;
    }

    @Override
    public String getDefaultParent() {
        return "/";
    }

    @Override
    public String fromURIPath(String path) {
        String p = path;
        if (p.endsWith("/") && p.length() > 1) {
            p = p.substring(0, p.length() - 1);
        }
        return p;
    }

    @Override
    public boolean isAbsolute(File f) {
        String path = f.getPath();
        if (path.length() >= 2 && path.charAt(1) == ':') {
            return true;
        }
        return f.getPrefixLength() != 0;
    }

    @Override
    public String resolve(File f) {
        if (this.isAbsolute(f)) {
            return this.normalize2(f.getPath());
        }
        return this.normalize2(this.resolve(this.normalize2(JTranscSyncIO.impl.getCwd()), f.getPath()));
    }

    private String normalize2(String path) {
        return JTranscSyncIO.impl.normalizePath(path);
    }

    @Override
    public String canonicalize(String path) throws IOException {
        return this.normalize2(path);
    }

    static String parentOrNull(String path) {
        int last;
        if (path == null) {
            return null;
        }
        char sep = File.separatorChar;
        int adjacentDots = 0;
        int nonDotCount = 0;
        for (int idx = last = path.length() - 1; idx > 0; --idx) {
            char c = path.charAt(idx);
            if (c == '.') {
                if (++adjacentDots < 2) continue;
                return null;
            }
            if (c == sep) {
                if (adjacentDots == 1 && nonDotCount == 0) {
                    return null;
                }
                if (idx == 0 || idx >= last - 1 || path.charAt(idx - 1) == sep) {
                    return null;
                }
                return path.substring(0, idx);
            }
            ++nonDotCount;
            adjacentDots = 0;
        }
        return null;
    }

    public int getBooleanAttributes0(File f) {
        return JTranscSyncIO.impl.getBooleanAttributes(this.normalize2(f));
    }

    @Override
    public int getBooleanAttributes(File f) {
        int rv = this.getBooleanAttributes0(f);
        String name = f.getName();
        boolean hidden = name.length() > 0 && name.charAt(0) == '.';
        return rv | (hidden ? 8 : 0);
    }

    @Override
    public boolean checkAccess(File f, int access) {
        return JTranscSyncIO.impl.checkAccess(this.normalize2(f), access);
    }

    @Override
    public long getLastModifiedTime(File f) {
        return JTranscSyncIO.impl.getLastModifiedTime(this.normalize2(f));
    }

    @Override
    public long getLength(File f) {
        return JTranscSyncIO.impl.getLength(this.normalize2(f));
    }

    @Override
    public boolean setPermission(File f, int access, boolean enable, boolean owneronly) {
        return JTranscSyncIO.impl.setPermission(this.normalize2(f), access, enable, owneronly);
    }

    private String normalize2(File file) {
        return this.normalize2(file.getAbsolutePath());
    }

    @Override
    public boolean createFileExclusively(String path) throws IOException {
        return JTranscSyncIO.impl.createFileExclusively(this.normalize2(path));
    }

    @Override
    public boolean delete(File f) {
        return JTranscSyncIO.impl.delete(this.normalize2(f));
    }

    @Override
    public String[] list(File f) {
        return JTranscSyncIO.impl.list(this.normalize2(f));
    }

    @Override
    public boolean createDirectory(File f) {
        return JTranscSyncIO.impl.createDirectory(this.normalize2(f));
    }

    @Override
    public boolean rename(File f1, File f2) {
        return JTranscSyncIO.impl.rename(this.normalize2(f1), this.normalize2(f2));
    }

    @Override
    public boolean setLastModifiedTime(File f, long time) {
        return JTranscSyncIO.impl.setLastModifiedTime(this.normalize2(f), time);
    }

    @Override
    public boolean setReadOnly(File f) {
        return JTranscSyncIO.impl.setReadOnly(this.normalize2(f));
    }

    @Override
    public File[] listRoots() {
        return new File[]{new File("/")};
    }

    @Override
    public long getSpace(File f, int t) {
        switch (t) {
            case 0: {
                return JTranscSyncIO.impl.getTotalSpace(this.normalize2(f));
            }
            case 1: {
                return JTranscSyncIO.impl.getFreeSpace(this.normalize2(f));
            }
            case 2: {
                return JTranscSyncIO.impl.getUsableSpace(this.normalize2(f));
            }
        }
        return 0L;
    }

    @Override
    public int compare(File f1, File f2) {
        return f1.getPath().compareTo(f2.getPath());
    }

    @Override
    public int hashCode(File f) {
        return f.getPath().hashCode() ^ 0x12D591;
    }
}

