/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.math.RoundingMode;

public final class MathContext
implements Serializable {
    public static final MathContext DECIMAL128 = new MathContext(34, RoundingMode.HALF_EVEN);
    public static final MathContext DECIMAL32 = new MathContext(7, RoundingMode.HALF_EVEN);
    public static final MathContext DECIMAL64 = new MathContext(16, RoundingMode.HALF_EVEN);
    public static final MathContext UNLIMITED = new MathContext(0, RoundingMode.HALF_UP);
    private final int precision;
    private final RoundingMode roundingMode;

    public MathContext(int precision) {
        this(precision, RoundingMode.HALF_UP);
    }

    public MathContext(int precision, RoundingMode roundingMode) {
        this.precision = precision;
        this.roundingMode = roundingMode;
        this.checkValid();
    }

    public MathContext(String s) {
        int spaceIndex;
        int precisionLength = "precision=".length();
        int roundingModeLength = "roundingMode=".length();
        if (!s.startsWith("precision=") || (spaceIndex = s.indexOf(32, precisionLength)) == -1) {
            throw this.invalidMathContext("Missing precision", s);
        }
        String precisionString = s.substring(precisionLength, spaceIndex);
        try {
            this.precision = Integer.parseInt(precisionString);
        }
        catch (NumberFormatException nfe) {
            throw this.invalidMathContext("Bad precision", s);
        }
        int roundingModeStart = spaceIndex + 1;
        if (!s.regionMatches(roundingModeStart, "roundingMode=", 0, roundingModeLength)) {
            throw this.invalidMathContext("Missing rounding mode", s);
        }
        this.roundingMode = RoundingMode.valueOf(s.substring(roundingModeStart += roundingModeLength));
        this.checkValid();
    }

    private IllegalArgumentException invalidMathContext(String reason, String s) {
        throw new IllegalArgumentException(reason + ": " + s);
    }

    private void checkValid() {
        if (this.precision < 0) {
            throw new IllegalArgumentException("Negative precision: " + this.precision);
        }
        if (this.roundingMode == null) {
            throw new NullPointerException("roundingMode == null");
        }
    }

    public int getPrecision() {
        return this.precision;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public boolean equals(Object x) {
        return x instanceof MathContext && ((MathContext)x).getPrecision() == this.precision && ((MathContext)x).getRoundingMode() == this.roundingMode;
    }

    public int hashCode() {
        return this.precision << 3 | this.roundingMode.ordinal();
    }

    public String toString() {
        return "precision=" + this.precision + " roundingMode=" + (Object)((Object)this.roundingMode);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.checkValid();
        }
        catch (Exception ex) {
            throw new StreamCorruptedException(ex.getMessage());
        }
    }
}

