/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;

public abstract class AtomicReferenceFieldUpdater<T, V> {
    public static <U, W> AtomicReferenceFieldUpdater<U, W> newUpdater(Class<U> tclass, Class<W> vclass, String fieldName) {
        Field f;
        try {
            f = tclass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            try {
                f = tclass.getField(fieldName);
            }
            catch (NoSuchFieldException e2) {
                throw new RuntimeException(e2);
            }
        }
        if (f == null) {
            throw new RuntimeException("field==null");
        }
        final Field field = f;
        return new AtomicReferenceFieldUpdater<U, W>(){

            @Override
            public boolean compareAndSet(U obj, W expect, W update) {
                try {
                    if (field.get(obj) == expect) {
                        field.set(obj, update);
                        return true;
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                return false;
            }

            @Override
            public boolean weakCompareAndSet(U obj, W expect, W update) {
                return this.compareAndSet((U)obj, (W)expect, (W)update);
            }

            @Override
            public void set(U obj, W newValue) {
                try {
                    field.set(obj, newValue);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void lazySet(U obj, W newValue) {
                try {
                    field.set(obj, newValue);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public W get(U obj) {
                try {
                    return field.get(obj);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    protected AtomicReferenceFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, V var2, V var3);

    public abstract boolean weakCompareAndSet(T var1, V var2, V var3);

    public abstract void set(T var1, V var2);

    public abstract void lazySet(T var1, V var2);

    public abstract V get(T var1);

    public V getAndSet(T obj, V newValue) {
        V prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), newValue)) {
        }
        return prev;
    }
}

