/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.jtransc.JTranscArrays;
import java.io.IOException;
import java.io.Writer;

public class CharArrayWriter
extends Writer {
    protected char[] buf;
    protected int count;

    public CharArrayWriter() {
        this.buf = new char[32];
        this.lock = this.buf;
    }

    public CharArrayWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.buf = new char[initialSize];
        this.lock = this.buf;
    }

    @Override
    public void close() {
    }

    private void expand(int i) {
        if (this.count + i <= this.buf.length) {
            return;
        }
        int newLen = Math.max(2 * this.buf.length, this.count + i);
        char[] newbuf = new char[newLen];
        System.arraycopy((Object)this.buf, 0, (Object)newbuf, 0, this.count);
        this.buf = newbuf;
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.count = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] toCharArray() {
        Object object = this.lock;
        synchronized (object) {
            char[] result = new char[this.count];
            System.arraycopy((Object)this.buf, 0, (Object)result, 0, this.count);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return new String(this.buf, 0, this.count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] buffer, int offset, int len) {
        JTranscArrays.checkOffsetAndCount((int)buffer.length, (int)offset, (int)len);
        Object object = this.lock;
        synchronized (object) {
            this.expand(len);
            System.arraycopy((Object)buffer, offset, (Object)this.buf, this.count, len);
            this.count += len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int oneChar) {
        Object object = this.lock;
        synchronized (object) {
            this.expand(1);
            this.buf[this.count++] = (char)oneChar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String str, int offset, int count) {
        if (str == null) {
            throw new NullPointerException("str == null");
        }
        if ((offset | count) < 0 || offset > str.length() - count) {
            throw new StringIndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.expand(count);
            str.getChars(offset, offset + count, this.buf, this.count);
            this.count += count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Writer out) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            out.write(this.buf, 0, this.count);
        }
    }

    @Override
    public CharArrayWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public CharArrayWriter append(CharSequence csq) {
        if (csq == null) {
            csq = "null";
        }
        this.append(csq, 0, csq.length());
        return this;
    }

    @Override
    public CharArrayWriter append(CharSequence csq, int start, int end) {
        if (csq == null) {
            csq = "null";
        }
        String output = csq.subSequence(start, end).toString();
        this.write(output, 0, output.length());
        return this;
    }
}

