/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.jtransc.JTranscArrays;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PushbackInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int pos;

    public PushbackInputStream(InputStream in) {
        super(in);
        this.buf = in == null ? null : new byte[1];
        this.pos = 1;
    }

    public PushbackInputStream(InputStream in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.buf = in == null ? null : new byte[size];
        this.pos = size;
    }

    @Override
    public int available() throws IOException {
        if (this.buf == null) {
            throw new IOException();
        }
        return this.buf.length - this.pos + this.in.available();
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
            this.buf = null;
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.buf == null) {
            throw new IOException();
        }
        if (this.pos < this.buf.length) {
            return this.buf[this.pos++] & 0xFF;
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        if (this.buf == null) {
            throw this.streamClosed();
        }
        JTranscArrays.checkOffsetAndCount((int)buffer.length, (int)byteOffset, (int)byteCount);
        int copiedBytes = 0;
        int copyLength = 0;
        int newOffset = byteOffset;
        if (this.pos < this.buf.length) {
            copyLength = this.buf.length - this.pos >= byteCount ? byteCount : this.buf.length - this.pos;
            System.arraycopy((Object)this.buf, this.pos, (Object)buffer, newOffset, copyLength);
            newOffset += copyLength;
            copiedBytes += copyLength;
            this.pos += copyLength;
        }
        if (copyLength == byteCount) {
            return byteCount;
        }
        int inCopied = this.in.read(buffer, newOffset, byteCount - copiedBytes);
        if (inCopied > 0) {
            return inCopied + copiedBytes;
        }
        if (copiedBytes == 0) {
            return inCopied;
        }
        return copiedBytes;
    }

    private IOException streamClosed() throws IOException {
        throw new IOException("PushbackInputStream is closed");
    }

    @Override
    public long skip(long byteCount) throws IOException {
        if (this.in == null) {
            throw this.streamClosed();
        }
        if (byteCount <= 0L) {
            return 0L;
        }
        int numSkipped = 0;
        if (this.pos < this.buf.length) {
            numSkipped = (int)((long)numSkipped + (byteCount < (long)(this.buf.length - this.pos) ? byteCount : (long)(this.buf.length - this.pos)));
            this.pos += numSkipped;
        }
        if ((long)numSkipped < byteCount) {
            numSkipped = (int)((long)numSkipped + this.in.skip(byteCount - (long)numSkipped));
        }
        return numSkipped;
    }

    public void unread(byte[] buffer) throws IOException {
        this.unread(buffer, 0, buffer.length);
    }

    public void unread(byte[] buffer, int offset, int length) throws IOException {
        if (length > this.pos) {
            throw new IOException("Pushback buffer full");
        }
        JTranscArrays.checkOffsetAndCount((int)buffer.length, (int)offset, (int)length);
        if (this.buf == null) {
            throw this.streamClosed();
        }
        System.arraycopy((Object)buffer, offset, (Object)this.buf, this.pos - length, length);
        this.pos -= length;
    }

    public void unread(int oneByte) throws IOException {
        if (this.buf == null) {
            throw new IOException();
        }
        if (this.pos == 0) {
            throw new IOException("Pushback buffer full");
        }
        this.buf[--this.pos] = (byte)oneByte;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException();
    }
}

