/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.JTranscProcess;
import com.jtransc.lang.JTranscObjects;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;

public final class ProcessBuilder {
    private List<String> command;
    private File directory;
    private Map<String, String> environment;
    private boolean redirectErrorStream;
    private Redirect stdin = Redirect.PIPE;
    private Redirect stdout = Redirect.PIPE;
    private Redirect stderr = Redirect.PIPE;

    public ProcessBuilder(String ... command) {
        this.command(command);
    }

    public ProcessBuilder(List<String> command) {
        this.command(command);
    }

    public ProcessBuilder command(List<String> command) {
        this.command = command;
        return this;
    }

    public ProcessBuilder command(String ... command) {
        this.command = new ArrayList<String>(Arrays.asList(command));
        return this;
    }

    public List<String> command() {
        return this.command;
    }

    public Map<String, String> environment() {
        if (this.environment == null) {
            this.environment = new HashMap<String, String>();
        }
        return this.environment;
    }

    ProcessBuilder environment(String[] envp) {
        this.environment = new HashMap<String, String>(envp != null ? envp.length : 0);
        if (envp != null) {
            for (String envstring : envp) {
                int eqlsign = envstring.indexOf(61, 1);
                if (eqlsign < 0) continue;
                String key = envstring.substring(0, eqlsign);
                String value = envstring.substring(eqlsign + 1);
                this.environment.put(key, value);
            }
        }
        return this;
    }

    public File directory() {
        return this.directory;
    }

    public ProcessBuilder directory(File directory) {
        this.directory = directory;
        return this;
    }

    public ProcessBuilder redirectInput(Redirect source) {
        this.stdin = source;
        return this;
    }

    public ProcessBuilder redirectOutput(Redirect destination) {
        this.stdout = destination;
        return this;
    }

    public ProcessBuilder redirectError(Redirect destination) {
        this.stderr = destination;
        return this;
    }

    public ProcessBuilder redirectInput(File file) {
        return this.redirectInput(Redirect.from(file));
    }

    public ProcessBuilder redirectOutput(File file) {
        return this.redirectOutput(Redirect.to(file));
    }

    public ProcessBuilder redirectError(File file) {
        return this.redirectError(Redirect.to(file));
    }

    public Redirect redirectInput() {
        return this.stdin;
    }

    public Redirect redirectOutput() {
        return this.stdout;
    }

    public Redirect redirectError() {
        return this.stderr;
    }

    public ProcessBuilder inheritIO() {
        this.stdout = this.stderr = Redirect.INHERIT;
        this.stdin = this.stderr;
        return this;
    }

    public boolean redirectErrorStream() {
        return this.redirectErrorStream;
    }

    public ProcessBuilder redirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
        return this;
    }

    public Process start() throws IOException {
        try {
            JTranscProcess process = ServiceLoader.load(JTranscProcess.class).iterator().next();
            return process.start(this.command, this.environment, JTranscObjects.toStringOrNull((Object)this.directory), this.stdin, this.stdout, this.stderr, this.redirectErrorStream);
        }
        catch (Throwable cause) {
            throw new IOException("Problem executing process", cause);
        }
    }

    private static class RedirectImpl
    extends Redirect {
        Redirect.Type type;
        File file;

        RedirectImpl(Redirect.Type type, File file) {
            this.type = type;
            this.file = file;
        }

        @Override
        public Redirect.Type type() {
            return this.type;
        }

        @Override
        public File file() {
            return this.file;
        }
    }

    public static abstract class Redirect {
        public static final Redirect PIPE = new Redirect(){

            @Override
            public Type type() {
                return Type.PIPE;
            }

            @Override
            public String toString() {
                return this.type().toString();
            }
        };
        public static final Redirect INHERIT = new Redirect(){

            @Override
            public Type type() {
                return Type.INHERIT;
            }

            @Override
            public String toString() {
                return this.type().toString();
            }
        };

        public abstract Type type();

        public File file() {
            return null;
        }

        public static Redirect from(File file) {
            return new RedirectImpl(Type.READ, file);
        }

        public static Redirect to(File file) {
            return new RedirectImpl(Type.WRITE, file);
        }

        public static Redirect appendTo(File file) {
            return new RedirectImpl(Type.APPEND, file);
        }

        public boolean equals(Object that) {
            return JTranscObjects.equalsShape((Object)this, (Object)that) && ((Redirect)that).type() == this.type() && Objects.equals(this.file(), ((Redirect)that).file());
        }

        public int hashCode() {
            File file = this.file();
            if (file == null) {
                return super.hashCode();
            }
            return file.hashCode();
        }

        public String toString() {
            return (Object)((Object)this.type()) + " : " + this.file();
        }

        public static enum Type {
            PIPE,
            INHERIT,
            READ,
            WRITE,
            APPEND;

        }
    }
}

