/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.JTranscSystem;
import com.jtransc.JTranscSystemProperties;
import com.jtransc.JTranscVersion;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscMethodBodyList;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.annotation.haxe.HaxeMethodBodyList;
import com.jtransc.annotation.haxe.HaxeMethodBodyPre;
import com.jtransc.io.JTranscConsolePrintStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;

public class System {
    public static final InputStream in = new InputStream(){

        @Override
        public int read() throws IOException {
            throw new Error("Not implemented System.in.read()!");
        }
    };
    public static final PrintStream out = new JTranscConsolePrintStream(false);
    public static final PrintStream err = new JTranscConsolePrintStream(true);
    private static Properties _props;

    public static native void setIn(InputStream var0);

    public static native void setOut(PrintStream var0);

    public static native void setErr(PrintStream var0);

    @JTranscMethodBody(target="d", value={"return N.currentTimeMillis();"})
    public static long currentTimeMillis() {
        return (long)JTranscSystem.fastTime();
    }

    @JTranscMethodBody(target="d", value={"return N.nanoTime();"})
    public static long nanoTime() {
        return JTranscSystem.nanoTime();
    }

    @HaxeMethodBody(value="N.arraycopy(p0, p1, p2, p3, p4);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"N.arraycopy(p0, p1, p2, p3, p4);"}), @JTranscMethodBody(target="cpp", value={"JA_0::copy((JA_0*)p0.get(), p1, (JA_0*)p2.get(), p3, p4);"}), @JTranscMethodBody(target="d", value={"N.arraycopy(p0, p1, p2, p3, p4);"}), @JTranscMethodBody(target="cs", value={"N.arraycopy(p0, p1, p2, p3, p4);"})})
    public static void arraycopy(Object src, int srcPos, Object dest, int destPos, int length) {
        if (src instanceof boolean[]) {
            System.arraycopy((boolean[])src, srcPos, (boolean[])dest, destPos, length);
        } else if (src instanceof byte[]) {
            System.arraycopy((byte[])src, srcPos, (byte[])dest, destPos, length);
        } else if (src instanceof char[]) {
            System.arraycopy((char[])src, srcPos, (char[])dest, destPos, length);
        } else if (src instanceof short[]) {
            System.arraycopy((short[])src, srcPos, (short[])dest, destPos, length);
        } else if (src instanceof int[]) {
            System.arraycopy((int[])src, srcPos, (int[])dest, destPos, length);
        } else if (src instanceof long[]) {
            System.arraycopy((long[])src, srcPos, (long[])dest, destPos, length);
        } else if (src instanceof float[]) {
            System.arraycopy((float[])src, srcPos, (float[])dest, destPos, length);
        } else if (src instanceof double[]) {
            System.arraycopy((double[])src, srcPos, (double[])dest, destPos, length);
        } else {
            System.arraycopy((Object[])src, srcPos, (Object[])dest, destPos, length);
        }
    }

    private static void arraycopy(boolean[] src, int srcPos, boolean[] dest, int destPos, int length) {
        for (int n = 0; n < length; ++n) {
            dest[destPos + n] = src[srcPos + n];
        }
    }

    private static void arraycopy(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
        for (int n = 0; n < length; ++n) {
            dest[destPos + n] = src[srcPos + n];
        }
    }

    private static void arraycopy(char[] src, int srcPos, char[] dest, int destPos, int length) {
        for (int n = 0; n < length; ++n) {
            dest[destPos + n] = src[srcPos + n];
        }
    }

    private static void arraycopy(short[] src, int srcPos, short[] dest, int destPos, int length) {
        for (int n = 0; n < length; ++n) {
            dest[destPos + n] = src[srcPos + n];
        }
    }

    private static void arraycopy(int[] src, int srcPos, int[] dest, int destPos, int length) {
        for (int n = 0; n < length; ++n) {
            dest[destPos + n] = src[srcPos + n];
        }
    }

    private static void arraycopy(long[] src, int srcPos, long[] dest, int destPos, int length) {
        for (int n = 0; n < length; ++n) {
            dest[destPos + n] = src[srcPos + n];
        }
    }

    private static void arraycopy(float[] src, int srcPos, float[] dest, int destPos, int length) {
        for (int n = 0; n < length; ++n) {
            dest[destPos + n] = src[srcPos + n];
        }
    }

    private static void arraycopy(double[] src, int srcPos, double[] dest, int destPos, int length) {
        for (int n = 0; n < length; ++n) {
            dest[destPos + n] = src[srcPos + n];
        }
    }

    private static void arraycopy(Object[] src, int srcPos, Object[] dest, int destPos, int length) {
        for (int n = 0; n < length; ++n) {
            dest[destPos + n] = src[srcPos + n];
        }
    }

    public static int identityHashCode(Object x) {
        return SystemInt.identityHashCode(x);
    }

    public static Properties getProperties() {
        return System.getProps();
    }

    public static void setProperties(Properties props) {
        Properties myprops = System.getProps();
        for (Map.Entry entry : props.entrySet()) {
            myprops.put(entry.getKey(), entry.getValue());
        }
    }

    public static String getProperty(String prop) {
        return System.getProps().getProperty(prop);
    }

    public static String getProperty(String key, String def) {
        return System.getProps().getProperty(key, def);
    }

    private static void _setProperty(String key, String value) {
        System._setProperty(key, value, "");
    }

    private static void _setProperty(String key, String value, String defaultValue) {
        if (key == null) {
            key = "";
        }
        if (value == null) {
            value = defaultValue;
        }
        System.getProps().put(key, value);
    }

    private static Properties getProps() {
        if (_props == null) {
            _props = new Properties();
            System._setProperty("os.arch", JTranscSystem.getArch(), "unknown");
            System._setProperty("os.name", JTranscSystem.getOS(), "unknown");
            System._setProperty("os.version", "0.1");
            System._setProperty("java.runtime.name", JTranscSystem.getRuntimeName(), "jtransc-unknown");
            System._setProperty("java.version", "1.8.0_51");
            System._setProperty("java.vm.version", "25.51-b03");
            System._setProperty("java.runtime.version", "1.8.0_51-b16");
            System._setProperty("file.separator", JTranscSystem.fileSeparator(), "/");
            System._setProperty("line.separator", JTranscSystem.lineSeparator(), "\n");
            System._setProperty("path.separator", JTranscSystem.pathSeparator(), ":");
            System._setProperty("file.encoding", JTranscSystemProperties.fileEncoding());
            System._setProperty("java.home", JTranscSystem.getJavaHome(), "/");
            System._setProperty("java.specification.name", JTranscSystem.getRuntimeName(), "jtransc-unknown");
            System._setProperty("java.specification.vendor", "jtransc");
            System._setProperty("java.specification.version", "1.7");
            System._setProperty("java.vendor", "jtransc");
            System._setProperty("java.vendor.url", "http://github.com/jtransc/jtransc");
            System._setProperty("java.vm.name", "haxe");
            System._setProperty("java.vm.specification.name", "Jtransc JVM emulator");
            System._setProperty("java.vm.specification.vendor", "jtransc");
            System._setProperty("java.vm.specification.version", JTranscVersion.getVersion());
            System._setProperty("java.io.tmpdir", JTranscSystemProperties.tmpdir());
            System._setProperty("user.home", JTranscSystemProperties.userHome());
            System._setProperty("user.dir", JTranscSystemProperties.userDir());
            System._setProperty("user.name", JTranscSystemProperties.userName());
            System._setProperty("user.language", JTranscSystemProperties.userLanguage());
            System._setProperty("user.region", JTranscSystemProperties.userRegion());
            System._setProperty("user.variant", JTranscSystemProperties.userVariant());
        }
        return _props;
    }

    public static String setProperty(String key, String value) {
        return (String)System.getProps().setProperty(key, value);
    }

    public static String clearProperty(String key) {
        String old = System.getProperty(key);
        System.getProps().remove(key);
        return old;
    }

    @HaxeMethodBodyPre(value="var key = p0._str;")
    @HaxeMethodBodyList(value={@HaxeMethodBody(target="sys", value="return N.str(Sys.getEnv(key));"), @HaxeMethodBody(target="js", value="return N.str(untyped __js__(\"(typeof process != 'undefined') ? process.env[key] : null\"));"), @HaxeMethodBody(value="return N.str(null);")})
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return N.str((typeof process != 'undefined') ? process.env[p0] : null);"}), @JTranscMethodBody(target="cpp", value={"auto str = N::istr3(p0);", "return N::str(std::getenv(str.c_str()));"}), @JTranscMethodBody(target="d", value={"return N.str(std.process.environment.get(N.istr2(p0)));"}), @JTranscMethodBody(target="cs", value={"return N.str(Environment.GetEnvironmentVariable(N.istr(p0)));"})})
    public static native String getenv(String var0);

    @HaxeMethodBodyList(value={@HaxeMethodBody(target="sys", value="return N.hashMap(Sys.environment());"), @HaxeMethodBody(target="js", value="return N.hashMap(untyped __js__(\"(typeof process != 'undefined') ? process.env : {}\"));"), @HaxeMethodBody(value="return N.hashMap({});")})
    public static native Map<String, String> getenv();

    @HaxeMethodBodyList(value={@HaxeMethodBody(target="sys", value="Sys.exit(p0);"), @HaxeMethodBody(target="js", value="untyped __js__(\"if (typeof process != 'undefined') process.exit(p0);\");"), @HaxeMethodBody(value="throw 'EXIT!';")})
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"process.exit(p0);"}), @JTranscMethodBody(target="cpp", value={"::exit(p0);"}), @JTranscMethodBody(target="d", value={"core.stdc.stdlib.exit(p0);"})})
    public static native void exit(int var0);

    public static void gc() {
    }

    public static void runFinalization() {
    }

    @Deprecated
    public static void runFinalizersOnExit(boolean value) {
    }

    public static void load(String filename) {
    }

    public static void loadLibrary(String libname) {
    }

    public static String mapLibraryName(String libname) {
        return libname;
    }

    public static SecurityManager getSecurityManager() {
        return null;
    }

    public static String lineSeparator() {
        return JTranscSystem.lineSeparator();
    }
}

