/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.jtransc.crypto.org.bouncycastle.GeneralDigest;
import com.jtransc.crypto.org.bouncycastle.GeneralDigestAdaptor;
import com.jtransc.crypto.org.bouncycastle.MD5Digest;
import com.jtransc.crypto.org.bouncycastle.SHA1Digest;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Arrays;

public abstract class MessageDigest
extends MessageDigestSpi {
    private final String algorithm;
    private byte[] tempBuffer = new byte[1];

    protected MessageDigest(String algorithm) {
        this.algorithm = algorithm;
    }

    public static MessageDigest getInstance(String algorithm) throws NoSuchAlgorithmException {
        if ("MD5".equalsIgnoreCase(algorithm)) {
            return new GeneralDigestAdaptor((GeneralDigest)new MD5Digest());
        }
        if ("SHA1".equalsIgnoreCase(algorithm)) {
            return new GeneralDigestAdaptor((GeneralDigest)new SHA1Digest());
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static MessageDigest getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return MessageDigest.getInstance(algorithm);
    }

    public static MessageDigest getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(algorithm);
    }

    public final native Provider getProvider();

    public void update(byte input) {
        this.tempBuffer[0] = input;
        this.update(this.tempBuffer, 0, 1);
    }

    public void update(byte[] input, int offset, int len) {
        this.engineUpdate(input, offset, len);
    }

    public void update(byte[] input) {
        this.update(input, 0, input.length);
    }

    public final void update(ByteBuffer input) {
        this.engineUpdate(input);
    }

    public byte[] digest() {
        return this.engineDigest();
    }

    public int digest(byte[] buf, int offset, int len) throws DigestException {
        return this.engineDigest(buf, offset, len);
    }

    public byte[] digest(byte[] input) {
        this.engineUpdate(input, 0, input.length);
        return this.engineDigest();
    }

    public String toString() {
        return this.algorithm;
    }

    public static boolean isEqual(byte[] digesta, byte[] digestb) {
        return Arrays.equals(digesta, digestb);
    }

    public void reset() {
        this.engineReset();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getDigestLength() {
        return this.engineGetDigestLength();
    }

    @Override
    public native Object clone() throws CloneNotSupportedException;
}

