/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class Vector<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    protected int elementCount;
    protected Object[] elementData;
    protected int capacityIncrement;
    private static final int DEFAULT_SIZE = 10;

    public Vector() {
        this(10, 0);
    }

    public Vector(int capacity) {
        this(capacity, 0);
    }

    public Vector(int capacity, int capacityIncrement) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity < 0: " + capacity);
        }
        this.elementData = this.newElementArray(capacity);
        this.elementCount = 0;
        this.capacityIncrement = capacityIncrement;
    }

    public Vector(Collection<? extends E> collection) {
        this(collection.size(), 0);
        Iterator<E> it = collection.iterator();
        while (it.hasNext()) {
            this.elementData[this.elementCount++] = it.next();
        }
    }

    private E[] newElementArray(int size) {
        return new Object[size];
    }

    @Override
    public void add(int location, E object) {
        this.insertElementAt(object, location);
    }

    @Override
    public synchronized boolean add(E object) {
        if (this.elementCount == this.elementData.length) {
            this.growByOne();
        }
        this.elementData[this.elementCount++] = object;
        ++this.modCount;
        return true;
    }

    @Override
    public synchronized boolean addAll(int location, Collection<? extends E> collection) {
        if (location >= 0 && location <= this.elementCount) {
            int count;
            int size = collection.size();
            if (size == 0) {
                return false;
            }
            int required = size - (this.elementData.length - this.elementCount);
            if (required > 0) {
                this.growBy(required);
            }
            if ((count = this.elementCount - location) > 0) {
                System.arraycopy((Object)this.elementData, location, (Object)this.elementData, location + size, count);
            }
            Iterator<E> it = collection.iterator();
            while (it.hasNext()) {
                this.elementData[location++] = it.next();
            }
            this.elementCount += size;
            ++this.modCount;
            return true;
        }
        throw Vector.arrayIndexOutOfBoundsException(location, this.elementCount);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> collection) {
        return this.addAll(this.elementCount, collection);
    }

    public synchronized void addElement(E object) {
        if (this.elementCount == this.elementData.length) {
            this.growByOne();
        }
        this.elementData[this.elementCount++] = object;
        ++this.modCount;
    }

    public synchronized int capacity() {
        return this.elementData.length;
    }

    @Override
    public void clear() {
        this.removeAllElements();
    }

    public synchronized Object clone() {
        try {
            Vector vector = (Vector)super.clone();
            vector.elementData = (Object[])this.elementData.clone();
            return vector;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object, 0) != -1;
    }

    @Override
    public synchronized boolean containsAll(Collection<?> collection) {
        return super.containsAll(collection);
    }

    public synchronized void copyInto(Object[] elements) {
        System.arraycopy((Object)this.elementData, 0, (Object)elements, 0, this.elementCount);
    }

    public synchronized E elementAt(int location) {
        if (location < this.elementCount) {
            return (E)this.elementData[location];
        }
        throw Vector.arrayIndexOutOfBoundsException(location, this.elementCount);
    }

    public Enumeration<E> elements() {
        return new Enumeration<E>(){
            int pos = 0;

            @Override
            public boolean hasMoreElements() {
                return this.pos < Vector.this.elementCount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public E nextElement() {
                Vector vector = Vector.this;
                synchronized (vector) {
                    if (this.pos < Vector.this.elementCount) {
                        return Vector.this.elementData[this.pos++];
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }

    public synchronized void ensureCapacity(int minimumCapacity) {
        if (this.elementData.length < minimumCapacity) {
            int next = (this.capacityIncrement <= 0 ? this.elementData.length : this.capacityIncrement) + this.elementData.length;
            this.grow(minimumCapacity > next ? minimumCapacity : next);
        }
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() != this.elementCount) {
                return false;
            }
            int index = 0;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Object e1 = this.elementData[index++];
                Object e2 = it.next();
                if (e1 != null ? e1.equals(e2) : e2 == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public synchronized E firstElement() {
        if (this.elementCount > 0) {
            return (E)this.elementData[0];
        }
        throw new NoSuchElementException();
    }

    @Override
    public E get(int location) {
        return this.elementAt(location);
    }

    private void grow(int newCapacity) {
        E[] newData = this.newElementArray(newCapacity);
        System.arraycopy((Object)this.elementData, 0, newData, 0, this.elementCount);
        this.elementData = newData;
    }

    private void growByOne() {
        int adding = 0;
        if (this.capacityIncrement <= 0) {
            adding = this.elementData.length;
            if (adding == 0) {
                adding = 1;
            }
        } else {
            adding = this.capacityIncrement;
        }
        E[] newData = this.newElementArray(this.elementData.length + adding);
        System.arraycopy((Object)this.elementData, 0, newData, 0, this.elementCount);
        this.elementData = newData;
    }

    private void growBy(int required) {
        int adding = 0;
        if (this.capacityIncrement <= 0) {
            adding = this.elementData.length;
            if (adding == 0) {
                adding = required;
            }
            while (adding < required) {
                adding += adding;
            }
        } else {
            adding = required / this.capacityIncrement * this.capacityIncrement;
            if (adding < required) {
                adding += this.capacityIncrement;
            }
        }
        E[] newData = this.newElementArray(this.elementData.length + adding);
        System.arraycopy((Object)this.elementData, 0, newData, 0, this.elementCount);
        this.elementData = newData;
    }

    @Override
    public synchronized int hashCode() {
        int result = 1;
        for (int i = 0; i < this.elementCount; ++i) {
            result = 31 * result + (this.elementData[i] == null ? 0 : this.elementData[i].hashCode());
        }
        return result;
    }

    @Override
    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public synchronized int indexOf(Object object, int location) {
        if (object != null) {
            for (int i = location; i < this.elementCount; ++i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        } else {
            for (int i = location; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized void insertElementAt(E object, int location) {
        if (location >= 0 && location <= this.elementCount) {
            int count;
            if (this.elementCount == this.elementData.length) {
                this.growByOne();
            }
            if ((count = this.elementCount - location) > 0) {
                System.arraycopy((Object)this.elementData, location, (Object)this.elementData, location + 1, count);
            }
            this.elementData[location] = object;
            ++this.elementCount;
            ++this.modCount;
        } else {
            throw Vector.arrayIndexOutOfBoundsException(location, this.elementCount);
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    public synchronized E lastElement() {
        try {
            return (E)this.elementData[this.elementCount - 1];
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public synchronized int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public synchronized int lastIndexOf(Object object, int location) {
        if (location < this.elementCount) {
            if (object != null) {
                for (int i = location; i >= 0; --i) {
                    if (!object.equals(this.elementData[i])) continue;
                    return i;
                }
            } else {
                for (int i = location; i >= 0; --i) {
                    if (this.elementData[i] != null) continue;
                    return i;
                }
            }
            return -1;
        }
        throw Vector.arrayIndexOutOfBoundsException(location, this.elementCount);
    }

    @Override
    public synchronized E remove(int location) {
        if (location < this.elementCount) {
            Object result = this.elementData[location];
            --this.elementCount;
            int size = this.elementCount - location;
            if (size > 0) {
                System.arraycopy((Object)this.elementData, location + 1, (Object)this.elementData, location, size);
            }
            this.elementData[this.elementCount] = null;
            ++this.modCount;
            return (E)result;
        }
        throw Vector.arrayIndexOutOfBoundsException(location, this.elementCount);
    }

    @Override
    public boolean remove(Object object) {
        return this.removeElement(object);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        return super.removeAll(collection);
    }

    public synchronized void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        ++this.modCount;
        this.elementCount = 0;
    }

    public synchronized boolean removeElement(Object object) {
        int index = this.indexOf(object, 0);
        if (index == -1) {
            return false;
        }
        this.removeElementAt(index);
        return true;
    }

    public synchronized void removeElementAt(int location) {
        if (location >= 0 && location < this.elementCount) {
            --this.elementCount;
            int size = this.elementCount - location;
            if (size > 0) {
                System.arraycopy((Object)this.elementData, location + 1, (Object)this.elementData, location, size);
            }
            this.elementData[this.elementCount] = null;
            ++this.modCount;
        } else {
            throw Vector.arrayIndexOutOfBoundsException(location, this.elementCount);
        }
    }

    @Override
    protected void removeRange(int start, int end) {
        if (start >= 0 && start <= end && end <= this.elementCount) {
            if (start == end) {
                return;
            }
            if (end != this.elementCount) {
                System.arraycopy((Object)this.elementData, end, (Object)this.elementData, start, this.elementCount - end);
                int newCount = this.elementCount - (end - start);
                Arrays.fill(this.elementData, newCount, this.elementCount, null);
                this.elementCount = newCount;
            } else {
                Arrays.fill(this.elementData, start, this.elementCount, null);
                this.elementCount = start;
            }
            ++this.modCount;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public synchronized boolean retainAll(Collection<?> collection) {
        return super.retainAll(collection);
    }

    @Override
    public synchronized E set(int location, E object) {
        if (location < this.elementCount) {
            Object result = this.elementData[location];
            this.elementData[location] = object;
            return (E)result;
        }
        throw Vector.arrayIndexOutOfBoundsException(location, this.elementCount);
    }

    public synchronized void setElementAt(E object, int location) {
        if (location >= this.elementCount) {
            throw Vector.arrayIndexOutOfBoundsException(location, this.elementCount);
        }
        this.elementData[location] = object;
    }

    private static ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException(int index, int size) {
        throw new ArrayIndexOutOfBoundsException();
    }

    public synchronized void setSize(int length) {
        if (length == this.elementCount) {
            return;
        }
        this.ensureCapacity(length);
        if (this.elementCount > length) {
            Arrays.fill(this.elementData, length, this.elementCount, null);
        }
        this.elementCount = length;
        ++this.modCount;
    }

    @Override
    public synchronized int size() {
        return this.elementCount;
    }

    @Override
    public synchronized List<E> subList(int start, int end) {
        return new Collections.SynchronizedRandomAccessList(super.subList(start, end), (Object)this);
    }

    @Override
    public synchronized Object[] toArray() {
        Object[] result = new Object[this.elementCount];
        System.arraycopy((Object)this.elementData, 0, (Object)result, 0, this.elementCount);
        return result;
    }

    @Override
    public synchronized <T> T[] toArray(T[] contents) {
        if (this.elementCount > contents.length) {
            Class<?> ct = contents.getClass().getComponentType();
            contents = (Object[])Array.newInstance(ct, this.elementCount);
        }
        System.arraycopy((Object)this.elementData, 0, contents, 0, this.elementCount);
        if (this.elementCount < contents.length) {
            contents[this.elementCount] = null;
        }
        return contents;
    }

    @Override
    public synchronized String toString() {
        if (this.elementCount == 0) {
            return "[]";
        }
        int length = this.elementCount - 1;
        StringBuilder buffer = new StringBuilder(this.elementCount * 16);
        buffer.append('[');
        for (int i = 0; i < length; ++i) {
            if (this.elementData[i] == this) {
                buffer.append("(this Collection)");
            } else {
                buffer.append(this.elementData[i]);
            }
            buffer.append(", ");
        }
        if (this.elementData[length] == this) {
            buffer.append("(this Collection)");
        } else {
            buffer.append(this.elementData[length]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public synchronized void trimToSize() {
        if (this.elementData.length != this.elementCount) {
            this.grow(this.elementCount);
        }
    }

    private synchronized void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }
}

