/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.charset.charsets;

import com.jtransc.JTranscBits;
import com.jtransc.charset.JTranscCharset;
import java.io.ByteArrayOutputStream;

abstract class JTranscCharsetUTF16Base
extends JTranscCharset {
    private String[] aliases;
    private boolean littleEndian;

    public JTranscCharsetUTF16Base(String[] names, boolean littleEndian) {
        super(names, 2, 2.0f, 2);
        this.littleEndian = littleEndian;
    }

    public void encode(char[] in, int offset, int len, ByteArrayOutputStream out) {
        for (int n = 0; n < len; ++n) {
            char c = in[offset + n];
            if (this.littleEndian) {
                out.write(c >>> 0 & 0xFF);
                out.write(c >>> 8 & 0xFF);
                continue;
            }
            out.write(c >>> 8 & 0xFF);
            out.write(c >>> 0 & 0xFF);
        }
    }

    public void decode(byte[] in, int offset, int len, StringBuilder out) {
        for (int n = 0; n < len; n += 2) {
            out.append((char)JTranscBits.readInt16((byte[])in, (int)(offset + n), (boolean)this.littleEndian));
        }
    }
}

