/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.jtransc.JTranscArrays;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PipedWriter;
import java.io.Reader;

public class PipedReader
extends Reader {
    private Thread lastReader;
    private Thread lastWriter;
    private boolean isClosed;
    private char[] buffer;
    private int in = -1;
    private int out;
    private static final int PIPE_SIZE = 1024;
    boolean isConnected;

    public PipedReader() {
    }

    public PipedReader(PipedWriter out) throws IOException {
        this.connect(out);
    }

    public PipedReader(int pipeSize) {
        if (pipeSize <= 0) {
            throw new IllegalArgumentException("pipe size " + pipeSize + " too small");
        }
        this.buffer = new char[pipeSize];
    }

    public PipedReader(PipedWriter out, int pipeSize) throws IOException {
        this(pipeSize);
        this.connect(out);
    }

    @Override
    public synchronized void close() throws IOException {
        this.buffer = null;
        this.isClosed = true;
        this.notifyAll();
    }

    public void connect(PipedWriter src) throws IOException {
        src.connect(this);
    }

    synchronized void establishConnection() throws IOException {
        if (this.isConnected) {
            throw new IOException("Pipe already connected");
        }
        if (this.isClosed) {
            throw new IOException("Pipe is closed");
        }
        if (this.buffer == null) {
            this.buffer = new char[1024];
        }
        this.isConnected = true;
    }

    @Override
    public int read() throws IOException {
        char[] chars = new char[1];
        int result = this.read(chars, 0, 1);
        return result != -1 ? chars[0] : result;
    }

    @Override
    public synchronized int read(char[] buffer, int offset, int count) throws IOException {
        if (!this.isConnected) {
            throw new IOException("Pipe not connected");
        }
        if (this.buffer == null) {
            throw new IOException("Pipe is closed");
        }
        JTranscArrays.checkOffsetAndCount((int)buffer.length, (int)offset, (int)count);
        if (count == 0) {
            return 0;
        }
        this.lastReader = Thread.currentThread();
        try {
            boolean first = true;
            while (this.in == -1) {
                if (this.isClosed) {
                    return -1;
                }
                if (!first && this.lastWriter != null && !this.lastWriter.isAlive()) {
                    throw new IOException("Pipe broken");
                }
                first = false;
                this.notifyAll();
                this.wait(1000L);
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        int copyLength = 0;
        if (this.out >= this.in) {
            copyLength = count > this.buffer.length - this.out ? this.buffer.length - this.out : count;
            System.arraycopy((Object)this.buffer, this.out, (Object)buffer, offset, copyLength);
            this.out += copyLength;
            if (this.out == this.buffer.length) {
                this.out = 0;
            }
            if (this.out == this.in) {
                this.in = -1;
                this.out = 0;
            }
        }
        if (copyLength == count || this.in == -1) {
            return copyLength;
        }
        int charsCopied = copyLength;
        copyLength = this.in - this.out > count - copyLength ? count - copyLength : this.in - this.out;
        System.arraycopy((Object)this.buffer, this.out, (Object)buffer, offset + charsCopied, copyLength);
        this.out += copyLength;
        if (this.out == this.in) {
            this.in = -1;
            this.out = 0;
        }
        return charsCopied + copyLength;
    }

    @Override
    public synchronized boolean ready() throws IOException {
        if (!this.isConnected) {
            throw new IOException("Pipe not connected");
        }
        if (this.buffer == null) {
            throw new IOException("Pipe is closed");
        }
        return this.in != -1;
    }

    synchronized void receive(char oneChar) throws IOException {
        if (this.buffer == null) {
            throw new IOException("Pipe is closed");
        }
        if (this.lastReader != null && !this.lastReader.isAlive()) {
            throw new IOException("Pipe broken");
        }
        this.lastWriter = Thread.currentThread();
        try {
            while (this.buffer != null && this.out == this.in) {
                this.notifyAll();
                this.wait(1000L);
                if (this.lastReader == null || this.lastReader.isAlive()) continue;
                throw new IOException("Pipe broken");
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        if (this.buffer == null) {
            throw new IOException("Pipe is closed");
        }
        if (this.in == -1) {
            this.in = 0;
        }
        this.buffer[this.in++] = oneChar;
        if (this.in == this.buffer.length) {
            this.in = 0;
        }
    }

    synchronized void receive(char[] chars, int offset, int count) throws IOException {
        JTranscArrays.checkOffsetAndCount((int)chars.length, (int)offset, (int)count);
        if (this.buffer == null) {
            throw new IOException("Pipe is closed");
        }
        if (this.lastReader != null && !this.lastReader.isAlive()) {
            throw new IOException("Pipe broken");
        }
        this.lastWriter = Thread.currentThread();
        while (count > 0) {
            int length;
            try {
                while (this.buffer != null && this.out == this.in) {
                    this.notifyAll();
                    this.wait(1000L);
                    if (this.lastReader == null || this.lastReader.isAlive()) continue;
                    throw new IOException("Pipe broken");
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            if (this.buffer == null) {
                throw new IOException("Pipe is closed");
            }
            if (this.in == -1) {
                this.in = 0;
            }
            if (this.in >= this.out) {
                length = this.buffer.length - this.in;
                if (count < length) {
                    length = count;
                }
                System.arraycopy((Object)chars, offset, (Object)this.buffer, this.in, length);
                offset += length;
                count -= length;
                this.in += length;
                if (this.in == this.buffer.length) {
                    this.in = 0;
                }
            }
            if (count <= 0 || this.in == this.out) continue;
            length = this.out - this.in;
            if (count < length) {
                length = count;
            }
            System.arraycopy((Object)chars, offset, (Object)this.buffer, this.in, length);
            offset += length;
            count -= length;
            this.in += length;
        }
    }

    synchronized void done() {
        this.isClosed = true;
        this.notifyAll();
    }
}

