/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.jtransc.JTranscArrays;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBufferAsCharBuffer;
import java.nio.ByteBufferAsDoubleBuffer;
import java.nio.ByteBufferAsFloatBuffer;
import java.nio.ByteBufferAsIntBuffer;
import java.nio.ByteBufferAsLongBuffer;
import java.nio.ByteBufferAsShortBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import libcore.io.Memory;

public final class ByteBuffer
extends Buffer
implements Comparable<ByteBuffer> {
    ByteOrder order;
    boolean isNativeOrder;
    public final byte[] backingArray;
    final int arrayOffset;
    private final boolean isReadOnly;
    private boolean isDirect;

    ByteBuffer(byte[] backingArray) {
        this(backingArray.length, backingArray, 0, false);
        this.isDirect = false;
    }

    ByteBuffer(byte[] backingArray, boolean isDirect) {
        this(backingArray.length, backingArray, 0, false);
        this.isDirect = isDirect;
    }

    private ByteBuffer(int capacity, byte[] backingArray, int arrayOffset, boolean isReadOnly) {
        super(0, capacity, null);
        this.backingArray = backingArray;
        this.arrayOffset = arrayOffset;
        this.isReadOnly = isReadOnly;
        this.order(ByteOrder.BIG_ENDIAN);
        if (arrayOffset + capacity > backingArray.length) {
            throw new IndexOutOfBoundsException("backingArray.length=" + backingArray.length + ", capacity=" + capacity + ", arrayOffset=" + arrayOffset);
        }
    }

    public static ByteBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity < 0: " + capacity);
        }
        return new ByteBuffer(new byte[capacity]);
    }

    public static ByteBuffer allocateDirect(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity < 0: " + capacity);
        }
        return new ByteBuffer(new byte[capacity], true);
    }

    public static ByteBuffer wrap(byte[] array) {
        return new ByteBuffer(array);
    }

    public static ByteBuffer wrap(byte[] array, int start, int byteCount) {
        JTranscArrays.checkOffsetAndCount((int)array.length, (int)start, (int)byteCount);
        ByteBuffer buf = new ByteBuffer(array);
        buf.position = start;
        buf.limit = start + byteCount;
        return buf;
    }

    public final byte[] array() {
        this._checkWritable();
        return this.backingArray;
    }

    @Override
    public final int arrayOffset() {
        return this.protectedArrayOffset();
    }

    public final CharBuffer asCharBuffer() {
        return ByteBufferAsCharBuffer.asCharBuffer(this);
    }

    public final DoubleBuffer asDoubleBuffer() {
        return ByteBufferAsDoubleBuffer.asDoubleBuffer(this);
    }

    public final FloatBuffer asFloatBuffer() {
        return ByteBufferAsFloatBuffer.asFloatBuffer(this);
    }

    public final IntBuffer asIntBuffer() {
        return ByteBufferAsIntBuffer.asIntBuffer(this);
    }

    public final LongBuffer asLongBuffer() {
        return ByteBufferAsLongBuffer.asLongBuffer(this);
    }

    public final ShortBuffer asShortBuffer() {
        return ByteBufferAsShortBuffer.asShortBuffer(this);
    }

    @Override
    public int compareTo(ByteBuffer otherBuffer) {
        int thisPos = this.position;
        int otherPos = otherBuffer.position;
        for (int compareRemaining = this.remaining() < otherBuffer.remaining() ? this.remaining() : otherBuffer.remaining(); compareRemaining > 0; --compareRemaining) {
            byte otherByte;
            byte thisByte = this.get(thisPos);
            if (thisByte != (otherByte = otherBuffer.get(otherPos))) {
                return thisByte < otherByte ? -1 : 1;
            }
            ++thisPos;
            ++otherPos;
        }
        return this.remaining() - otherBuffer.remaining();
    }

    public ByteBuffer duplicate() {
        return ByteBuffer.copy(this, this.mark, this.isReadOnly);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer otherBuffer = (ByteBuffer)other;
        if (this.remaining() != otherBuffer.remaining()) {
            return false;
        }
        int myPosition = this.position;
        int otherPosition = otherBuffer.position;
        boolean equalSoFar = true;
        while (equalSoFar && myPosition < this.limit) {
            equalSoFar = this.get(myPosition++) == otherBuffer.get(otherPosition++);
        }
        return equalSoFar;
    }

    public ByteBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    @Override
    public final boolean hasArray() {
        return this.protectedHasArray();
    }

    public int hashCode() {
        int myPosition = this.position;
        int hash = 0;
        while (myPosition < this.limit) {
            hash += this.get(myPosition++);
        }
        return hash;
    }

    @Override
    public final boolean isDirect() {
        return this.isDirect;
    }

    public final ByteOrder order() {
        return this.order;
    }

    public final ByteBuffer order(ByteOrder byteOrder) {
        if (byteOrder == null) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        }
        this.order = byteOrder;
        this.isNativeOrder = byteOrder == ByteOrder.nativeOrder();
        return this;
    }

    public final ByteBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    public ByteBuffer put(ByteBuffer src) {
        this._checkWritable();
        if (src == this) {
            throw new IllegalArgumentException("src == this");
        }
        int srcByteCount = src.remaining();
        if (srcByteCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        while (src.hasRemaining()) {
            this.put(src.get());
        }
        return this;
    }

    public ByteBuffer putChar(int index, char value) {
        this._checkWritable();
        this.checkIndex(index, 2);
        Memory.pokeShort(this.backingArray, this.arrayOffset + index, (short)value, this.order);
        return this;
    }

    public ByteBuffer putChar(char value) {
        this._checkWritable();
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        Memory.pokeShort(this.backingArray, this.arrayOffset + this.position, (short)value, this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer putDouble(double value) {
        return this.putLong(Double.doubleToRawLongBits(value));
    }

    public ByteBuffer putDouble(int index, double value) {
        return this.putLong(index, Double.doubleToRawLongBits(value));
    }

    public ByteBuffer putFloat(float value) {
        return this.putInt(Float.floatToRawIntBits(value));
    }

    public ByteBuffer putFloat(int index, float value) {
        return this.putInt(index, Float.floatToRawIntBits(value));
    }

    public ByteBuffer putInt(int value) {
        this._checkWritable();
        int newPosition = this.position + 4;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        Memory.pokeInt(this.backingArray, this.arrayOffset + this.position, value, this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer putInt(int index, int value) {
        this._checkWritable();
        this.checkIndex(index, 4);
        Memory.pokeInt(this.backingArray, this.arrayOffset + index, value, this.order);
        return this;
    }

    public ByteBuffer putLong(int index, long value) {
        this._checkWritable();
        this.checkIndex(index, 8);
        Memory.pokeLong(this.backingArray, this.arrayOffset + index, value, this.order);
        return this;
    }

    public ByteBuffer putLong(long value) {
        this._checkWritable();
        int newPosition = this.position + 8;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        Memory.pokeLong(this.backingArray, this.arrayOffset + this.position, value, this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer putShort(int index, short value) {
        this._checkWritable();
        this.checkIndex(index, 2);
        Memory.pokeShort(this.backingArray, this.arrayOffset + index, value, this.order);
        return this;
    }

    public ByteBuffer putShort(short value) {
        this._checkWritable();
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        Memory.pokeShort(this.backingArray, this.arrayOffset + this.position, value, this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer slice() {
        return new ByteBuffer(this.remaining(), this.backingArray, this.arrayOffset + this.position, this.isReadOnly);
    }

    private static ByteBuffer copy(ByteBuffer other, int markOfOther, boolean isReadOnly) {
        ByteBuffer buf = new ByteBuffer(other.capacity(), other.backingArray, other.arrayOffset, isReadOnly);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    public ByteBuffer asReadOnlyBuffer() {
        return ByteBuffer.copy(this, this.mark, true);
    }

    public ByteBuffer compact() {
        this._checkWritable();
        System.arraycopy((Object)this.backingArray, this.position + this.arrayOffset, (Object)this.backingArray, this.arrayOffset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    private void _checkWritable() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
    }

    byte[] protectedArray() {
        this._checkWritable();
        return this.backingArray;
    }

    int protectedArrayOffset() {
        this._checkWritable();
        return this.arrayOffset;
    }

    boolean protectedHasArray() {
        return !this.isReadOnly;
    }

    public final ByteBuffer get(byte[] dst, int dstOffset, int byteCount) {
        this.checkGetBounds(1, dst.length, dstOffset, byteCount);
        System.arraycopy((Object)this.backingArray, this.arrayOffset + this.position, (Object)dst, dstOffset, byteCount);
        this.position += byteCount;
        return this;
    }

    final void get(char[] dst, int dstOffset, int charCount) {
        int byteCount = this.checkGetBounds(2, dst.length, dstOffset, charCount);
        this.position += byteCount;
        throw new RuntimeException("Not implemented");
    }

    final void get(double[] dst, int dstOffset, int doubleCount) {
        int byteCount = this.checkGetBounds(8, dst.length, dstOffset, doubleCount);
        this.position += byteCount;
        throw new RuntimeException("Not implemented");
    }

    final void get(float[] dst, int dstOffset, int floatCount) {
        int byteCount = this.checkGetBounds(4, dst.length, dstOffset, floatCount);
        this.position += byteCount;
        throw new RuntimeException("Not implemented");
    }

    final void get(int[] dst, int dstOffset, int intCount) {
        int byteCount = this.checkGetBounds(4, dst.length, dstOffset, intCount);
        this.position += byteCount;
        throw new RuntimeException("Not implemented");
    }

    final void get(long[] dst, int dstOffset, int longCount) {
        int byteCount = this.checkGetBounds(8, dst.length, dstOffset, longCount);
        this.position += byteCount;
        throw new RuntimeException("Not implemented");
    }

    final void get(short[] dst, int dstOffset, int shortCount) {
        int byteCount = this.checkGetBounds(2, dst.length, dstOffset, shortCount);
        this.position += byteCount;
        throw new RuntimeException("Not implemented");
    }

    public final byte get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backingArray[this.arrayOffset + this.position++];
    }

    public final byte get(int index) {
        this.checkIndex(index);
        return this.backingArray[this.arrayOffset + index];
    }

    public final char getChar() {
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        char result = (char)Memory.peekShort(this.backingArray, this.arrayOffset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    public final char getChar(int index) {
        this.checkIndex(index, 2);
        return (char)Memory.peekShort(this.backingArray, this.arrayOffset + index, this.order);
    }

    public final double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    public final double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    public final float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    public final float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    public final int getInt() {
        int newPosition = this.position + 4;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        int result = Memory.peekInt(this.backingArray, this.arrayOffset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    public final int getInt(int index) {
        this.checkIndex(index, 4);
        return Memory.peekInt(this.backingArray, this.arrayOffset + index, this.order);
    }

    public final long getLong() {
        int newPosition = this.position + 8;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        long result = Memory.peekLong(this.backingArray, this.arrayOffset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    public final long getLong(int index) {
        this.checkIndex(index, 8);
        return Memory.peekLong(this.backingArray, this.arrayOffset + index, this.order);
    }

    public final short getShort() {
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        short result = Memory.peekShort(this.backingArray, this.arrayOffset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    public final short getShort(int index) {
        this.checkIndex(index, 2);
        return Memory.peekShort(this.backingArray, this.arrayOffset + index, this.order);
    }

    public ByteBuffer put(byte b) {
        this._checkWritable();
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.arrayOffset + this.position++] = b;
        return this;
    }

    public ByteBuffer put(int index, byte b) {
        this._checkWritable();
        this.checkIndex(index);
        this.backingArray[this.arrayOffset + index] = b;
        return this;
    }

    public ByteBuffer put(byte[] src, int srcOffset, int byteCount) {
        this._checkWritable();
        this.checkPutBounds(1, src.length, srcOffset, byteCount);
        System.arraycopy((Object)src, srcOffset, (Object)this.backingArray, this.arrayOffset + this.position, byteCount);
        this.position += byteCount;
        return this;
    }
}

