/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.jtransc.JTranscSystem;
import com.jtransc.internal.JTranscCType;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;

public class Formatter
implements Closeable,
Flushable {
    Appendable out;
    IOException ioException;

    public Formatter() {
        this.out = new StringBuilder();
    }

    public Formatter(Appendable a) {
        this.out = a;
    }

    public Formatter(Locale l) {
        this.out = new StringBuilder();
    }

    public Formatter(Appendable a, Locale l) {
        this.out = a;
    }

    public Formatter(String fileName) throws FileNotFoundException {
        this(new File(fileName));
    }

    public Formatter(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(new File(fileName), csn);
    }

    public Formatter(String fileName, String csn, Locale l) throws FileNotFoundException, UnsupportedEncodingException {
        this(new File(fileName), csn, l);
    }

    public Formatter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public Formatter(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), csn));
    }

    public Formatter(File file, String csn, Locale l) throws FileNotFoundException, UnsupportedEncodingException {
        this(file, csn);
    }

    public Formatter(OutputStream os) {
        this.out = new BufferedWriter(new OutputStreamWriter(os, Charset.defaultCharset()));
    }

    public Formatter(OutputStream os, String csn) throws UnsupportedEncodingException {
        this(os, csn, Locale.getDefault());
    }

    public Formatter(OutputStream os, String csn, Locale l) throws UnsupportedEncodingException {
        this.out = new BufferedWriter(new OutputStreamWriter(os, csn));
    }

    public Formatter(PrintStream ps) {
        this.out = ps;
    }

    @Override
    public void close() {
        if (this.out instanceof Closeable) {
            try {
                ((Closeable)((Object)this.out)).close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void flush() {
        if (this.out instanceof Flushable) {
            try {
                ((Flushable)((Object)this.out)).flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public Locale locale() {
        return Locale.getDefault();
    }

    public Appendable out() {
        return this.out;
    }

    public IOException ioException() {
        return this.ioException;
    }

    public Formatter format(String format, Object ... args) {
        this.doFormat(format, args);
        return this;
    }

    public Formatter format(Locale l, String format, Object ... args) {
        this.doFormat(format, args);
        return this;
    }

    private void doFormat(String format, Object ... args) {
        try {
            this.doFormat0(format, args);
        }
        catch (IOException t) {
            this.ioException = t;
        }
    }

    private void doFormat0(String format, Object ... args) throws IOException {
        int n = 0;
        int argn = 0;
        int len = format.length();
        block0: while (n < len) {
            char c;
            if ((c = format.charAt(n++)) == '%') {
                char cc;
                char pad = ' ';
                boolean step = false;
                boolean right = false;
                int width = 0;
                while (true) {
                    if ((cc = format.charAt(n++)) == '%') {
                        this.out.append('%');
                        continue block0;
                    }
                    if (cc == '-') {
                        right = true;
                        continue;
                    }
                    if (!step && cc == '0') {
                        pad = '0';
                        step = true;
                        continue;
                    }
                    if (cc < '0' || cc > '9') break;
                    width *= 10;
                    width += JTranscCType.decodeDigit((char)cc);
                }
                if (cc == 'n') {
                    this.out.append(JTranscSystem.lineSeparator());
                    continue;
                }
                this.out.append(this.formatValue(right, width, pad, cc, args[argn++]));
                continue;
            }
            this.out.append(c);
        }
    }

    private String formatValue(boolean right, int width, char pad, char c, Object value) {
        String out;
        switch (c) {
            case 'X': 
            case 'x': {
                out = value instanceof Long ? "" + Long.toUnsignedString((Long)value, 16) : "" + Integer.toUnsignedString((Integer)value, 16);
                if (c != 'X') break;
                out = out.toUpperCase();
                break;
            }
            default: {
                out = "" + value;
            }
        }
        if (width > 0) {
            while (out.length() < width) {
                if (right) {
                    out = "" + out + pad;
                    continue;
                }
                out = "" + pad + out;
            }
        }
        return out;
    }

    public String toString() {
        return this.out.toString();
    }

    public static enum BigDecimalLayoutForm {
        SCIENTIFIC,
        DECIMAL_FLOAT;

    }
}

