/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import libcore.io.Memory;

public class GZIPInputStream
extends InflaterInputStream {
    private static final int FCOMMENT = 16;
    private static final int FEXTRA = 4;
    private static final int FHCRC = 2;
    private static final int FNAME = 8;
    public static final int GZIP_MAGIC = 35615;
    protected CRC32 crc = new CRC32();
    protected boolean eos = false;

    public GZIPInputStream(InputStream is) throws IOException {
        this(is, 512);
    }

    public GZIPInputStream(InputStream is, int size) throws IOException {
        super(is, new Inflater(true), size);
        boolean hcrc;
        byte[] header = new byte[10];
        this.readFully(header, 0, header.length);
        short magic = Memory.peekShort(header, 0, ByteOrder.LITTLE_ENDIAN);
        if (magic != -29921) {
            throw new IOException(String.format("unknown format (magic number %x)", magic));
        }
        byte flags = header[3];
        boolean bl = hcrc = (flags & 2) != 0;
        if (hcrc) {
            this.crc.update(header, 0, header.length);
        }
        if ((flags & 4) != 0) {
            int result;
            this.readFully(header, 0, 2);
            if (hcrc) {
                this.crc.update(header, 0, 2);
            }
            for (int length = Memory.peekShort(header, 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF; length > 0; length -= result) {
                int max = length > this.buf.length ? this.buf.length : length;
                result = this.in.read(this.buf, 0, max);
                if (result == -1) {
                    throw new EOFException();
                }
                if (!hcrc) continue;
                this.crc.update(this.buf, 0, result);
            }
        }
        if ((flags & 8) != 0) {
            this.readZeroTerminated(hcrc);
        }
        if ((flags & 0x10) != 0) {
            this.readZeroTerminated(hcrc);
        }
        if (hcrc) {
            this.readFully(header, 0, 2);
            short crc16 = Memory.peekShort(header, 0, ByteOrder.LITTLE_ENDIAN);
            if ((short)this.crc.getValue() != crc16) {
                throw new IOException("CRC mismatch");
            }
            this.crc.reset();
        }
    }

    @Override
    public void close() throws IOException {
        this.eos = true;
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        int bytesRead;
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.eos) {
            return -1;
        }
        Arrays.checkOffsetAndCount(buffer.length, byteOffset, byteCount);
        try {
            bytesRead = super.read(buffer, byteOffset, byteCount);
        }
        finally {
            this.eos = this.eof;
        }
        if (bytesRead != -1) {
            this.crc.update(buffer, byteOffset, bytesRead);
        }
        if (this.eos) {
            this.verifyCrc();
        }
        return bytesRead;
    }

    private void verifyCrc() throws IOException {
        int size = this.inf.getRemaining();
        int trailerSize = 8;
        byte[] b = new byte[8];
        int copySize = size > 8 ? 8 : size;
        System.arraycopy((Object)this.buf, this.len - size, (Object)b, 0, copySize);
        this.readFully(b, copySize, 8 - copySize);
        if (Memory.peekInt(b, 0, ByteOrder.LITTLE_ENDIAN) != (int)this.crc.getValue()) {
            throw new IOException("CRC mismatch");
        }
        if (Memory.peekInt(b, 4, ByteOrder.LITTLE_ENDIAN) != this.inf.getTotalOut()) {
            throw new IOException("Size mismatch");
        }
    }

    private void readFully(byte[] buffer, int offset, int length) throws IOException {
        while (length > 0) {
            int result = this.in.read(buffer, offset, length);
            if (result == -1) {
                throw new EOFException();
            }
            offset += result;
            length -= result;
        }
    }

    private void readZeroTerminated(boolean hcrc) throws IOException {
        int result;
        while ((result = this.in.read()) > 0) {
            if (!hcrc) continue;
            this.crc.update(result);
        }
        if (result == -1) {
            throw new EOFException();
        }
        if (hcrc) {
            this.crc.update(result);
        }
    }
}

