/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.Arrays;

public abstract class CharsetEncoder {
    private static final int RESET = 0;
    private static final int ONGOING = 1;
    private static final int END_OF_INPUT = 2;
    private static final int FLUSHED = 3;
    private final Charset charset;
    private final float averageBytesPerChar;
    private final float maxBytesPerChar;
    private byte[] replacementBytes;
    private int state = 0;
    private CodingErrorAction malformedInputAction = CodingErrorAction.REPORT;
    private CodingErrorAction unmappableCharacterAction = CodingErrorAction.REPORT;
    private CharsetDecoder decoder;

    protected CharsetEncoder(Charset cs, float averageBytesPerChar, float maxBytesPerChar) {
        this(cs, averageBytesPerChar, maxBytesPerChar, new byte[]{63});
    }

    protected CharsetEncoder(Charset cs, float averageBytesPerChar, float maxBytesPerChar, byte[] replacement) {
        this(cs, averageBytesPerChar, maxBytesPerChar, replacement, false);
    }

    CharsetEncoder(Charset cs, float averageBytesPerChar, float maxBytesPerChar, byte[] replacement, boolean trusted) {
        if (averageBytesPerChar <= 0.0f || maxBytesPerChar <= 0.0f) {
            throw new IllegalArgumentException("averageBytesPerChar and maxBytesPerChar must both be positive");
        }
        if (averageBytesPerChar > maxBytesPerChar) {
            throw new IllegalArgumentException("averageBytesPerChar is greater than maxBytesPerChar");
        }
        this.charset = cs;
        this.averageBytesPerChar = averageBytesPerChar;
        this.maxBytesPerChar = maxBytesPerChar;
        if (trusted) {
            this.replacementBytes = replacement;
        } else {
            this.replaceWith(replacement);
        }
    }

    public final float averageBytesPerChar() {
        return this.averageBytesPerChar;
    }

    public boolean canEncode(char c) {
        return this.canEncode(CharBuffer.wrap(new char[]{c}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canEncode(CharSequence sequence) {
        CharBuffer cb = sequence instanceof CharBuffer ? ((CharBuffer)sequence).duplicate() : CharBuffer.wrap(sequence);
        if (this.state == 3) {
            this.reset();
        }
        if (this.state != 0) {
            throw this.illegalStateException();
        }
        CodingErrorAction originalMalformedInputAction = this.malformedInputAction;
        CodingErrorAction originalUnmappableCharacterAction = this.unmappableCharacterAction;
        this.onMalformedInput(CodingErrorAction.REPORT);
        this.onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            this.encode(cb);
            boolean bl = true;
            return bl;
        }
        catch (CharacterCodingException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.onMalformedInput(originalMalformedInputAction);
            this.onUnmappableCharacter(originalUnmappableCharacterAction);
            this.reset();
        }
    }

    public final Charset charset() {
        return this.charset;
    }

    public final ByteBuffer encode(CharBuffer in) throws CharacterCodingException {
        int length = (int)((float)in.remaining() * this.averageBytesPerChar);
        ByteBuffer out = ByteBuffer.allocate(length);
        this.reset();
        while (this.state != 3) {
            CoderResult result = this.encode(in, out, true);
            if (result == CoderResult.OVERFLOW) {
                out = this.allocateMore(out);
                continue;
            }
            this.checkCoderResult(result);
            result = this.flush(out);
            if (result == CoderResult.OVERFLOW) {
                out = this.allocateMore(out);
                continue;
            }
            this.checkCoderResult(result);
        }
        out.flip();
        return out;
    }

    private void checkCoderResult(CoderResult result) throws CharacterCodingException {
        if (this.malformedInputAction == CodingErrorAction.REPORT && result.isMalformed()) {
            throw new MalformedInputException(result.length());
        }
        if (this.unmappableCharacterAction == CodingErrorAction.REPORT && result.isUnmappable()) {
            throw new UnmappableCharacterException(result.length());
        }
    }

    private ByteBuffer allocateMore(ByteBuffer output) {
        if (output.capacity() == 0) {
            return ByteBuffer.allocate(1);
        }
        ByteBuffer result = ByteBuffer.allocate(output.capacity() * 2);
        output.flip();
        result.put(output);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final CoderResult encode(CharBuffer in, ByteBuffer out, boolean endOfInput) {
        if (!(this.state == 0 || this.state == 1 || endOfInput && this.state == 2)) {
            throw this.illegalStateException();
        }
        this.state = endOfInput ? 2 : 1;
        while (true) {
            CodingErrorAction action;
            CoderResult result;
            try {
                result = this.encodeLoop(in, out);
            }
            catch (BufferOverflowException ex) {
                throw new CoderMalfunctionError(ex);
            }
            catch (BufferUnderflowException ex) {
                throw new CoderMalfunctionError(ex);
            }
            if (result == CoderResult.UNDERFLOW) {
                if (!endOfInput || !in.hasRemaining()) return result;
                result = CoderResult.malformedForLength(in.remaining());
            } else if (result == CoderResult.OVERFLOW) {
                return result;
            }
            CodingErrorAction codingErrorAction = action = result.isUnmappable() ? this.unmappableCharacterAction : this.malformedInputAction;
            if (action == CodingErrorAction.REPORT) {
                return result;
            }
            if (action == CodingErrorAction.REPLACE) {
                if (out.remaining() < this.replacementBytes.length) {
                    return CoderResult.OVERFLOW;
                }
                out.put(this.replacementBytes);
            }
            in.position(in.position() + result.length());
        }
    }

    protected abstract CoderResult encodeLoop(CharBuffer var1, ByteBuffer var2);

    public final CoderResult flush(ByteBuffer out) {
        if (this.state != 3 && this.state != 2) {
            throw this.illegalStateException();
        }
        CoderResult result = this.implFlush(out);
        if (result == CoderResult.UNDERFLOW) {
            this.state = 3;
        }
        return result;
    }

    protected CoderResult implFlush(ByteBuffer out) {
        return CoderResult.UNDERFLOW;
    }

    protected void implOnMalformedInput(CodingErrorAction newAction) {
    }

    protected void implOnUnmappableCharacter(CodingErrorAction newAction) {
    }

    protected void implReplaceWith(byte[] newReplacement) {
    }

    protected void implReset() {
    }

    public boolean isLegalReplacement(byte[] replacement) {
        CharBuffer out;
        ByteBuffer in;
        CoderResult result;
        if (this.decoder == null) {
            this.decoder = this.charset.newDecoder();
            this.decoder.onMalformedInput(CodingErrorAction.REPORT);
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return !(result = this.decoder.decode(in = ByteBuffer.wrap(replacement), out = CharBuffer.allocate((int)((float)replacement.length * this.decoder.maxCharsPerByte())), true)).isError();
    }

    public CodingErrorAction malformedInputAction() {
        return this.malformedInputAction;
    }

    public final float maxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    public final CharsetEncoder onMalformedInput(CodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("newAction == null");
        }
        this.malformedInputAction = newAction;
        this.implOnMalformedInput(newAction);
        return this;
    }

    public final CharsetEncoder onUnmappableCharacter(CodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("newAction == null");
        }
        this.unmappableCharacterAction = newAction;
        this.implOnUnmappableCharacter(newAction);
        return this;
    }

    public final byte[] replacement() {
        return this.replacementBytes;
    }

    public final CharsetEncoder replaceWith(byte[] replacement) {
        if (replacement == null) {
            throw new IllegalArgumentException("replacement == null");
        }
        if (replacement.length == 0) {
            throw new IllegalArgumentException("replacement.length == 0");
        }
        if ((float)replacement.length > this.maxBytesPerChar()) {
            throw new IllegalArgumentException("replacement.length > maxBytesPerChar: " + replacement.length + " > " + this.maxBytesPerChar());
        }
        if (!this.isLegalReplacement(replacement)) {
            throw new IllegalArgumentException("Bad replacement: " + Arrays.toString(replacement));
        }
        this.replacementBytes = replacement;
        this.implReplaceWith(this.replacementBytes);
        return this;
    }

    public final CharsetEncoder reset() {
        this.state = 0;
        this.implReset();
        return this;
    }

    public CodingErrorAction unmappableCharacterAction() {
        return this.unmappableCharacterAction;
    }

    private IllegalStateException illegalStateException() {
        throw new IllegalStateException("State: " + this.state);
    }
}

