/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public abstract class Calendar
implements Serializable,
Cloneable,
Comparable<Calendar> {
    protected boolean areFieldsSet = false;
    protected int[] fields = new int[17];
    protected boolean[] isSet = new boolean[17];
    protected boolean isTimeSet = false;
    protected long time;
    transient int lastTimeFieldSet;
    transient int lastDateFieldSet;
    private boolean lenient;
    private int firstDayOfWeek;
    private int minimalDaysInFirstWeek;
    private TimeZone zone;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int FIELD_COUNT = 17;
    public static final int AM = 0;
    public static final int PM = 1;
    public static final int ALL_STYLES = 0;
    public static final int SHORT = 1;
    public static final int LONG = 2;
    private static final String[] FIELD_NAMES = new String[]{"ERA", "YEAR", "MONTH", "WEEK_OF_YEAR", "WEEK_OF_MONTH", "DAY_OF_MONTH", "DAY_OF_YEAR", "DAY_OF_WEEK", "DAY_OF_WEEK_IN_MONTH", "AM_PM", "HOUR", "HOUR_OF_DAY", "MINUTE", "SECOND", "MILLISECOND", "ZONE_OFFSET", "DST_OFFSET"};
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("areFieldsSet", Boolean.TYPE), new ObjectStreamField("fields", int[].class), new ObjectStreamField("firstDayOfWeek", Integer.TYPE), new ObjectStreamField("isSet", boolean[].class), new ObjectStreamField("isTimeSet", Boolean.TYPE), new ObjectStreamField("lenient", Boolean.TYPE), new ObjectStreamField("minimalDaysInFirstWeek", Integer.TYPE), new ObjectStreamField("nextStamp", Integer.TYPE), new ObjectStreamField("serialVersionOnStream", Integer.TYPE), new ObjectStreamField("time", Long.TYPE), new ObjectStreamField("zone", TimeZone.class)};

    protected Calendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    Calendar(TimeZone timezone) {
        this.setLenient(true);
        this.setTimeZone(timezone);
    }

    protected Calendar(TimeZone timezone, Locale locale) {
        this(timezone);
        this.setFirstDayOfWeek(0);
        this.setMinimalDaysInFirstWeek(0);
    }

    public abstract void add(int var1, int var2);

    public boolean after(Object calendar) {
        if (!(calendar instanceof Calendar)) {
            return false;
        }
        return this.getTimeInMillis() > ((Calendar)calendar).getTimeInMillis();
    }

    public boolean before(Object calendar) {
        if (!(calendar instanceof Calendar)) {
            return false;
        }
        return this.getTimeInMillis() < ((Calendar)calendar).getTimeInMillis();
    }

    public final void clear() {
        for (int i = 0; i < 17; ++i) {
            this.fields[i] = 0;
            this.isSet[i] = false;
        }
        this.isTimeSet = false;
        this.areFieldsSet = false;
    }

    public final void clear(int field) {
        this.fields[field] = 0;
        this.isSet[field] = false;
        this.isTimeSet = false;
        this.areFieldsSet = false;
    }

    public Object clone() {
        try {
            Calendar clone = (Calendar)super.clone();
            clone.fields = (int[])this.fields.clone();
            clone.isSet = (boolean[])this.isSet.clone();
            clone.zone = (TimeZone)this.zone.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void complete() {
        if (!this.isTimeSet) {
            this.computeTime();
            this.isTimeSet = true;
        }
        if (!this.areFieldsSet) {
            this.computeFields();
            this.areFieldsSet = true;
        }
    }

    protected abstract void computeFields();

    protected abstract void computeTime();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Calendar)) {
            return false;
        }
        Calendar cal = (Calendar)object;
        return this.getTimeInMillis() == cal.getTimeInMillis() && this.isLenient() == cal.isLenient() && this.getFirstDayOfWeek() == cal.getFirstDayOfWeek() && this.getMinimalDaysInFirstWeek() == cal.getMinimalDaysInFirstWeek() && this.getTimeZone().equals(cal.getTimeZone());
    }

    public int get(int field) {
        this.complete();
        return this.fields[field];
    }

    public int getActualMaximum(int field) {
        int value;
        int next = this.getLeastMaximum(field);
        if (this.getMaximum(field) == next) {
            return next;
        }
        this.complete();
        long orgTime = this.time;
        this.set(field, next);
        do {
            value = next;
            this.roll(field, true);
        } while ((next = this.get(field)) > value);
        this.time = orgTime;
        this.areFieldsSet = false;
        return value;
    }

    public int getActualMinimum(int field) {
        int value;
        int next = this.getGreatestMinimum(field);
        if (this.getMinimum(field) == next) {
            return next;
        }
        this.complete();
        long orgTime = this.time;
        this.set(field, next);
        do {
            value = next;
            this.roll(field, false);
        } while ((next = this.get(field)) < value);
        this.time = orgTime;
        this.areFieldsSet = false;
        return value;
    }

    public static synchronized Locale[] getAvailableLocales() {
        return new Locale[]{new Locale("en", "US")};
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public abstract int getGreatestMinimum(int var1);

    public static synchronized Calendar getInstance() {
        return new GregorianCalendar();
    }

    public static synchronized Calendar getInstance(Locale locale) {
        return new GregorianCalendar(locale);
    }

    public static synchronized Calendar getInstance(TimeZone timezone) {
        return new GregorianCalendar(timezone);
    }

    public static synchronized Calendar getInstance(TimeZone timezone, Locale locale) {
        return new GregorianCalendar(timezone, locale);
    }

    public abstract int getLeastMaximum(int var1);

    public abstract int getMaximum(int var1);

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    public abstract int getMinimum(int var1);

    public final Date getTime() {
        return new Date(this.getTimeInMillis());
    }

    public long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.computeTime();
            this.isTimeSet = true;
        }
        return this.time;
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public int hashCode() {
        return (this.isLenient() ? 1237 : 1231) + this.getFirstDayOfWeek() + this.getMinimalDaysInFirstWeek() + this.getTimeZone().hashCode();
    }

    protected final int internalGet(int field) {
        return this.fields[field];
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public final boolean isSet(int field) {
        return this.isSet[field];
    }

    public void roll(int field, int value) {
        boolean increment = value >= 0;
        int count = increment ? value : -value;
        for (int i = 0; i < count; ++i) {
            this.roll(field, increment);
        }
    }

    public abstract void roll(int var1, boolean var2);

    public void set(int field, int value) {
        this.fields[field] = value;
        this.isSet[field] = true;
        this.isTimeSet = false;
        this.areFieldsSet = false;
        if (field > 2 && field < 9) {
            this.lastDateFieldSet = field;
        }
        if (field == 10 || field == 11) {
            this.lastTimeFieldSet = field;
        }
        if (field == 9) {
            this.lastTimeFieldSet = 10;
        }
    }

    public final void set(int year, int month, int day) {
        this.set(1, year);
        this.set(2, month);
        this.set(5, day);
    }

    public final void set(int year, int month, int day, int hourOfDay, int minute) {
        this.set(year, month, day);
        this.set(11, hourOfDay);
        this.set(12, minute);
    }

    public final void set(int year, int month, int day, int hourOfDay, int minute, int second) {
        this.set(year, month, day, hourOfDay, minute);
        this.set(13, second);
    }

    public void setFirstDayOfWeek(int value) {
        this.firstDayOfWeek = value;
    }

    public void setLenient(boolean value) {
        this.lenient = value;
    }

    public void setMinimalDaysInFirstWeek(int value) {
        this.minimalDaysInFirstWeek = value;
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    public void setTimeInMillis(long milliseconds) {
        if (!this.isTimeSet || !this.areFieldsSet || this.time != milliseconds) {
            this.time = milliseconds;
            this.isTimeSet = true;
            this.areFieldsSet = false;
            this.complete();
        }
    }

    public void setTimeZone(TimeZone timezone) {
        this.zone = timezone;
        this.areFieldsSet = false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getName() + "[time=" + (this.isTimeSet ? String.valueOf(this.time) : "?") + ",areFieldsSet=" + this.areFieldsSet + ",lenient=" + this.lenient + ",zone=" + this.zone.getID() + ",firstDayOfWeek=" + this.firstDayOfWeek + ",minimalDaysInFirstWeek=" + this.minimalDaysInFirstWeek);
        for (int i = 0; i < 17; ++i) {
            result.append(',');
            result.append(FIELD_NAMES[i]);
            result.append('=');
            if (this.isSet[i]) {
                result.append(this.fields[i]);
                continue;
            }
            result.append('?');
        }
        result.append(']');
        return result.toString();
    }

    @Override
    public int compareTo(Calendar anotherCalendar) {
        long anotherTimeInMillis;
        if (anotherCalendar == null) {
            throw new NullPointerException("anotherCalendar == null");
        }
        long timeInMillis = this.getTimeInMillis();
        if (timeInMillis > (anotherTimeInMillis = anotherCalendar.getTimeInMillis())) {
            return 1;
        }
        if (timeInMillis == anotherTimeInMillis) {
            return 0;
        }
        return -1;
    }

    public String getDisplayName(int field, int style, Locale locale) {
        if (style == 0) {
            style = 1;
        }
        String[] array = this.getDisplayNameArray(field, style, locale);
        int value = this.get(field);
        return array != null ? array[value] : null;
    }

    private String[] getDisplayNameArray(int field, int style, Locale locale) {
        if (field < 0 || field >= 17) {
            throw new IllegalArgumentException("bad field " + field);
        }
        Calendar.checkStyle(style);
        DateFormatSymbols dfs = DateFormatSymbols.getInstance(locale);
        switch (field) {
            case 9: {
                return dfs.getAmPmStrings();
            }
            case 7: {
                return style == 2 ? dfs.getWeekdays() : dfs.getShortWeekdays();
            }
            case 0: {
                return dfs.getEras();
            }
            case 2: {
                return style == 2 ? dfs.getMonths() : dfs.getShortMonths();
            }
        }
        return null;
    }

    private static void checkStyle(int style) {
        if (style != 0 && style != 1 && style != 2) {
            throw new IllegalArgumentException("bad style " + style);
        }
    }

    public Map<String, Integer> getDisplayNames(int field, int style, Locale locale) {
        Calendar.checkStyle(style);
        this.complete();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (style == 1 || style == 0) {
            Calendar.insertValuesInMap(result, this.getDisplayNameArray(field, 1, locale));
        }
        if (style == 2 || style == 0) {
            Calendar.insertValuesInMap(result, this.getDisplayNameArray(field, 2, locale));
        }
        return result.isEmpty() ? null : result;
    }

    private static void insertValuesInMap(Map<String, Integer> map, String[] values) {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || values[i].isEmpty()) continue;
            map.put(values[i], i);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.complete();
        ObjectOutputStream.PutField putFields = stream.putFields();
        putFields.put("areFieldsSet", this.areFieldsSet);
        putFields.put("fields", this.fields);
        putFields.put("firstDayOfWeek", this.firstDayOfWeek);
        putFields.put("isSet", this.isSet);
        putFields.put("isTimeSet", this.isTimeSet);
        putFields.put("lenient", this.lenient);
        putFields.put("minimalDaysInFirstWeek", this.minimalDaysInFirstWeek);
        putFields.put("nextStamp", 2);
        putFields.put("serialVersionOnStream", 1);
        putFields.put("time", this.time);
        putFields.put("zone", this.zone);
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField readFields = stream.readFields();
        this.areFieldsSet = readFields.get("areFieldsSet", false);
        this.fields = (int[])readFields.get("fields", null);
        this.firstDayOfWeek = readFields.get("firstDayOfWeek", 1);
        this.isSet = (boolean[])readFields.get("isSet", null);
        this.isTimeSet = readFields.get("isTimeSet", false);
        this.lenient = readFields.get("lenient", true);
        this.minimalDaysInFirstWeek = readFields.get("minimalDaysInFirstWeek", 1);
        this.time = readFields.get("time", 0L);
        this.zone = (TimeZone)readFields.get("zone", null);
    }
}

