/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import com.jtransc.annotation.JTranscMethodBody;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.AsynchronousChannel;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.NetworkChannel;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;

public class AsynchronousServerSocketChannel
implements AsynchronousChannel,
NetworkChannel {
    protected AsynchronousServerSocketChannel(AsynchronousChannelProvider provider) {
    }

    public final AsynchronousChannelProvider provider() {
        return null;
    }

    @JTranscMethodBody(target="js", value={"this.server = null;", "this.clients = [];", "this.handlers = [];", "this._opened = false;"})
    AsynchronousServerSocketChannel() {
        this._init();
    }

    private native void _init();

    public static AsynchronousServerSocketChannel open(AsynchronousChannelGroup group) throws IOException {
        return new AsynchronousServerSocketChannel();
    }

    public static AsynchronousServerSocketChannel open() throws IOException {
        return AsynchronousServerSocketChannel.open(null);
    }

    @Override
    public final AsynchronousServerSocketChannel bind(SocketAddress local) throws IOException {
        return this.bind(local, 0);
    }

    @JTranscMethodBody(target="js", value={"var host = N.istr(p0), port = p1, backlog = p2;", "var net = require('net');", "var _this = this;", "this.server = net.createServer(function(socket) {", "\tvar client = {% CONSTRUCTOR java.nio.channels.AsynchronousSocketChannel:()V %}();", "\tclient.client = socket;", "\t_this.clients.push(client);", "\tif (_this.handlers.length != 0) { _this.handlers.shift()(_this.clients.shift()); }", "});", "this.server.on('error', function(err) { console.error(err); });", "this.server.listen(port, host, backlog, function() {", "\t_this.opened = true;", "});"})
    private native void _bind(String var1, int var2, int var3);

    AsynchronousServerSocketChannel bind(SocketAddress local, int backlog) throws IOException {
        InetSocketAddress address = (InetSocketAddress)local;
        this._bind(address.getHostName(), address.getPort(), backlog);
        return this;
    }

    @Override
    public <T> AsynchronousServerSocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        return this;
    }

    @Override
    public native <T> T getOption(SocketOption<T> var1) throws IOException;

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return new HashSet();
    }

    @JTranscMethodBody(target="js", value={"var attachment = p0, handler = p1;", "var handlers = this.handlers;", "function fhandle(client) { handler['{% METHOD java.nio.channels.CompletionHandler:completed %}'](client, attachment); }", "if (this.clients.length != 0) { fhandle(this.clients.shift()); } else { this.handlers.push(fhandle); }"})
    public native <A> void accept(A var1, CompletionHandler<AsynchronousSocketChannel, ? super A> var2);

    public native Future<AsynchronousSocketChannel> accept();

    @JTranscMethodBody(target="js", value={"return N.str(this.server.address().address);"})
    private native String _getLocalHost();

    @JTranscMethodBody(target="js", value={"return this.server.address().port;"})
    private native int _getLocalPort();

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return new InetSocketAddress(this._getLocalHost(), this._getLocalPort());
    }

    @Override
    @JTranscMethodBody(target="js", value={"return this.opened;"})
    public native boolean isOpen();

    @Override
    @JTranscMethodBody(target="js", value={"this.opened = false;", "if (this.server) this.server.close();"})
    public native void close() throws IOException;
}

