/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Objects;

public class InetSocketAddress
extends SocketAddress {
    private String hostname;
    private int port;

    public InetSocketAddress(int port) {
        this("0.0.0.0", port);
    }

    public InetSocketAddress(InetAddress addr, int port) {
        this(addr.getHostName(), port);
    }

    public InetSocketAddress(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    public static InetSocketAddress createUnresolved(String host, int port) {
        return new InetSocketAddress(host, port);
    }

    public final int getPort() {
        return this.port;
    }

    public final InetAddress getAddress() {
        try {
            return Inet4Address.getByName(this.hostname);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public final String getHostName() {
        return this.hostname;
    }

    public final String getHostString() {
        return this.hostname;
    }

    public final boolean isUnresolved() {
        return true;
    }

    public String toString() {
        return "InetSocketAddress(" + this.hostname + "," + this.port + ")";
    }

    public final boolean equals(Object obj) {
        if (obj == null || !(obj instanceof InetSocketAddress)) {
            return false;
        }
        InetSocketAddress that = (InetSocketAddress)obj;
        return Objects.equals(this.hostname, that.getHostName()) && this.port == that.getPort();
    }

    public final int hashCode() {
        return Objects.hashCode(this.hostname) + this.port;
    }
}

