/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.jtransc.JTranscSystemProperties;
import java.io.BufferedReader;
import java.io.Flushable;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Formatter;

public final class Console
implements Flushable {
    private static final Object CONSOLE_LOCK = new Object();
    private static final Console console = Console.makeConsole();
    private final ConsoleReader reader;
    private final PrintWriter writer;

    public static Console getConsole() {
        return console;
    }

    private static Console makeConsole() {
        try {
            return new Console(System.in, System.out);
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private Console(InputStream in, OutputStream out) throws IOException {
        this.reader = new ConsoleReader(in);
        this.writer = new ConsoleWriter(out);
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    public Console format(String format, Object ... args) {
        Formatter f = new Formatter(this.writer);
        f.format(format, args);
        f.flush();
        return this;
    }

    public Console printf(String format, Object ... args) {
        return this.format(format, args);
    }

    public Reader reader() {
        return this.reader;
    }

    public String readLine() {
        try {
            return this.reader.readLine();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine(String format, Object ... args) {
        Object object = CONSOLE_LOCK;
        synchronized (object) {
            this.format(format, args);
            return this.readLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] readPassword() {
        Object object = CONSOLE_LOCK;
        synchronized (object) {
            char[] cArray;
            int previousState = Console.setEcho(false, 0);
            try {
                String password = this.readLine();
                this.writer.println();
                cArray = password == null ? null : password.toCharArray();
            }
            catch (Throwable throwable) {
                Console.setEcho(true, previousState);
                throw throwable;
            }
            Console.setEcho(true, previousState);
            return cArray;
        }
    }

    private static int setEcho(boolean on, int previousState) {
        try {
            return Console.setEchoImpl(on, previousState);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    private static native int setEchoImpl(boolean var0, int var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] readPassword(String format, Object ... args) {
        Object object = CONSOLE_LOCK;
        synchronized (object) {
            this.format(format, args);
            return this.readPassword();
        }
    }

    public PrintWriter writer() {
        return this.writer;
    }

    private static class ConsoleWriter
    extends PrintWriter {
        public ConsoleWriter(OutputStream out) {
            super(out, true);
            this.lock = CONSOLE_LOCK;
        }

        @Override
        public void close() {
            this.flush();
        }
    }

    private static class ConsoleReader
    extends BufferedReader {
        public ConsoleReader(InputStream in) throws IOException {
            super(new InputStreamReader(in, JTranscSystemProperties.fileEncoding()), 256);
            this.lock = CONSOLE_LOCK;
        }

        @Override
        public void close() {
        }
    }
}

