/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.JTranscSystem;
import com.jtransc.annotation.JTranscAddLibraries;
import com.jtransc.annotation.JTranscMethodBody;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

@JTranscAddLibraries(target="cpp", value={"dl"})
public abstract class ClassLoader {
    private ArrayList<NativeLib> nativeLibs = new ArrayList();
    private ClassLoader parent;

    public ArrayList<NativeLib> getNativeLibs() {
        System.out.println(this.nativeLibs.size());
        System.out.flush();
        return this.nativeLibs;
    }

    protected ClassLoader(ClassLoader parent) {
        this.parent = parent;
    }

    protected ClassLoader() {
        this(null);
    }

    public final ClassLoader getParent() {
        return this.parent;
    }

    public static ClassLoader getSystemClassLoader() {
        return _ClassInternalUtils.getSystemClassLoader();
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return Class.forName(name);
    }

    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name);
    }

    protected Object getClassLoadingLock(String className) {
        return this;
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.loadClass(name);
    }

    @Deprecated
    protected final native Class<?> defineClass(byte[] var1, int var2, int var3) throws ClassFormatError;

    protected final native Class<?> defineClass(String var1, byte[] var2, int var3, int var4) throws ClassFormatError;

    protected final native void resolveClass(Class<?> var1);

    protected final Class<?> findSystemClass(String name) throws ClassNotFoundException {
        return this.loadClass(name);
    }

    protected final Class<?> findLoadedClass(String name) {
        try {
            return this.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected final void setSigners(Class<?> c, Object[] signers) {
    }

    public URL getResource(String name) {
        try {
            return new URL("file:///" + name);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return new Vector<URL>(Arrays.asList(this.getResource(name))).elements();
    }

    protected native URL findResource(String var1);

    protected native Enumeration<URL> findResources(String var1) throws IOException;

    protected static native boolean registerAsParallelCapable();

    public static native URL getSystemResource(String var0);

    public static native Enumeration<URL> getSystemResources(String var0) throws IOException;

    public InputStream getResourceAsStream(String name) {
        try {
            return new FileInputStream(name);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static native InputStream getSystemResourceAsStream(String var0);

    protected native Package definePackage(String var1, String var2, String var3, String var4, String var5, String var6, String var7, URL var8) throws IllegalArgumentException;

    protected native Package getPackage(String var1);

    protected native Package[] getPackages();

    protected native String findLibrary(String var1);

    public native void setDefaultAssertionStatus(boolean var1);

    public native void setPackageAssertionStatus(String var1, boolean var2);

    public native void setClassAssertionStatus(String var1, boolean var2);

    public native void clearAssertionStatus();

    void loadLibrary(Class fromClass, String name, boolean isAbsolute) {
        if (JTranscSystem.isCpp()) {
            NativeLib nativeLib = new NativeLib(ClassLoader.loadLibrarayCpp(name), name);
            if (!this.nativeLibs.contains(nativeLib)) {
                this.nativeLibs.add(nativeLib);
            } else {
                ClassLoader.unLoadLibrarayCpp(nativeLib.handle);
            }
        } else {
            throw new UnsupportedOperationException("Loading dynamic libs is only supported by the cpp target!");
        }
    }

    @JTranscMethodBody(target="cpp", value={"return ptr_to_jlong(N::jtvmLoadDynamicLibraray(N::istr3(p0).c_str()));"})
    private static long loadLibrarayCpp(String filename) {
        return 0L;
    }

    @JTranscMethodBody(target="cpp", value={"N::jtvmUnLoadDynamicLibraray(jlong_to_ptr(p0));"})
    private static void unLoadLibrarayCpp(long handle) {
    }

    public static class NativeLib {
        long handle;
        String name;

        NativeLib(long handle, String name) {
            this.handle = handle;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NativeLib nativeLib = (NativeLib)o;
            return this.handle == nativeLib.handle;
        }

        public int hashCode() {
            return (int)(this.handle ^ this.handle >>> 32);
        }
    }
}

