/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import com.jtransc.annotation.JTranscInvisible;
import j.MemberInfo;
import j.ProgramReflection;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.MethodTypeImpl;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect._InternalUtils;

public abstract class MethodConstructor
extends AccessibleObject {
    protected int typeId;
    protected int id;
    protected Class<?> clazz;
    protected int slot;
    protected String name;
    protected Class<?>[] parameterTypes;
    protected Class<?>[] exceptionTypes = new Class[0];
    protected int modifiers;
    protected byte[] annotations;
    protected byte[] parameterAnnotations;
    protected byte[] annotationDefault;
    protected transient String signature;
    protected transient String genericSignature;
    @JTranscInvisible
    private MethodTypeImpl methodType;
    @JTranscInvisible
    private MethodTypeImpl genericMethodType;
    private Parameter[] _params;

    public MethodConstructor(Class<?> containingClass, MemberInfo info) {
        super(info);
        this.clazz = containingClass;
        this.id = info.id;
        this.slot = info.id;
        this.name = info.name;
        this.signature = info.desc;
        this.genericSignature = info.genericDesc;
        this.modifiers = info.modifiers;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        Annotation[] out = ProgramReflection.getMethodAnnotations((int)this.clazz.id, (int)this.info.id);
        return out != null ? out : new Annotation[]{};
    }

    @JTranscInvisible
    protected MethodTypeImpl methodType() {
        if (this.methodType == null) {
            this.methodType = _InternalUtils.parseMethodType(this.signature, null);
        }
        return this.methodType;
    }

    public Class<?>[] getExceptionTypes() {
        return (Class[])this.exceptionTypes.clone();
    }

    @JTranscInvisible
    protected MethodTypeImpl genericMethodType() {
        if (this.genericMethodType == null) {
            this.genericMethodType = this.genericSignature != null ? _InternalUtils.parseMethodType(this.genericSignature, null) : this.methodType();
        }
        return this.genericMethodType;
    }

    public Annotation[][] getParameterAnnotations() {
        int count = this.getParameterTypes().length;
        Annotation[][] out = new Annotation[count][];
        out = new Annotation[this.methodType().args.length][];
        for (int n = 0; n < count; ++n) {
            Annotation[] annotations = ProgramReflection.getMethodArgumentAnnotations((int)this.clazz.id, (int)this.info.id, (int)n);
            out[n] = annotations != null ? annotations : new Annotation[]{};
        }
        return out;
    }

    public Class<?> getReturnType() {
        return null;
    }

    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return null;
    }

    protected abstract boolean isConstructor();

    public Class<?>[] getParameterTypes() {
        return (Class[])this.methodType().args;
    }

    public Parameter[] getParameters() {
        if (this._params == null) {
            Class<?>[] parameterTypes = this.getParameterTypes();
            this._params = new Parameter[parameterTypes.length];
            for (int n = 0; n < parameterTypes.length; ++n) {
                this._params[n] = new Parameter(this, n);
            }
        }
        return (Parameter[])this._params.clone();
    }

    public boolean isVarArgs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    public String toString() {
        int mod = this.getModifiers();
        String out = "";
        if (mod != 0) {
            out = out + Modifier.toString(mod) + " ";
        }
        if (this.getReturnType() != null) {
            out = out + _InternalUtils.getTypeName(this.getReturnType()) + " ";
        }
        out = out + _InternalUtils.getTypeName(this.getDeclaringClass());
        if (!this.isConstructor()) {
            out = out + "." + this.getName();
        }
        out = out + "(";
        boolean first = true;
        for (Class<?> param : this.getParameterTypes()) {
            if (!first) {
                out = out + ",";
            }
            out = out + _InternalUtils.getTypeName(param);
            first = false;
        }
        out = out + ")";
        return out;
    }
}

