/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class URLEncoder {
    private static BitSet normal = new BitSet(256);
    private static String normalTable = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 -_.*";

    private URLEncoder() {
    }

    @Deprecated
    public static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        byte[] data;
        StringBuilder sb = new StringBuilder(s.length());
        for (byte c : data = s.getBytes(enc)) {
            if (c == 32) {
                sb.append('+');
                continue;
            }
            if (normal.get(c & 0xFF)) {
                sb.append((char)c);
                continue;
            }
            sb.append('%');
            sb.append(Character.toUpperCase(Character.forDigit(c >>> 4 & 0xF, 16)));
            sb.append(Character.toUpperCase(Character.forDigit(c >>> 0 & 0xF, 16)));
        }
        return sb.toString();
    }

    static {
        for (char c : normalTable.toCharArray()) {
            normal.set(c);
        }
    }
}

