/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;

public abstract class TimeZone
implements Serializable,
Cloneable {
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private static final TimeZone GMT = new SimpleTimeZone(0, "GMT");
    private static final TimeZone UTC;
    private static TimeZone defaultTimeZone;
    private String ID;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static synchronized String[] getAvailableIDs() {
        return new String[]{"UTC"};
    }

    public static synchronized String[] getAvailableIDs(int offsetMillis) {
        return TimeZone.getAvailableIDs();
    }

    public static synchronized TimeZone getDefault() {
        return defaultTimeZone;
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault());
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean daylightTime, int style) {
        return this.getDisplayName(daylightTime, style, Locale.getDefault());
    }

    public String getDisplayName(boolean daylightTime, int style, Locale locale) {
        return "UTC";
    }

    public String getID() {
        return this.ID;
    }

    public int getDSTSavings() {
        return this.useDaylightTime() ? 3600000 : 0;
    }

    public int getOffset(long time) {
        if (this.inDaylightTime(new Date(time))) {
            return this.getRawOffset() + this.getDSTSavings();
        }
        return this.getRawOffset();
    }

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract int getRawOffset();

    public static synchronized TimeZone getTimeZone(String id) {
        return UTC;
    }

    public boolean hasSameRules(TimeZone timeZone) {
        if (timeZone == null) {
            return false;
        }
        return this.getRawOffset() == timeZone.getRawOffset();
    }

    public abstract boolean inDaylightTime(Date var1);

    public static synchronized void setDefault(TimeZone timeZone) {
        defaultTimeZone = timeZone != null ? (TimeZone)timeZone.clone() : null;
    }

    public void setID(String id) {
        this.ID = id;
    }

    public abstract void setRawOffset(int var1);

    public abstract boolean useDaylightTime();

    static {
        defaultTimeZone = UTC = new SimpleTimeZone(0, "UTC");
    }
}

