/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import com.jtransc.annotation.JTranscMethodBody;
import java.io.Serializable;

public class AtomicInteger
extends Number
implements Serializable {
    private volatile int value;

    public AtomicInteger(int initialValue) {
        this.value = initialValue;
    }

    public AtomicInteger() {
    }

    @JTranscMethodBody(target="d", value={"return core.atomic.atomicLoad!(core.atomic.MemoryOrder.seq)(*cast(shared(int *))&this{% IFIELD #CLASS:value %});"})
    public final int get() {
        return this.value;
    }

    @JTranscMethodBody(target="d", value={"core.atomic.atomicStore!(core.atomic.MemoryOrder.seq)(*cast(shared(int *))&this{% IFIELD #CLASS:value %}, p0);"})
    public final void set(int newValue) {
        this.value = newValue;
    }

    @JTranscMethodBody(target="d", value={"core.atomic.atomicStore!(core.atomic.MemoryOrder.raw)(*cast(shared(int *))&this{% IFIELD #CLASS:value %}, p0);"})
    public final void lazySet(int newValue) {
        this.set(newValue);
    }

    @JTranscMethodBody(target="d", value={"return core.atomic.cas(cast(shared(int *))&this{% IFIELD #CLASS:value %}, cast(const(int))p0, p1);"})
    public final boolean compareAndSet(int expect, int update) {
        if (this.get() == expect) {
            this.set(update);
            return true;
        }
        return false;
    }

    @JTranscMethodBody(target="d", value={"return core.atomic.atomicOp!(\"+=\")(*cast(shared(int *))&this{% IFIELD #CLASS:value %}, p0);"})
    private int _addAndGet(int delta) {
        this.value = this.get() + delta;
        return this.value;
    }

    public final int addAndGet(int delta) {
        return this._addAndGet(delta);
    }

    public final int getAndAdd(int delta) {
        return this._addAndGet(delta) - delta;
    }

    public final int getAndSet(int newValue) {
        int old = this.get();
        this.set(newValue);
        return old;
    }

    public final boolean weakCompareAndSet(int expect, int update) {
        return this.compareAndSet(expect, update);
    }

    public final int getAndIncrement() {
        return this.getAndAdd(1);
    }

    public final int getAndDecrement() {
        return this.getAndAdd(-1);
    }

    public final int incrementAndGet() {
        return this.addAndGet(1);
    }

    public final int decrementAndGet() {
        return this.addAndGet(-1);
    }

    public String toString() {
        return Integer.toString(this.get());
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }
}

