/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.charset.charsets;

import com.jtransc.charset.JTranscCharset;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class JTranscCharsetUTF8
extends JTranscCharset {
    public JTranscCharsetUTF8() {
        super(new String[]{"UTF-8", "UTF8"}, 1, 1.2f, 4);
    }

    public void encode(char[] in, int offset, int len, ByteArrayOutputStream out) {
        for (int n = 0; n < len; ++n) {
            char codePoint = in[offset + n];
            if ((codePoint & 0xFFFFFF80) == 0) {
                out.write(codePoint);
                continue;
            }
            if ((codePoint & 0xFFFFF800) == 0) {
                out.write(codePoint >> 6 & 0x1F | 0xC0);
            } else if ((codePoint & 0xFFFF0000) == 0) {
                out.write(codePoint >> 12 & 0xF | 0xE0);
                out.write(JTranscCharsetUTF8.createByte(codePoint, 6));
            } else if ((codePoint & 0xFFE00000) == 0) {
                out.write(codePoint >> 18 & 7 | 0xF0);
                out.write(JTranscCharsetUTF8.createByte(codePoint, 12));
                out.write(JTranscCharsetUTF8.createByte(codePoint, 6));
            }
            out.write(codePoint & 0x3F | 0x80);
        }
    }

    private static int createByte(int codePoint, int shift) {
        return codePoint >> shift & 0x3F | 0x80;
    }

    public void decode(byte[] in, int offset, int len, StringBuilder out) {
        int i = offset;
        int end = offset + len;
        while (i < end) {
            int c = in[i++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    out.append((char)c);
                    break;
                }
                case 12: 
                case 13: {
                    out.append((char)((c & 0x1F) << 6 | in[i++] & 0x3F));
                    break;
                }
                case 14: {
                    out.append((char)((c & 0xF) << 12 | (in[i++] & 0x3F) << 6 | (in[i++] & 0x3F) << 0));
                }
            }
        }
    }

    public void decode(ByteBuffer in, CharBuffer out) {
        while (in.hasRemaining() && out.hasRemaining()) {
            int c = in.get() & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    out.append((char)c);
                    break;
                }
                case 12: 
                case 13: {
                    if (!in.hasRemaining()) break;
                    out.append((char)((c & 0x1F) << 6 | in.get() & 0x3F));
                    break;
                }
                case 14: {
                    if (!in.hasRemaining()) break;
                    out.append((char)((c & 0xF) << 12 | (in.get() & 0x3F) << 6 | (in.get() & 0x3F) << 0));
                }
            }
        }
    }
}

