/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.jtransc.annotation.JTranscMethodBody;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ComparableTimSort;
import java.util.Comparator;
import java.util.DualPivotQuicksort;
import java.util.List;
import java.util.RandomAccess;
import java.util.TimSort;

public class Arrays {
    private Arrays() {
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... array) {
        return new ArrayList<T>(array);
    }

    public static int binarySearch(byte[] array, byte value) {
        return Arrays.binarySearch(array, 0, array.length, value);
    }

    public static int binarySearch(byte[] array, int startIndex, int endIndex, byte value) {
        Arrays.checkBinarySearchBounds(startIndex, endIndex, array.length);
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            byte midVal = array[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static int binarySearch(char[] array, char value) {
        return Arrays.binarySearch(array, 0, array.length, value);
    }

    public static int binarySearch(char[] array, int startIndex, int endIndex, char value) {
        Arrays.checkBinarySearchBounds(startIndex, endIndex, array.length);
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            char midVal = array[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static int binarySearch(double[] array, double value) {
        return Arrays.binarySearch(array, 0, array.length, value);
    }

    public static int binarySearch(double[] array, int startIndex, int endIndex, double value) {
        Arrays.checkBinarySearchBounds(startIndex, endIndex, array.length);
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            long valueBits;
            int mid = lo + hi >>> 1;
            double midVal = array[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            if (midVal != 0.0 && midVal == value) {
                return mid;
            }
            long midValBits = Double.doubleToLongBits(midVal);
            if (midValBits < (valueBits = Double.doubleToLongBits(value))) {
                lo = mid + 1;
                continue;
            }
            if (midValBits > valueBits) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static int binarySearch(float[] array, float value) {
        return Arrays.binarySearch(array, 0, array.length, value);
    }

    public static int binarySearch(float[] array, int startIndex, int endIndex, float value) {
        Arrays.checkBinarySearchBounds(startIndex, endIndex, array.length);
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            int valueBits;
            int mid = lo + hi >>> 1;
            float midVal = array[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            if (midVal != 0.0f && midVal == value) {
                return mid;
            }
            int midValBits = Float.floatToIntBits(midVal);
            if (midValBits < (valueBits = Float.floatToIntBits(value))) {
                lo = mid + 1;
                continue;
            }
            if (midValBits > valueBits) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static int binarySearch(int[] array, int value) {
        return Arrays.binarySearch(array, 0, array.length, value);
    }

    public static int binarySearch(int[] array, int startIndex, int endIndex, int value) {
        Arrays.checkBinarySearchBounds(startIndex, endIndex, array.length);
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int midVal = array[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static int binarySearch(long[] array, long value) {
        return Arrays.binarySearch(array, 0, array.length, value);
    }

    public static int binarySearch(long[] array, int startIndex, int endIndex, long value) {
        Arrays.checkBinarySearchBounds(startIndex, endIndex, array.length);
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            long midVal = array[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static int binarySearch(Object[] array, Object value) {
        return Arrays.binarySearch(array, 0, array.length, value);
    }

    public static int binarySearch(Object[] array, int startIndex, int endIndex, Object value) {
        Arrays.checkBinarySearchBounds(startIndex, endIndex, array.length);
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int midValCmp = ((Comparable)array[mid]).compareTo(value);
            if (midValCmp < 0) {
                lo = mid + 1;
                continue;
            }
            if (midValCmp > 0) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static <T> int binarySearch(T[] array, T value, Comparator<? super T> comparator) {
        return Arrays.binarySearch(array, 0, array.length, value, comparator);
    }

    public static <T> int binarySearch(T[] array, int startIndex, int endIndex, T value, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Arrays.binarySearch(array, startIndex, endIndex, value);
        }
        Arrays.checkBinarySearchBounds(startIndex, endIndex, array.length);
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int midValCmp = comparator.compare(array[mid], value);
            if (midValCmp < 0) {
                lo = mid + 1;
                continue;
            }
            if (midValCmp > 0) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static int binarySearch(short[] array, short value) {
        return Arrays.binarySearch(array, 0, array.length, value);
    }

    public static int binarySearch(short[] array, int startIndex, int endIndex, short value) {
        Arrays.checkBinarySearchBounds(startIndex, endIndex, array.length);
        int lo = startIndex;
        int hi = endIndex - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            short midVal = array[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    private static void checkBinarySearchBounds(int startIndex, int endIndex, int length) {
        if (startIndex > endIndex) {
            throw new IllegalArgumentException();
        }
        if (startIndex < 0 || endIndex > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static void fill(byte[] array, byte value) {
        Arrays.fill(array, 0, array.length, value);
    }

    public static void fill(short[] array, short value) {
        Arrays.fill(array, 0, array.length, value);
    }

    public static void fill(char[] array, char value) {
        Arrays.fill(array, 0, array.length, value);
    }

    public static void fill(int[] array, int value) {
        Arrays.fill(array, 0, array.length, value);
    }

    public static void fill(long[] array, long value) {
        Arrays.fill(array, 0, array.length, value);
    }

    public static void fill(float[] array, float value) {
        Arrays.fill(array, 0, array.length, value);
    }

    public static void fill(double[] array, double value) {
        Arrays.fill(array, 0, array.length, value);
    }

    public static void fill(boolean[] array, boolean value) {
        Arrays.fill(array, 0, array.length, value);
    }

    public static void fill(Object[] array, Object value) {
        Arrays.fill(array, 0, array.length, value);
    }

    @JTranscMethodBody(target="cpp", value={"GET_OBJECT(JA_B, p0)->fill(p1, p2, p3);"})
    public static void fill(byte[] array, int start, int end, byte value) {
        Arrays.checkStartAndEnd(array.length, start, end);
        for (int i = start; i < end; ++i) {
            array[i] = value;
        }
    }

    @JTranscMethodBody(target="cpp", value={"GET_OBJECT(JA_S, p0)->fill(p1, p2, p3);"})
    public static void fill(short[] array, int start, int end, short value) {
        Arrays.checkStartAndEnd(array.length, start, end);
        for (int i = start; i < end; ++i) {
            array[i] = value;
        }
    }

    @JTranscMethodBody(target="cpp", value={"GET_OBJECT(JA_C, p0)->fill(p1, p2, p3);"})
    public static void fill(char[] array, int start, int end, char value) {
        Arrays.checkStartAndEnd(array.length, start, end);
        for (int i = start; i < end; ++i) {
            array[i] = value;
        }
    }

    @JTranscMethodBody(target="cpp", value={"GET_OBJECT(JA_I, p0)->fill(p1, p2, p3);"})
    public static void fill(int[] array, int start, int end, int value) {
        Arrays.checkStartAndEnd(array.length, start, end);
        for (int i = start; i < end; ++i) {
            array[i] = value;
        }
    }

    @JTranscMethodBody(target="cpp", value={"GET_OBJECT(JA_J, p0)->fill(p1, p2, p3);"})
    public static void fill(long[] array, int start, int end, long value) {
        Arrays.checkStartAndEnd(array.length, start, end);
        for (int i = start; i < end; ++i) {
            array[i] = value;
        }
    }

    @JTranscMethodBody(target="cpp", value={"GET_OBJECT(JA_F, p0)->fill(p1, p2, p3);"})
    public static void fill(float[] array, int start, int end, float value) {
        Arrays.checkStartAndEnd(array.length, start, end);
        for (int i = start; i < end; ++i) {
            array[i] = value;
        }
    }

    @JTranscMethodBody(target="cpp", value={"GET_OBJECT(JA_D, p0)->fill(p1, p2, p3);"})
    public static void fill(double[] array, int start, int end, double value) {
        Arrays.checkStartAndEnd(array.length, start, end);
        for (int i = start; i < end; ++i) {
            array[i] = value;
        }
    }

    @JTranscMethodBody(target="cpp", value={"GET_OBJECT(JA_Z, p0)->fill(p1, p2, p3);"})
    public static void fill(boolean[] array, int start, int end, boolean value) {
        Arrays.checkStartAndEnd(array.length, start, end);
        for (int i = start; i < end; ++i) {
            array[i] = value;
        }
    }

    @JTranscMethodBody(target="cpp", value={"GET_OBJECT(JA_L, p0)->fill(p1, p2, p3);"})
    public static void fill(Object[] array, int start, int end, Object value) {
        Arrays.checkStartAndEnd(array.length, start, end);
        for (int i = start; i < end; ++i) {
            array[i] = value;
        }
    }

    public static int hashCode(boolean[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (boolean element : array) {
            hashCode = 31 * hashCode + (element ? 1231 : 1237);
        }
        return hashCode;
    }

    public static int hashCode(int[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (int element : array) {
            hashCode = 31 * hashCode + element;
        }
        return hashCode;
    }

    public static int hashCode(short[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (short element : array) {
            hashCode = 31 * hashCode + element;
        }
        return hashCode;
    }

    public static int hashCode(char[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (char element : array) {
            hashCode = 31 * hashCode + element;
        }
        return hashCode;
    }

    public static int hashCode(byte[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (byte element : array) {
            hashCode = 31 * hashCode + element;
        }
        return hashCode;
    }

    public static int hashCode(long[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (long elementValue : array) {
            hashCode = 31 * hashCode + (int)(elementValue ^ elementValue >>> 32);
        }
        return hashCode;
    }

    public static int hashCode(float[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (float element : array) {
            hashCode = 31 * hashCode + Float.floatToIntBits(element);
        }
        return hashCode;
    }

    public static int hashCode(double[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (double element : array) {
            long v = Double.doubleToLongBits(element);
            hashCode = 31 * hashCode + (int)(v ^ v >>> 32);
        }
        return hashCode;
    }

    public static int hashCode(Object[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (Object element : array) {
            hashCode = 31 * hashCode + (element == null ? 0 : element.hashCode());
        }
        return hashCode;
    }

    public static int deepHashCode(Object[] array) {
        if (array == null) {
            return 0;
        }
        int hashCode = 1;
        for (Object element : array) {
            int elementHashCode = Arrays.deepHashCodeElement(element);
            hashCode = 31 * hashCode + elementHashCode;
        }
        return hashCode;
    }

    private static int deepHashCodeElement(Object element) {
        if (element == null) {
            return 0;
        }
        Class<?> cl = element.getClass().getComponentType();
        if (cl == null) {
            return element.hashCode();
        }
        if (!cl.isPrimitive()) {
            return Arrays.deepHashCode((Object[])element);
        }
        if (cl.equals(Integer.TYPE)) {
            return Arrays.hashCode((int[])element);
        }
        if (cl.equals(Character.TYPE)) {
            return Arrays.hashCode((char[])element);
        }
        if (cl.equals(Boolean.TYPE)) {
            return Arrays.hashCode((boolean[])element);
        }
        if (cl.equals(Byte.TYPE)) {
            return Arrays.hashCode((byte[])element);
        }
        if (cl.equals(Long.TYPE)) {
            return Arrays.hashCode((long[])element);
        }
        if (cl.equals(Float.TYPE)) {
            return Arrays.hashCode((float[])element);
        }
        if (cl.equals(Double.TYPE)) {
            return Arrays.hashCode((double[])element);
        }
        return Arrays.hashCode((short[])element);
    }

    public static boolean equals(byte[] array1, byte[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] array1, short[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] array1, char[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] array1, int[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(long[] array1, long[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] array1, float[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (Float.floatToIntBits(array1[i]) == Float.floatToIntBits(array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] array1, double[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (Double.doubleToLongBits(array1[i]) == Double.doubleToLongBits(array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(boolean[] array1, boolean[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            Object e1 = array1[i];
            Object e2 = array2[i];
            if (e1 != null ? e1.equals(e2) : e2 == null) continue;
            return false;
        }
        return true;
    }

    public static boolean deepEquals(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            Object e1 = array1[i];
            Object e2 = array2[i];
            if (Arrays.deepEqualsElements(e1, e2)) continue;
            return false;
        }
        return true;
    }

    private static boolean deepEqualsElements(Object e1, Object e2) {
        Class<?> cl2;
        if (e1 == e2) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        Class<?> cl1 = e1.getClass().getComponentType();
        if (cl1 != (cl2 = e2.getClass().getComponentType())) {
            return false;
        }
        if (cl1 == null) {
            return e1.equals(e2);
        }
        if (!cl1.isPrimitive()) {
            return Arrays.deepEquals((Object[])e1, (Object[])e2);
        }
        if (cl1.equals(Integer.TYPE)) {
            return Arrays.equals((int[])e1, (int[])e2);
        }
        if (cl1.equals(Character.TYPE)) {
            return Arrays.equals((char[])e1, (char[])e2);
        }
        if (cl1.equals(Boolean.TYPE)) {
            return Arrays.equals((boolean[])e1, (boolean[])e2);
        }
        if (cl1.equals(Byte.TYPE)) {
            return Arrays.equals((byte[])e1, (byte[])e2);
        }
        if (cl1.equals(Long.TYPE)) {
            return Arrays.equals((long[])e1, (long[])e2);
        }
        if (cl1.equals(Float.TYPE)) {
            return Arrays.equals((float[])e1, (float[])e2);
        }
        if (cl1.equals(Double.TYPE)) {
            return Arrays.equals((double[])e1, (double[])e2);
        }
        return Arrays.equals((short[])e1, (short[])e2);
    }

    public static void sort(byte[] array) {
        DualPivotQuicksort.sort(array);
    }

    public static void sort(byte[] array, int start, int end) {
        DualPivotQuicksort.sort(array, start, end);
    }

    public static void checkOffsetAndCount(int arrayLength, int offset, int count) {
        if ((offset | count) < 0 || offset > arrayLength || arrayLength - offset < count) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static void checkStartAndEnd(int len, int start, int end) {
        if (start < 0 || end > len) {
            throw new ArrayIndexOutOfBoundsException("start < 0 || end > len. start=" + start + ", end=" + end + ", len=" + len);
        }
        if (start > end) {
            throw new IllegalArgumentException("start > end: " + start + " > " + end);
        }
    }

    public static void sort(char[] array) {
        DualPivotQuicksort.sort(array);
    }

    public static void sort(char[] array, int start, int end) {
        DualPivotQuicksort.sort(array, start, end);
    }

    public static void sort(double[] array) {
        DualPivotQuicksort.sort(array);
    }

    public static void sort(double[] array, int start, int end) {
        DualPivotQuicksort.sort(array, start, end);
    }

    public static void sort(float[] array) {
        DualPivotQuicksort.sort(array);
    }

    public static void sort(float[] array, int start, int end) {
        DualPivotQuicksort.sort(array, start, end);
    }

    public static void sort(int[] array) {
        DualPivotQuicksort.sort(array);
    }

    public static void sort(int[] array, int start, int end) {
        DualPivotQuicksort.sort(array, start, end);
    }

    public static void sort(long[] array) {
        DualPivotQuicksort.sort(array);
    }

    public static void sort(long[] array, int start, int end) {
        DualPivotQuicksort.sort(array, start, end);
    }

    public static void sort(short[] array) {
        DualPivotQuicksort.sort(array);
    }

    public static void sort(short[] array, int start, int end) {
        DualPivotQuicksort.sort(array, start, end);
    }

    public static void sort(Object[] array) {
        ComparableTimSort.sort(array);
    }

    public static void sort(Object[] array, int start, int end) {
        ComparableTimSort.sort(array, start, end);
    }

    public static <T> void sort(T[] array, int start, int end, Comparator<? super T> comparator) {
        TimSort.sort(array, start, end, comparator);
    }

    public static <T> void sort(T[] array, Comparator<? super T> comparator) {
        TimSort.sort(array, comparator);
    }

    public static String toString(boolean[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array.length * 7);
        sb.append('[');
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(byte[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array.length * 6);
        sb.append('[');
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(char[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array.length * 3);
        sb.append('[');
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(double[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array.length * 7);
        sb.append('[');
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(float[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array.length * 7);
        sb.append('[');
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(int[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array.length * 6);
        sb.append('[');
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(long[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array.length * 6);
        sb.append('[');
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(short[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array.length * 6);
        sb.append('[');
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(Object[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(array.length * 7);
        sb.append('[');
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String deepToString(Object[] array) {
        if (array == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder(array.length * 9);
        Arrays.deepToStringImpl(array, new Object[]{array}, buf);
        return buf.toString();
    }

    private static void deepToStringImpl(Object[] array, Object[] origArrays, StringBuilder sb) {
        if (array == null) {
            sb.append("null");
            return;
        }
        sb.append('[');
        for (int i = 0; i < array.length; ++i) {
            Object elem;
            if (i != 0) {
                sb.append(", ");
            }
            if ((elem = array[i]) == null) {
                sb.append("null");
                continue;
            }
            Class<?> elemClass = elem.getClass();
            if (elemClass.isArray()) {
                Class<?> elemElemClass = elemClass.getComponentType();
                if (elemElemClass.isPrimitive()) {
                    if (Boolean.TYPE.equals(elemElemClass)) {
                        sb.append(Arrays.toString((boolean[])elem));
                        continue;
                    }
                    if (Byte.TYPE.equals(elemElemClass)) {
                        sb.append(Arrays.toString((byte[])elem));
                        continue;
                    }
                    if (Character.TYPE.equals(elemElemClass)) {
                        sb.append(Arrays.toString((char[])elem));
                        continue;
                    }
                    if (Double.TYPE.equals(elemElemClass)) {
                        sb.append(Arrays.toString((double[])elem));
                        continue;
                    }
                    if (Float.TYPE.equals(elemElemClass)) {
                        sb.append(Arrays.toString((float[])elem));
                        continue;
                    }
                    if (Integer.TYPE.equals(elemElemClass)) {
                        sb.append(Arrays.toString((int[])elem));
                        continue;
                    }
                    if (Long.TYPE.equals(elemElemClass)) {
                        sb.append(Arrays.toString((long[])elem));
                        continue;
                    }
                    if (Short.TYPE.equals(elemElemClass)) {
                        sb.append(Arrays.toString((short[])elem));
                        continue;
                    }
                    throw new AssertionError();
                }
                if (Arrays.deepToStringImplContains(origArrays, elem)) {
                    sb.append("[...]");
                    continue;
                }
                Object[] newArray = (Object[])elem;
                Object[] newOrigArrays = new Object[origArrays.length + 1];
                System.arraycopy(origArrays, 0, newOrigArrays, 0, origArrays.length);
                newOrigArrays[origArrays.length] = newArray;
                Arrays.deepToStringImpl(newArray, newOrigArrays, sb);
                continue;
            }
            sb.append(array[i]);
        }
        sb.append(']');
    }

    private static boolean deepToStringImplContains(Object[] origArrays, Object array) {
        if (origArrays == null || origArrays.length == 0) {
            return false;
        }
        for (Object element : origArrays) {
            if (element != array) continue;
            return true;
        }
        return false;
    }

    public static boolean[] copyOf(boolean[] original, int newLength) {
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static char[] copyOf(char[] original, int newLength) {
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static double[] copyOf(double[] original, int newLength) {
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static float[] copyOf(float[] original, int newLength) {
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static int[] copyOf(int[] original, int newLength) {
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static long[] copyOf(long[] original, int newLength) {
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static short[] copyOf(short[] original, int newLength) {
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        return Arrays.copyOfRange(original, 0, newLength, newType);
    }

    public static boolean[] copyOfRange(boolean[] original, int start, int end) {
        int originalLength = Arrays.checkRange(start, end, original.length);
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        boolean[] result = new boolean[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static byte[] copyOfRange(byte[] original, int start, int end) {
        int originalLength = Arrays.checkRange(start, end, original.length);
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        byte[] result = new byte[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static char[] copyOfRange(char[] original, int start, int end) {
        int originalLength = Arrays.checkRange(start, end, original.length);
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        char[] result = new char[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static double[] copyOfRange(double[] original, int start, int end) {
        int originalLength = Arrays.checkRange(start, end, original.length);
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        double[] result = new double[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static float[] copyOfRange(float[] original, int start, int end) {
        int originalLength = Arrays.checkRange(start, end, original.length);
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        float[] result = new float[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static int[] copyOfRange(int[] original, int start, int end) {
        int originalLength = Arrays.checkRange(start, end, original.length);
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        int[] result = new int[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static long[] copyOfRange(long[] original, int start, int end) {
        int originalLength = Arrays.checkRange(start, end, original.length);
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        long[] result = new long[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static short[] copyOfRange(short[] original, int start, int end) {
        int originalLength = Arrays.checkRange(start, end, original.length);
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        short[] result = new short[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    @JTranscMethodBody(target="js", value={"return JA_L.copyOfRange(p0, p1, p2);"})
    public static <T> T[] copyOfRange(T[] original, int start, int end) {
        int originalLength = Arrays.checkRange(start, end, original.length);
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        T[] result = Arrays.newInstance(original, resultLength);
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    @JTranscMethodBody(target="js", value={"return JA_L.copyOfRange(p0, p1, p2, p3.name);"})
    public static <T, U> T[] copyOfRange(U[] original, int start, int end, Class<? extends T[]> newType) {
        int originalLength = Arrays.checkRange(start, end, original.length);
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        Object[] result = (Object[])Array.newInstance(newType.getComponentType(), resultLength);
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    private static int checkRange(int start, int end, int originalLength) {
        if (start > end) {
            throw new IllegalArgumentException();
        }
        if (start < 0 || start > originalLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return originalLength;
    }

    public static void parallelSort(byte[] v) {
        Arrays.sort(v);
    }

    public static void parallelSort(byte[] v, int start, int end) {
        Arrays.sort(v, start, end);
    }

    public static void parallelSort(char[] v) {
        Arrays.sort(v);
    }

    public static void parallelSort(char[] v, int start, int end) {
        Arrays.sort(v, start, end);
    }

    public static void parallelSort(short[] v) {
        Arrays.sort(v);
    }

    public static void parallelSort(short[] v, int start, int end) {
        Arrays.sort(v, start, end);
    }

    public static void parallelSort(int[] v) {
        Arrays.sort(v);
    }

    public static void parallelSort(int[] v, int start, int end) {
        Arrays.sort(v, start, end);
    }

    public static void parallelSort(long[] v) {
        Arrays.sort(v);
    }

    public static void parallelSort(long[] v, int start, int end) {
        Arrays.sort(v, start, end);
    }

    public static void parallelSort(float[] v) {
        Arrays.sort(v);
    }

    public static void parallelSort(float[] v, int start, int end) {
        Arrays.sort(v, start, end);
    }

    public static void parallelSort(double[] v) {
        Arrays.sort(v);
    }

    public static void parallelSort(double[] v, int start, int end) {
        Arrays.sort(v, start, end);
    }

    public static <T extends Comparable<? super T>> void parallelSort(T[] v) {
        Arrays.sort(v);
    }

    public static <T extends Comparable<? super T>> void parallelSort(T[] v, int start, int end) {
        Arrays.sort(v, start, end);
    }

    public static <T extends Comparable<? super T>> void parallelSort(T[] v, Comparator<T> comparator) {
        Arrays.sort(v, comparator);
    }

    public static <T extends Comparable<? super T>> void parallelSort(T[] v, int start, int end, Comparator<T> comparator) {
        Arrays.sort(v, start, end, comparator);
    }

    private static <T> T[] newInstance(T[] baseType, int size) {
        return (Object[])Array.newInstance(baseType.getClass().getComponentType(), size);
    }

    private static class ArrayList<E>
    extends AbstractList<E>
    implements List<E>,
    Serializable,
    RandomAccess {
        private final E[] a;

        ArrayList(E[] storage) {
            if (storage == null) {
                throw new NullPointerException("storage == null");
            }
            this.a = storage;
        }

        @Override
        public boolean contains(Object object) {
            if (object != null) {
                for (E element : this.a) {
                    if (!object.equals(element)) continue;
                    return true;
                }
            } else {
                for (E element : this.a) {
                    if (element != null) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public E get(int location) {
            try {
                return this.a[location];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public int indexOf(Object object) {
            if (object != null) {
                for (int i = 0; i < this.a.length; ++i) {
                    if (!object.equals(this.a[i])) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this.a.length; ++i) {
                    if (this.a[i] != null) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            if (object != null) {
                for (int i = this.a.length - 1; i >= 0; --i) {
                    if (!object.equals(this.a[i])) continue;
                    return i;
                }
            } else {
                for (int i = this.a.length - 1; i >= 0; --i) {
                    if (this.a[i] != null) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public E set(int location, E object) {
            E result = this.a[location];
            this.a[location] = object;
            return result;
        }

        @Override
        public int size() {
            return this.a.length;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.a.clone();
        }

        @Override
        public <T> T[] toArray(T[] contents) {
            int size = this.size();
            if (size > contents.length) {
                contents = Arrays.newInstance(contents, size);
            }
            System.arraycopy(this.a, 0, contents, 0, size);
            if (size < contents.length) {
                contents[size] = null;
            }
            return contents;
        }
    }
}

